/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.AntennaSystemProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbStaticMetaDataMap;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class SectorRI
extends AbstractResourceItem {
    public static final String name = "Sector";
    private String ldn;
    private Integer rbbMomValue;
    private int[] sectorConfiguration = null;
    private Integer momValueForLineRate;
    private int sectorNumber;
    private Boolean momValueForMixedModeRadio;

    public SectorRI(Rbs rbs, String string, int n) {
        super(name, rbs, new String[]{"SectorCreationPhase", "SectorDeletionPhase"});
        this.ldn = string;
        this.sectorNumber = n;
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            if (this.rbbMomValue == null && this.momValueForLineRate == null) {
                this.createMoIfNotExisting(this.ldn);
            } else {
                NalNameValue nalNameValue = Nal.getFactory().getNameValue("radioBuildingBlock", this.rbbMomValue);
                NalNameValue nalNameValue2 = Nal.getFactory().getNameValue("lineRate", this.momValueForLineRate);
                NalNameValue nalNameValue3 = Nal.getFactory().getNameValue("mixedModeRadio", this.momValueForMixedModeRadio);
                int n = 0;
                if (this.rbs.isPantherHybridRbs() && this.sectorNumber >= 7) {
                    n = 1;
                }
                AntennaSystemProvider antennaSystemProvider = this.getRbs().getAntennaSystemProvider(n);
                Integer n2 = new Integer(antennaSystemProvider.getNumOfSectorAntennas(this.sectorNumber));
                NalNameValue nalNameValue4 = Nal.getFactory().getNameValue("numberOfSectorAntennas", n2);
                Vector<NalNameValue> vector = new Vector<NalNameValue>();
                if (this.rbbMomValue != null) {
                    vector.add(nalNameValue);
                }
                if (this.momValueForLineRate != null) {
                    vector.add(nalNameValue2);
                }
                if (this.momValueForMixedModeRadio != null) {
                    vector.add(nalNameValue3);
                }
                if (this.sectorConfiguration != null && this.sectorConfiguration.length > 0) {
                    NalNameValue nalNameValue5 = Nal.getFactory().getNameValue("sectorConfiguration", this.sectorConfiguration);
                    vector.add(nalNameValue5);
                }
                vector.add(nalNameValue4);
                this.createMoIfNotExisting(this.ldn, vector);
                this.updateChangedIntegerAttribute("radioBuildingBlock", this.rbbMomValue);
                this.updateChangedIntegerAttribute("lineRate", this.momValueForLineRate);
                this.updateChangedIntegerAttribute("numberOfSectorAntennas", n2);
                this.updateChangedIntArrayAttribute("sectorConfiguration", this.sectorConfiguration);
                this.updateChangedBooleanAttribute("mixedModeRadio", this.momValueForMixedModeRadio);
            }
        }
    }

    private void updateChangedBooleanAttribute(String string, Boolean bl) throws BemException {
        boolean bl2;
        Boolean bl3;
        boolean bl4;
        if (bl != null && (bl4 = (bl3 = (Boolean)this.getAttribute(string)).booleanValue()) != (bl2 = bl.booleanValue())) {
            super.setAttribute(this.ldn, string, (Object)bl);
        }
    }

    private void updateChangedIntegerAttribute(String string, Integer n) throws BemException {
        int n2;
        Integer n3;
        int n4;
        if (n != null && this.rbs.getRbsStep() != "STEP_OAM" && (n4 = (n3 = (Integer)this.getAttribute(string)).intValue()) != (n2 = n.intValue())) {
            super.setAttribute(this.ldn, string, (Object)n);
        }
    }

    private void updateChangedIntArrayAttribute(String string, int[] nArray) throws BemException {
        Object object = this.getAttribute(string);
        int[] nArray2 = (int[])object;
        int[] nArray3 = null;
        if (nArray2 == null || nArray2.length == 0) {
            nArray3 = new int[]{};
        } else {
            nArray3 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray3[i] = nArray2[i];
            }
        }
        if (nArray != null && !this.isEqual(nArray3, nArray)) {
            super.setAttribute(this.ldn, string, (Object)nArray);
        }
    }

    private boolean isEqual(int[] nArray, int[] nArray2) {
        if (nArray != null && nArray.length != 0 && (nArray2 == null || nArray2.length == 0)) {
            return false;
        }
        if (nArray == null || nArray.length == 0 && nArray2 != null && nArray2.length != 0) {
            return false;
        }
        if (nArray != null && nArray.length != 0 && nArray2 != null && nArray2.length != 0) {
            int n;
            if (nArray.length != nArray2.length) {
                return false;
            }
            int n2 = 0;
            int n3 = 0;
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] != 0) {
                    ++n2;
                }
                if (nArray2[n] == 0) continue;
                ++n3;
            }
            if (n2 != n3) {
                return false;
            }
            for (n = 0; n < nArray.length; ++n) {
                boolean bl = false;
                for (int i = 0; i < nArray2.length; ++i) {
                    if (nArray[n] != nArray2[i]) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public void uninstall(String string) throws BemException {
        if (string.equals("SectorDeletionPhase")) {
            this.deleteMoIfNotExisting(this.ldn);
        }
    }

    public String getLdn() {
        return this.ldn;
    }

    public int getSectorNumber() {
        return this.sectorNumber;
    }

    public String getDisplayName() {
        return "Sector:" + this.ldn;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SectorRI)) {
            return false;
        }
        SectorRI sectorRI = (SectorRI)object;
        String string = this.getLdn();
        String string2 = sectorRI.getLdn();
        return string.equals(string2);
    }

    public int hashCode() {
        return this.getLdn().hashCode() * 11;
    }

    public Object getAttribute(String string) throws BemException {
        MoHandler moHandler = this.rbs.getMoHandler();
        BemMo bemMo = moHandler.getMo(this.ldn);
        Object object = null;
        try {
            object = moHandler.getAttribute(bemMo, string);
        }
        catch (Exception exception) {
            throw new BemException("SectorRI.getAttribute()", "getAttribute()", this.ldn, null, exception);
        }
        return object;
    }

    public void setRadioBuildingBlock(Integer n) {
        this.rbbMomValue = n;
    }

    public void setSectorConfiguration(int[] nArray) {
        if (nArray != null) {
            this.sectorConfiguration = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                this.sectorConfiguration[i] = nArray[i];
            }
        } else {
            this.sectorConfiguration = new int[0];
        }
    }

    public void setLineRate(Integer n) {
        this.momValueForLineRate = n;
    }

    public void setMixedModeRadio(Boolean bl) {
        this.momValueForMixedModeRadio = bl;
    }

    public Integer getLoadedLineRate() throws BemException {
        Integer n = (Integer)this.getAttribute("lineRate");
        return n;
    }

    public Integer getLoadedSectorConfiguration() throws BemException {
        Integer n = (Integer)this.getAttribute("sectorConfiguration");
        return n;
    }

    public String getLoadedRadioBuildingBlockName() throws BemException {
        Integer n = (Integer)this.getAttribute("radioBuildingBlock");
        return (String)RbbStaticMetaDataMap.RBB_VALUE_MAP_TO_NAME.get(n);
    }

    public Boolean getLoadedMixedModeRadio() throws BemException {
        Boolean bl = (Boolean)this.getAttribute("mixedModeRadio");
        return bl;
    }
}

