/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.hspamgmt;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.AbstractConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.HsdpaResourcesListener;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.HsdpaResourcesProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.NumEulResourcesParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.NumHsCodeResourcesParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.hspamgmt.HspaSettingsRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

public class HspaResourcesManager
implements HsdpaResourcesProvider {
    private NumHsCodeResourcesParameter[] numHsCodeResourcesParameter;
    private NumEulResourcesParameter[] numEulResourcesParameter;
    private NumHsCodeResourcesParameter[] staticNumHsCodeResourcesParameter;
    private NumEulResourcesParameter[] staticNumEulResourcesParameter;
    private NumHsCodeResourcesParameter[] numHsCodeResources1stBBPParameter;
    private NumHsCodeResourcesParameter[] numHsCodeResources2ndBBPParameter;
    private ParameterRestriction[] noEulWithoutHSmodulRestriction;
    private ParameterRestriction[] eulRangeRestriction;
    private List[] hsdpaResourcesListeners;
    private List[] eulResourcesListeners;
    private HspaSettingsRI[] hspaSettingsRi;
    private ArrayList allHspaRis = new ArrayList();
    private int[] slotNumbers;
    private int numberOfSupportedDuwSlots = 1;
    private ArrayList allPseudoNames = new ArrayList();
    private boolean eulSupportInTwoBaseBandPools = true;
    private static final String NO_EUL_WITHOUT_HS_MODULE_RESTRICTION_STRING = "Only allowed to have EUL if\n there is at least one HS module in the baseband pool where EUL is activated.";
    private static final String ONLY_ONE_EUL_RESOURCE_STRING = "Only allowed to configure one EUL resource per RBS with current configuration";
    private ParameterRestriction[] hspaResourcesIgnoredRestriction = null;
    private ParameterRestriction[] hspaResourcesPerBbpIgnoredRestriction = null;

    public HspaResourcesManager(AbstractConfigurationItem abstractConfigurationItem, int[] nArray) throws BemException {
        this.slotNumbers = nArray;
        this.numberOfSupportedDuwSlots = nArray.length;
        this.numHsCodeResourcesParameter = new NumHsCodeResourcesParameter[this.numberOfSupportedDuwSlots];
        this.numHsCodeResources1stBBPParameter = new NumHsCodeResourcesParameter[this.numberOfSupportedDuwSlots];
        this.numHsCodeResources2ndBBPParameter = new NumHsCodeResourcesParameter[this.numberOfSupportedDuwSlots];
        this.numEulResourcesParameter = new NumEulResourcesParameter[this.numberOfSupportedDuwSlots];
        this.staticNumHsCodeResourcesParameter = new NumHsCodeResourcesParameter[this.numberOfSupportedDuwSlots];
        this.staticNumEulResourcesParameter = new NumEulResourcesParameter[this.numberOfSupportedDuwSlots];
        this.noEulWithoutHSmodulRestriction = new ParameterRestriction[this.numberOfSupportedDuwSlots];
        this.eulRangeRestriction = new ParameterRestriction[this.numberOfSupportedDuwSlots];
        this.hsdpaResourcesListeners = new ArrayList[this.numberOfSupportedDuwSlots];
        this.eulResourcesListeners = new ArrayList[this.numberOfSupportedDuwSlots];
        this.hspaSettingsRi = new HspaSettingsRI[this.numberOfSupportedDuwSlots];
        this.hspaResourcesIgnoredRestriction = new ParameterRestriction[this.numberOfSupportedDuwSlots];
        this.hspaResourcesPerBbpIgnoredRestriction = new ParameterRestriction[this.numberOfSupportedDuwSlots];
        for (int i = 0; i < this.numberOfSupportedDuwSlots; ++i) {
            this.hspaResourcesIgnoredRestriction[i] = new ParameterRestriction("numHsResources and numEulResources ignored for DUWv2", 1);
            this.hspaResourcesIgnoredRestriction[i].setActive(false);
            this.hspaResourcesPerBbpIgnoredRestriction[i] = new ParameterRestriction("numHsCodeResources1stBBP and numHsCodeResources2ndBBP ignored other than Primary DUW30", 1);
            this.hspaResourcesPerBbpIgnoredRestriction[i].setActive(false);
            this.hsdpaResourcesListeners[i] = new ArrayList();
            this.eulResourcesListeners[i] = new ArrayList();
            this.createHspaResources(abstractConfigurationItem, nArray[i]);
        }
    }

    public void addListener(HsdpaResourcesListener hsdpaResourcesListener) {
        for (int i = 0; i < this.numberOfSupportedDuwSlots; ++i) {
            this.addListener(hsdpaResourcesListener, this.slotNumbers[i]);
        }
    }

    public List getAllHspaResourceItems() {
        return this.allHspaRis;
    }

    private void createHspaResources(AbstractConfigurationItem abstractConfigurationItem, int n) throws BemException {
        String string;
        String string2;
        String string3;
        String string4;
        if (n != 0 && n != 1) {
            throw new BemException("Programming error illegal Duw Slot value");
        }
        int n2 = this.getDuwSlotIndexFromNumber(n);
        if (n == 0) {
            string4 = DuwUtil.getPrimaryDuwPiuLdn();
            string3 = DuwUtil.getSlotNumberForPrimaryDuw();
            string2 = DuwUtil.getPrimaryDuw1stBBPLdn();
            string = DuwUtil.getPrimaryDuw2ndBBPLdn();
        } else {
            string4 = DuwUtil.getSecondaryDuwPiuLdn();
            string3 = DuwUtil.getSlotNumberForSecondaryDuw();
            string2 = DuwUtil.getSecondaryDuw1stBBPLdn();
            string = DuwUtil.getSecondaryDuw2ndBBPLdn();
        }
        String string5 = this.setNumEulResourcesParameter(n, string3);
        String string6 = this.setNumHsCodeResourcesParameter(abstractConfigurationItem, n, string3);
        String string7 = this.setStaticNumEulResourcesParameter(n, string3);
        String string8 = this.setStaticNumHsCodeResourcesParameter(n, string3);
        String string9 = this.setNumHsCodeResources1stBBPParameter(n, string3);
        String string10 = this.setNumHsCodeResources2ndBBPParameter(n, string3);
        this.hspaSettingsRi[n2] = new HspaSettingsRI(abstractConfigurationItem.getRbs(), string4, string2, string, this.numEulResourcesParameter[n2], this.numHsCodeResourcesParameter[n2], this.staticNumEulResourcesParameter[n2], this.staticNumHsCodeResourcesParameter[n2], this.numHsCodeResources1stBBPParameter[n2], this.numHsCodeResources2ndBBPParameter[n2]);
        this.allPseudoNames.add(string6);
        this.allPseudoNames.add(string5);
        this.allPseudoNames.add(string7);
        this.allPseudoNames.add(string8);
        this.allPseudoNames.add(string9);
        this.allPseudoNames.add(string10);
        this.allHspaRis.add(this.hspaSettingsRi[n2]);
        abstractConfigurationItem.addParameter(this.numHsCodeResourcesParameter[n2]);
        abstractConfigurationItem.addParameter(this.numEulResourcesParameter[n2]);
        abstractConfigurationItem.addParameter(this.staticNumHsCodeResourcesParameter[n2]);
        abstractConfigurationItem.addParameter(this.staticNumEulResourcesParameter[n2]);
        abstractConfigurationItem.addParameter(this.numHsCodeResources1stBBPParameter[n2]);
        abstractConfigurationItem.addParameter(this.numHsCodeResources2ndBBPParameter[n2]);
    }

    private String setNumHsCodeResources1stBBPParameter(int n, String string) throws BemException {
        int n2 = this.getDuwSlotIndexFromNumber(n);
        String[] stringArray = DuwUtil.getNumHsResourcesPerBasebandPoolRange();
        String string2 = MessageFormat.format("hsSlot{0}_numHsCodeResources1stBBP", string);
        EnumeratedRange enumeratedRange = new EnumeratedRange(stringArray);
        this.numHsCodeResources1stBBPParameter[n2] = new NumHsCodeResourcesParameter(string2, enumeratedRange);
        this.numHsCodeResources1stBBPParameter[n2].setTxSlot(Integer.parseInt(string));
        this.numHsCodeResources1stBBPParameter[n2].addRestriction(this.hspaResourcesPerBbpIgnoredRestriction[n2]);
        return string2;
    }

    private String setNumHsCodeResources2ndBBPParameter(int n, String string) throws BemException {
        int n2 = this.getDuwSlotIndexFromNumber(n);
        String[] stringArray = DuwUtil.getNumHsResourcesPerBasebandPoolRange();
        String string2 = MessageFormat.format("hsSlot{0}_numHsCodeResources2ndBBP", string);
        EnumeratedRange enumeratedRange = new EnumeratedRange(stringArray);
        this.numHsCodeResources2ndBBPParameter[n2] = new NumHsCodeResourcesParameter(string2, enumeratedRange);
        this.numHsCodeResources2ndBBPParameter[n2].setTxSlot(Integer.parseInt(string));
        this.numHsCodeResources2ndBBPParameter[n2].addRestriction(this.hspaResourcesPerBbpIgnoredRestriction[n2]);
        return string2;
    }

    private String setNumHsCodeResourcesParameter(AbstractConfigurationItem abstractConfigurationItem, int n, String string) throws BemException {
        int n2 = this.getDuwSlotIndexFromNumber(n);
        String[] stringArray = n == 0 ? DuwUtil.getNumHsResoucesRangePrimaryDuw() : DuwUtil.getNumHsResoucesRangeSecondaryDuw();
        String string2 = MessageFormat.format("hsSlot{0}_numHsCodeResources", string);
        EnumeratedRange enumeratedRange = new EnumeratedRange(stringArray);
        this.numHsCodeResourcesParameter[n2] = new NumHsCodeResourcesParameter(string2, enumeratedRange);
        this.numHsCodeResourcesParameter[n2].setTxSlot(Integer.parseInt(string));
        this.numHsCodeResourcesParameter[n2].addCustomerParameterListener(new NumOfHsCodeResourcesListener(this, n));
        if (abstractConfigurationItem.getRbs().getRbsStep().equals("STEP_CABINET")) {
            ParameterRestriction parameterRestriction = new ParameterRestriction("Not settable in Cabinet Equipment wizard", 1);
            parameterRestriction.setActive(true);
            this.numHsCodeResourcesParameter[n2].addRestriction(parameterRestriction);
        }
        this.numHsCodeResourcesParameter[n2].addRestriction(this.hspaResourcesIgnoredRestriction[n2]);
        return string2;
    }

    private String setNumEulResourcesParameter(int n, String string) throws BemException {
        ParameterRestriction parameterRestriction;
        int n2 = this.getDuwSlotIndexFromNumber(n);
        String[] stringArray = DuwUtil.getNumEulResourcesRange();
        String[] stringArray2 = new String[]{"0"};
        String string2 = MessageFormat.format("eulSlot{0}_numEulResources", string);
        EnumeratedRange enumeratedRange = new EnumeratedRange(stringArray);
        EnumeratedRange enumeratedRange2 = new EnumeratedRange(stringArray2);
        NumEulResourcesParameter numEulResourcesParameter = new NumEulResourcesParameter(string2, enumeratedRange);
        numEulResourcesParameter.setTxSlot(Integer.parseInt(string));
        ParameterRestriction parameterRestriction2 = new ParameterRestriction(NO_EUL_WITHOUT_HS_MODULE_RESTRICTION_STRING, enumeratedRange2, true);
        parameterRestriction2.setActive(true);
        numEulResourcesParameter.addRestriction(parameterRestriction2);
        EnumeratedRange enumeratedRange3 = new EnumeratedRange(stringArray);
        this.eulRangeRestriction[n2] = parameterRestriction = new ParameterRestriction(ONLY_ONE_EUL_RESOURCE_STRING, enumeratedRange3, true);
        if (this.numberOfSupportedDuwSlots > 1) {
            numEulResourcesParameter.addRestriction(parameterRestriction);
            EulResourcesListener eulResourcesListener = new EulResourcesListener(this, n);
            numEulResourcesParameter.addCustomerParameterListener(eulResourcesListener);
            this.addEulListener(eulResourcesListener, n);
        }
        this.noEulWithoutHSmodulRestriction[n2] = parameterRestriction2;
        this.numEulResourcesParameter[n2] = numEulResourcesParameter;
        this.numEulResourcesParameter[n2].addRestriction(this.hspaResourcesIgnoredRestriction[n2]);
        return string2;
    }

    private String setStaticNumHsCodeResourcesParameter(int n, String string) throws BemException {
        int n2 = this.getDuwSlotIndexFromNumber(n);
        String string2 = MessageFormat.format("hsSlot{0}_staticNumHsCodeResources", string);
        ParameterRestriction parameterRestriction = new ParameterRestriction("DUW v2 readonly", 0);
        EnumeratedRange enumeratedRange = new EnumeratedRange(DuwUtil.getStaticNumHsResoucesRange());
        this.staticNumHsCodeResourcesParameter[n2] = new NumHsCodeResourcesParameter(string2, enumeratedRange);
        this.staticNumHsCodeResourcesParameter[n2].setTxSlot(Integer.parseInt(string));
        this.staticNumHsCodeResourcesParameter[n2].addRestriction(parameterRestriction);
        return string2;
    }

    private String setStaticNumEulResourcesParameter(int n, String string) throws BemException {
        int n2 = this.getDuwSlotIndexFromNumber(n);
        String string2 = MessageFormat.format("eulSlot{0}_staticNumEulResources", string);
        ParameterRestriction parameterRestriction = new ParameterRestriction("DUW v2 readonly", 0);
        EnumeratedRange enumeratedRange = new EnumeratedRange(DuwUtil.getStaticNumEulResourcesRange());
        NumEulResourcesParameter numEulResourcesParameter = new NumEulResourcesParameter(string2, enumeratedRange);
        numEulResourcesParameter.setTxSlot(Integer.parseInt(string));
        numEulResourcesParameter.addRestriction(parameterRestriction);
        this.staticNumEulResourcesParameter[n2] = numEulResourcesParameter;
        return string2;
    }

    public void updateLoadedValues() throws BemException {
        for (int i = 0; i < this.numberOfSupportedDuwSlots; ++i) {
            this.hspaSettingsRi[i].updateLoadedValue();
        }
    }

    public void setParameterRestrictions() throws BemException {
        for (int i = 0; i < this.numberOfSupportedDuwSlots; ++i) {
            if (!this.isTxbStaticallyLoaded(this.slotNumbers[i])) continue;
            this.hspaResourcesIgnoredRestriction[i].setActive(true);
        }
        if (!DuwUtil.isPrimaryDuw30()) {
            this.hspaResourcesPerBbpIgnoredRestriction[0].setActive(true);
        }
        if (this.numberOfSupportedDuwSlots > 1) {
            this.hspaResourcesPerBbpIgnoredRestriction[1].setActive(true);
        }
    }

    public void checkConsistency() throws BemException {
        boolean bl = false;
        for (int i = 0; i < this.numberOfSupportedDuwSlots; ++i) {
            String string;
            if (this.numEulResourcesParameter[i].getAccessLevel() != 1) {
                string = this.numEulResourcesParameter[i].getValue();
                if (string.equals("1")) {
                    if (bl && !this.eulSupportInTwoBaseBandPools) {
                        throw new BemException("Only one EUL resource can be set for one RBS");
                    }
                    bl = true;
                } else if (!string.equals("") && !string.equals("0")) {
                    throw new BemException("Unsupported value set for EUL resource. Value set=" + string);
                }
            }
            string = this.staticNumHsCodeResourcesParameter[i].getValue();
            String string2 = this.staticNumEulResourcesParameter[i].getValue();
            if (!string.equals("-1") && !string2.equals("-1") || string.equals("-1") && string2.equals("-1")) continue;
            throw new BemException("Configuration data error in EC:  staticNumHsCodeResources and staticNumEulResources should be both -1(for DUW V1) or both non -1(for DUW V2).");
        }
    }

    public void addListener(HsdpaResourcesListener hsdpaResourcesListener, int n) {
        int n2 = this.getDuwSlotIndexFromNumber(n);
        this.hsdpaResourcesListeners[n2].add(hsdpaResourcesListener);
    }

    public void addEulListener(EulResourcesListener eulResourcesListener, int n) {
        int n2 = this.getDuwSlotIndexFromNumber(n);
        this.eulResourcesListeners[n2].add(eulResourcesListener);
    }

    private int getDuwSlotIndexFromNumber(int n) {
        for (int i = 0; i < this.slotNumbers.length; ++i) {
            if (this.slotNumbers[i] != n) continue;
            return i;
        }
        return -1;
    }

    public int getSumOfHsCodeResources(int n) throws BemException {
        int n2 = 0;
        for (int i = 0; i < this.numHsCodeResourcesParameter.length; ++i) {
            if (this.numHsCodeResourcesParameter[i].getSlot() != n) continue;
            String string = this.numHsCodeResourcesParameter[i].getValue();
            n2 = Integer.parseInt(string);
            break;
        }
        return n2;
    }

    private boolean isCpSet(String string) {
        boolean bl = true;
        if (string == null || string.equals("") || string.equals("##UNDEFINED")) {
            bl = false;
        }
        return bl;
    }

    public void setNoEulWithoutHSmodulRestrictionActive(boolean bl, int n) {
        int n2 = this.getDuwSlotIndexFromNumber(n);
        ParameterRestriction parameterRestriction = this.noEulWithoutHSmodulRestriction[n2];
        parameterRestriction.setActive(bl);
    }

    public List getNumHsResourcesListener(int n) {
        int n2 = this.getDuwSlotIndexFromNumber(n);
        return this.hsdpaResourcesListeners[n2];
    }

    public List getEulResourcesListener(int n) {
        int n2 = this.getDuwSlotIndexFromNumber(n);
        return this.eulResourcesListeners[n2];
    }

    public ArrayList getAllCpPseudoNames() {
        return this.allPseudoNames;
    }

    public void setEulSupportInTwoBaseBandPools(boolean bl) {
        this.eulSupportInTwoBaseBandPools = bl;
    }

    private void setEulRange(EnumeratedRange enumeratedRange, int n) {
        int n2 = this.getDuwSlotIndexFromNumber(n);
        this.eulRangeRestriction[n2].setRange(enumeratedRange, true);
    }

    public boolean isTxbStaticallyLoaded(int n) throws BemException {
        if (n < 0 && n > this.numberOfSupportedDuwSlots) {
            throw new BemException("No Duw board with number " + n);
        }
        int n2 = this.getDuwSlotIndexFromNumber(n);
        boolean bl = false;
        NumHsCodeResourcesParameter numHsCodeResourcesParameter = this.staticNumHsCodeResourcesParameter[n2];
        if (!numHsCodeResourcesParameter.getValue().equals("-1")) {
            bl = true;
        }
        return bl;
    }

    private static class NumOfHsCodeResourcesListener
    implements CustomerParameterListener {
        private HspaResourcesManager hspaResourcesManager;
        private int slotNumber;

        public NumOfHsCodeResourcesListener(HspaResourcesManager hspaResourcesManager, int n) {
            this.hspaResourcesManager = hspaResourcesManager;
            this.slotNumber = n;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged()) {
                int n = customerParameter.getAccessLevel();
                if (n == 0) {
                    return;
                }
                String string = customerParameter.getValue();
                if (!this.hspaResourcesManager.isCpSet(string) || string.equals("0")) {
                    this.hspaResourcesManager.setNoEulWithoutHSmodulRestrictionActive(true, this.slotNumber);
                } else {
                    this.hspaResourcesManager.setNoEulWithoutHSmodulRestrictionActive(false, this.slotNumber);
                }
                try {
                    this.notifyHsdpaEquipmentListeners(customerParameter);
                }
                catch (BemException bemException) {
                    throw new RuntimeException(bemException.toString());
                }
            }
        }

        private void notifyHsdpaEquipmentListeners(CustomerParameter customerParameter) throws BemException {
            Iterator iterator = this.hspaResourcesManager.getNumHsResourcesListener(this.slotNumber).iterator();
            while (iterator.hasNext()) {
                HsdpaResourcesListener hsdpaResourcesListener = (HsdpaResourcesListener)iterator.next();
                try {
                    hsdpaResourcesListener.update();
                }
                catch (Exception exception) {
                    throw new BemException("notifyHsdpaEquipmentListeners(): " + hsdpaResourcesListener.getClass().getName(), "", (Throwable)exception);
                }
            }
        }
    }

    private class EulResourcesListener
    implements CustomerParameterListener {
        private HspaResourcesManager hspaResourcesManager;
        private int slotNumber;
        private String[] range = new String[]{"0", "1"};
        private String[] restrictedRange = new String[]{"0"};
        private EnumeratedRange rangeAll = new EnumeratedRange(this.range);
        private EnumeratedRange rangeRestricted = new EnumeratedRange(this.restrictedRange);

        public EulResourcesListener(HspaResourcesManager hspaResourcesManager2, int n) {
            this.hspaResourcesManager = hspaResourcesManager2;
            this.slotNumber = n;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            String string = customerParameter.getValue();
            if (parameterEvent.isValueChanged()) {
                if (this.slotNumber == 0) {
                    if (string.equals("1")) {
                        HspaResourcesManager.this.setEulRange(this.rangeAll, 0);
                        if (!HspaResourcesManager.this.eulSupportInTwoBaseBandPools) {
                            HspaResourcesManager.this.setEulRange(this.rangeRestricted, 1);
                        }
                    } else if (string.equals("0")) {
                        HspaResourcesManager.this.setEulRange(this.rangeAll, 0);
                        if (!HspaResourcesManager.this.eulSupportInTwoBaseBandPools) {
                            HspaResourcesManager.this.setEulRange(this.rangeAll, 1);
                        }
                    }
                }
                if (this.slotNumber == 1) {
                    if (string.equals("1")) {
                        HspaResourcesManager.this.setEulRange(this.rangeAll, 1);
                        if (!HspaResourcesManager.this.eulSupportInTwoBaseBandPools) {
                            HspaResourcesManager.this.setEulRange(this.rangeRestricted, 0);
                        }
                    } else if (string.equals("0")) {
                        HspaResourcesManager.this.setEulRange(this.rangeAll, 1);
                        if (!HspaResourcesManager.this.eulSupportInTwoBaseBandPools) {
                            HspaResourcesManager.this.setEulRange(this.rangeAll, 0);
                        }
                    }
                }
                try {
                    this.notifyEulListeners(customerParameter, parameterEvent);
                }
                catch (BemException bemException) {
                    throw new RuntimeException(bemException.toString());
                }
            }
        }

        private void notifyEulListeners(CustomerParameter customerParameter, ParameterEvent parameterEvent) throws BemException {
            Iterator iterator = this.hspaResourcesManager.getEulResourcesListener(this.slotNumber).iterator();
            while (iterator.hasNext()) {
                EulResourcesListener eulResourcesListener = (EulResourcesListener)iterator.next();
            }
        }
    }
}

