/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt;

import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRuRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAiDevice;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAiDeviceSet;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRbsSlot;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRruDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemLdn;

public class IruRI
extends AbstractRuRI {
    public static final String name = "IRU";
    public static final String AU_TYPE_IRU = "IRU";
    public static final String IRU_RDN_PREFIX = "IRU-";
    private static final String PIU_TYPE_PRODUCT_NAME = "IRU";
    public static final String SW_ALLOCATION_ROLE_IRU = "RBS_IRU";
    public static final String REPERTOIRE_NAME_IRU = "RBS_IRU";
    private boolean lockSecondAiDevice = false;
    private String auxPiuLdn;
    private String rruDeviceGroupLdn = null;
    private int slotNumber;
    private String auxPiuId;

    public IruRI(Rbs rbs, int n, int n2, String string, int n3) {
        super("IRU", rbs, 27, "IRU", string, n3, n, n2);
        this.setSwLoadable(true);
        this.setRoleForSwAllocation("RBS_IRU");
        this.addRepertoiresToInstall("RBS_IRU");
        this.auxPiuId = IRU_RDN_PREFIX + n2;
        this.auxPiuLdn = BemLdn.LDN_EQUIPMENT + "," + MimAuxPlugInUnit.MOTYPENAME + "=" + "IRU" + "-" + n + "-" + n2;
        this.rruDeviceGroupLdn = this.auxPiuLdn + "," + MimRruDeviceGroup.MOTYPENAME + "=" + "IRU";
    }

    public void install(String string) throws BemException {
        super.install(string);
        if (string.equals("LockPhase") || string.equals("UnlockPhase")) {
            this.lockOrUnlockSecondAiDevice();
        }
    }

    public void setSecondAiLocked(boolean bl) {
        this.lockSecondAiDevice = bl;
    }

    private void lockOrUnlockSecondAiDevice() throws BemException {
        try {
            MoHandler moHandler = this.rbs.getMoHandler();
            String string = this.rruDeviceGroupLdn + "," + MimAiDeviceSet.MOTYPENAME + "=1," + MimAiDevice.MOTYPENAME + "=2";
            BemMo bemMo = moHandler.getMo(string);
            Integer n = (Integer)moHandler.getAttribute(bemMo, "administrativeState");
            if (this.lockSecondAiDevice) {
                if (n != null && n == 1) {
                    moHandler.setAttribute(bemMo, "administrativeState", new Integer(0));
                }
            } else if (n != null && n == 0) {
                moHandler.setAttribute(bemMo, "administrativeState", new Integer(1));
            }
        }
        catch (MoHandlerException moHandlerException) {
            String string = moHandlerException.getAction();
            throw new BemException(string, this.auxPiuLdn, (Throwable)moHandlerException);
        }
    }

    public String getLdn() {
        return this.rruDeviceGroupLdn;
    }

    public String getAuxPiuLdn() {
        return this.auxPiuLdn;
    }

    protected BemMo getAuxPiuMo() throws BemException {
        return this.getMo(this.auxPiuLdn);
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public String getDisplayName() {
        return "IRU:" + this.rruDeviceGroupLdn;
    }

    public void setSlotNumber(String string, int n, int n2, boolean bl) {
        if (bl) {
            this.auxPiuLdn = string + "," + MimRbsSlot.MOTYPENAME + "=" + n + "," + MimAuxPlugInUnit.MOTYPENAME + "=" + this.auxPiuId;
            this.slotNumber = n;
        } else {
            this.auxPiuLdn = BemLdn.LDN_EQUIPMENT + "," + MimAuxPlugInUnit.MOTYPENAME + "=" + "IRU" + "-" + n2 + "-" + this.getSequenceNumber();
        }
        this.rruDeviceGroupLdn = this.auxPiuLdn + "," + MimRruDeviceGroup.MOTYPENAME + "=" + "IRU";
    }

    protected void deleteMoIfExisting(String string) throws BemException {
        MoHandler moHandler = this.rbs.getMoHandler();
        try {
            BemLog.log(7, "IRU" + " deleteMoIfExisting()");
            moHandler.deleteMoIfExisting(string);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("ManagedObject", string);
            bemException.setProperty("Failing Method", "deleteMoIfExisting()");
            throw bemException;
        }
    }

    protected void createMoIfExisting(String string) throws BemException {
        MoHandler moHandler = this.rbs.getMoHandler();
        try {
            BemLog.log(7, "IRU" + " deleteMoIfExisting()");
            moHandler.createMoIfNotExisting(string);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ResourceItem  (RI)", this.getDisplayName());
            bemException.setProperty("ManagedObject", string);
            bemException.setProperty("Failing Method", "createMoIfExisting()");
            throw bemException;
        }
    }
}

