/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.DigitalCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.FreeConnectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.FuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RadioInterfaceBoard;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.ReservedConnectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RfCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.AbstractCableSet;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.AbstractRadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRfCable;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class RB4b
extends AbstractRadioBuildingBlock {
    public static final String name = "RB4b";
    public static final String guiName = "RB4";
    private static final int NO_OF_CARRIERS = 2;
    private static final int NO_OF_RUS = 1;
    private static final int NO_OF_TX_BRANCHES = 1;
    private static final int NOT_USED = -1;
    private Rbs rbs;
    private List ris = new ArrayList();
    private DigitalCableRI digitalCable1 = null;
    private DigitalCableRI digitalCable2 = null;
    private RfCableRI txRfCable = null;
    private RfCableRI rxARfCable = null;
    private RfCableRI rxBRfCable = null;
    private FuRI fu = null;
    private RuRI ru = null;
    private RadioInterfaceBoard ruif1 = null;
    private RadioInterfaceBoard ruif2 = null;
    private int[][] carriersInBaseBandPool = new int[][]{{1}, {2}};
    private int dcElectricalDelay;
    private int rfElectricalUlDelay;
    private int rfElectricalDlDelay;
    private int rfUlAttenuation;
    private int rfDlAttenuation;
    List freeConnectors;
    ReservedConnectorRI[][] reservedConnectors;

    public RB4b(Rbs rbs, int n, FuRI fuRI, RuRI ruRI, RadioInterfaceBoard radioInterfaceBoard, RadioInterfaceBoard radioInterfaceBoard2, int n2, int n3, int n4, int n5, int n6) throws BemException {
        super(name, n, 2, 1, 1, new RadioInterfaceBoard[]{radioInterfaceBoard, radioInterfaceBoard2});
        this.rbs = rbs;
        this.ru = ruRI;
        this.fu = fuRI;
        this.ruif1 = radioInterfaceBoard;
        this.ruif2 = radioInterfaceBoard2;
        this.dcElectricalDelay = n2;
        this.rfElectricalUlDelay = n3;
        this.rfElectricalDlDelay = n4;
        this.rfUlAttenuation = n5;
        this.rfDlAttenuation = n6;
        this.createResourceItems();
    }

    public void setRadioIfConnectors(ReservedConnectorRI reservedConnectorRI, ReservedConnectorRI reservedConnectorRI2, ReservedConnectorRI reservedConnectorRI3, ReservedConnectorRI reservedConnectorRI4, ReservedConnectorRI reservedConnectorRI5, ReservedConnectorRI reservedConnectorRI6) {
        ReservedConnectorRI[][] reservedConnectorRIArrayArray = new ReservedConnectorRI[][]{{reservedConnectorRI6, reservedConnectorRI5}, {reservedConnectorRI4, reservedConnectorRI3}, {reservedConnectorRI2, reservedConnectorRI}, {reservedConnectorRI6, reservedConnectorRI5}, {reservedConnectorRI4, reservedConnectorRI3}, {reservedConnectorRI2, reservedConnectorRI}};
        this.reservedConnectors = reservedConnectorRIArrayArray;
    }

    private void createResourceItems() throws BemException {
        this.ris.add(this.ru);
        this.ris.add(this.fu);
        this.freeConnectors = new ArrayList();
        String string = this.fu.getAuxPiuLdn();
        this.freeConnectors.add(new FreeConnectorRI(this.rbs, string, 8, MimRfCable.MOTYPENAME, "objectAConnector"));
        this.digitalCable1 = new DigitalCableRI(this.rbs, this.ruif1.getLdn(), this.getDigitalCableConnectorA(1), this.ru.getLdn(), 1, this.dcElectricalDelay);
        this.ris.add(this.digitalCable1);
        this.digitalCable2 = new DigitalCableRI(this.rbs, this.ruif2.getLdn(), this.getDigitalCableConnectorA(1), this.ru.getLdn(), 2, this.dcElectricalDelay);
        this.ris.add(this.digitalCable2);
        this.txRfCable = new RfCableRI(this.rbs, this.ru.getLdn(), 11, this.fu.getLdn(), 17, -1, this.rfElectricalDlDelay, -1, this.rfDlAttenuation);
        this.ris.add(this.txRfCable);
        this.rxARfCable = new RfCableRI(this.rbs, this.fu.getLdn(), 6, this.ru.getLdn(), 3, this.rfElectricalUlDelay, -1, this.rfUlAttenuation, -1);
        this.ris.add(this.rxARfCable);
        this.rxBRfCable = new RfCableRI(this.rbs, this.fu.getLdn(), 9, this.ru.getLdn(), 4, this.rfElectricalUlDelay, -1, this.rfUlAttenuation, -1);
        this.ris.add(this.rxBRfCable);
    }

    public List getResourceItems() throws BemException {
        this.fu.setSecondAiLocked(false);
        return this.ris;
    }

    public List getAllocatedResources() {
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        arrayList.add(this.ru);
        arrayList.add(this.fu);
        arrayList.add(this.reservedConnectors[this.getSectorNo() - 1][0]);
        arrayList.add(this.reservedConnectors[this.getSectorNo() - 1][1]);
        return arrayList;
    }

    private int getDigitalCableConnectorA(int n) throws BemException {
        int n2 = 0;
        int n3 = this.getSectorNo();
        int[][] nArrayArray = new int[][]{{6, 5}, {4, 3}, {2, 1}, {5, 6}, {3, 4}, {1, 2}};
        n2 = nArrayArray[n3 - 1][n - 1];
        return n2;
    }

    public Integer getTerminationConnector(String string) throws BemException {
        Integer n = null;
        if (string.equalsIgnoreCase("A")) {
            n = new Integer(1);
        } else if (string.equalsIgnoreCase("B")) {
            n = new Integer(2);
        } else {
            throw new BemException(this.getClass().getName() + " getAntFeederCableConnectorA(): Antenna branch " + string + " not supported");
        }
        return n;
    }

    public String getTerminationObject(String string) throws BemException {
        return this.fu.getAuxPiuLdn();
    }

    protected List getFreeConnectors() {
        return this.freeConnectors;
    }

    public void updateCableCharacteristics(AbstractCableSet abstractCableSet, int n) throws BemException {
        NalNameValue[] nalNameValueArray = null;
        nalNameValueArray = abstractCableSet.getRxACableAttributes(n);
        this.rxARfCable.setAttributes(nalNameValueArray);
        nalNameValueArray = abstractCableSet.getRxBCableAttributes(n);
        this.rxBRfCable.setAttributes(nalNameValueArray);
        nalNameValueArray = abstractCableSet.getTxCableAttributes(n);
        this.txRfCable.setAttributes(nalNameValueArray);
        nalNameValueArray = abstractCableSet.getData1CableAttributes(n);
        this.digitalCable1.setAttributes(nalNameValueArray);
        nalNameValueArray = abstractCableSet.getData2CableAttributes(n);
        this.digitalCable2.setAttributes(nalNameValueArray);
    }

    public int minNumberOfCarriers() {
        return 1;
    }

    public boolean isDualRadioInterfaceBoardNeeded() {
        return true;
    }

    public int[] getCarriersInBasebandPool(int n) {
        return this.carriersInBaseBandPool[n];
    }

    public List getAtfRoleMapping() {
        ArrayList<RadioBuildingBlock.SlotToBBPools> arrayList = new ArrayList<RadioBuildingBlock.SlotToBBPools>();
        arrayList.add(new RadioBuildingBlock.SlotToBBPools(this.ru.getSlotNumber(), new int[]{0, 1}));
        return arrayList;
    }

    public String getConfiguredRbbName() {
        return guiName;
    }

    public int[] getSupportedTxDivRange() {
        return new int[]{1};
    }

    public boolean isInstalled() throws BemException {
        boolean bl;
        boolean bl2;
        int n = this.getSectorNo();
        String string = "ManagedElement=1,Equipment=1,SectorAntenna=" + n + "-1";
        String string2 = "ManagedElement=1,Equipment=1,SectorAntenna=" + n + "-2";
        MoHandler moHandler = this.rbs.getMoHandler();
        BemMo bemMo = moHandler.getMo(string);
        BemMo bemMo2 = moHandler.getMo(string2);
        try {
            bl2 = moHandler.isExisting(bemMo);
            bl = moHandler.isExisting(bemMo2);
        }
        catch (MoHandlerException moHandlerException) {
            moHandlerException.printStackTrace();
            bl2 = false;
            bl = false;
        }
        return super.isInstalled() && bl2 && !bl;
    }
}

