/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.xalm;

import java.text.MessageFormat;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMoImpl;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;

public class OutDeviceRI
extends AbstractResourceItem {
    public static final String name = "OUT_DEVICE";
    private static final String[] myInstallationPhases = new String[]{"ExternalAlarmCreationPhase"};
    private final String ldn;
    private String equipmentName = null;
    private Boolean normallyOpen = null;
    private final String prefix;
    private static final String[] pseudos = new String[]{"equipmentName", "normallyOpen"};
    private static final String[] attributeNames = new String[]{"equipmentName", "normallyOpen"};

    public OutDeviceRI(Rbs rbs, String string, String string2) {
        super(name, rbs, myInstallationPhases);
        this.ldn = string;
        BemMo bemMo = this.getMo(string);
        String string3 = bemMo.getId();
        String string4 = PrefixUtil.getFirstCabinetPrefix() + string2 + "ControlPort" + "{0}_";
        this.prefix = MessageFormat.format(string4, string3);
    }

    public void install(String string) throws BemException {
        if (string.equals("ExternalAlarmCreationPhase")) {
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + "equipmentName");
            this.equipmentName = (String)customerParameterServer.getValueMom();
            customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + "normallyOpen");
            this.normallyOpen = (Boolean)customerParameterServer.getValueMom();
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            vector.add(Nal.getFactory().getNameValue("equipmentName", this.equipmentName));
            vector.add(Nal.getFactory().getNameValue("normallyOpen", this.normallyOpen));
            this.verifyAttributes();
            BemMo bemMo = this.getMo(this.ldn);
            Vector vector2 = this.getLoadedValues();
            if (vector2 != null) {
                for (int i = 0; i < vector2.size(); ++i) {
                    if (vector2.elementAt(i).toString().endsWith(vector.elementAt(i).toString())) continue;
                    this.setOutDeviceAttributes(bemMo, vector, this.ldn);
                    break;
                }
            }
        }
    }

    public boolean isInstalled(String string) throws BemException {
        boolean bl = true;
        BemMoImpl bemMoImpl = new BemMoImpl(string);
        if (this.isExisting(bemMoImpl)) {
            String string2 = "administrativeState";
            Integer n = (Integer)this.getAttribute(bemMoImpl, string2);
            if (n == 0) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private void setOutDeviceAttributes(BemMo bemMo, Vector vector, String string) throws BemException {
        if (bemMo.isExisting()) {
            if (vector != null && !vector.isEmpty()) {
                this.lockDevice(string);
                this.setAttributes(bemMo, vector);
                this.unlockDevice(string);
            }
        } else {
            this.createMoIfNotExisting(string, vector);
        }
    }

    private void lockDevice(String string) throws BemException {
        String string2;
        Integer n;
        BemMoImpl bemMoImpl = new BemMoImpl(string);
        boolean bl = this.isExisting(bemMoImpl);
        if (bl && (n = (Integer)this.getAttribute(bemMoImpl, string2 = "administrativeState")) == 1) {
            this.setAttribute(new BemMoImpl(string), string2, (Object)new Integer(0));
        }
    }

    private void unlockDevice(String string) throws BemException {
        String string2;
        Integer n;
        BemMoImpl bemMoImpl = new BemMoImpl(string);
        boolean bl = this.isExisting(bemMoImpl);
        if (bl && (n = (Integer)this.getAttribute(bemMoImpl, string2 = "administrativeState")) == 0) {
            this.setAttribute(new BemMoImpl(string), string2, (Object)new Integer(1));
        }
    }

    public void setLoadedValues() throws BemException {
        BemMo bemMo = this.getMo(this.ldn);
        for (int i = 0; i < pseudos.length; ++i) {
            String string = this.prefix + pseudos[i];
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string);
            Object object = this.getAttribute(bemMo, attributeNames[i]);
            customerParameterServer.setLoadedValue(object);
        }
    }

    private Vector getLoadedValues() throws BemException {
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        BemMo bemMo = this.getMo(this.ldn);
        Object object = this.getAttribute(bemMo, "equipmentName");
        vector.add(Nal.getFactory().getNameValue("equipmentName", object));
        object = this.getAttribute(bemMo, "normallyOpen");
        vector.add(Nal.getFactory().getNameValue("normallyOpen", object));
        return vector;
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getDisplayName() {
        return "OUT_DEVICE: " + this.getLdn();
    }

    private void verifyAttributes() throws BemException {
        if (this.equipmentName == null) {
            throw new BemException("OutDeviceRI.verifyAttributes() equipmentName is null for\n" + this.getDisplayName());
        }
        if (this.normallyOpen == null) {
            throw new BemException("OutDeviceRI.verifyAttributes() normallyOpen is null for\n" + this.getDisplayName());
        }
    }
}

