/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.resource;

import java.text.MessageFormat;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractDbControlledAuxillaryUnitRI;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AuxPiuRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public abstract class AbstractRuRI
extends AbstractDbControlledAuxillaryUnitRI
implements AuxPiuRI {
    private static final String[] myCleanUpPhases = new String[]{"AuxUnitCleanUpPhase", "LockPhase"};
    private String[] cleanupPhases;
    private int tpaDevices;
    private int sequenceNumber;
    private int sectorNumber;

    protected AbstractRuRI(String string, Rbs rbs, int n, String string2, String string3, int n2, int n3, int n4) {
        super(string, rbs, n, string2, string3);
        this.tpaDevices = n2;
        this.sequenceNumber = n4;
        this.sectorNumber = n3;
    }

    public void activateForCleanUp() {
        this.cleanupPhases = myCleanUpPhases;
    }

    public void install(String string) throws BemException {
        if (this.cleanupPhases == null) {
            super.install(string);
        } else if (string.equals("AuxUnitCleanUpPhase")) {
            super.handleDeletionPhase();
        }
    }

    public void uninstall(String string) throws BemException {
        if (this.cleanupPhases == null) {
            super.uninstall(string);
        } else if (string.equals("LockPhase")) {
            super.lock("administrativeState");
        }
    }

    public int getTpaDeviceCount() {
        return this.tpaDevices;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public String getSectorAuxPrefix() {
        String string = MessageFormat.format("S{0}_", new Integer(this.sectorNumber));
        String string2 = MessageFormat.format("AUX{0}_", Integer.toString(this.sequenceNumber));
        return string + string2;
    }

    public Boolean getIsSharedWithExternalMeConfiguredValue() throws BemException {
        CustomerParameterServer customerParameterServer = this.getIsSharedWithExternalMeCp();
        return (Boolean)customerParameterServer.getValueMom();
    }

    public void setIsSharedWithExternalMe() throws BemException {
        BemMo bemMo = this.getMo(this.getLdn());
        if (this.isExisting(bemMo)) {
            BemMo bemMo2 = this.getAuxPiuMo();
            CustomerParameterServer customerParameterServer = this.getIsSharedWithExternalMeCp();
            this.setAttribute(bemMo2, "isSharedWithExternalMe", customerParameterServer.getValueMom());
        }
    }

    public void loadIsSharedWithExternalMe() throws BemException {
        BemMo bemMo = this.getMo(this.getLdn());
        if (this.isExisting(bemMo)) {
            BemMo bemMo2 = this.getAuxPiuMo();
            CustomerParameterServer customerParameterServer = this.getIsSharedWithExternalMeCp();
            Boolean bl = (Boolean)bemMo2.getAttribute("isSharedWithExternalMe");
            if (bl != null) {
                if (bl.booleanValue()) {
                    customerParameterServer.setLoadedValue("TRUE");
                } else {
                    customerParameterServer.setLoadedValue("FALSE");
                }
            }
        }
    }

    public CustomerParameterServer getIsSharedWithExternalMeCp() throws BemException {
        String string = this.getSectorAuxPrefix() + "isSharedWithExternalMe";
        return this.rbs.getCustomerParameterServerObject(string);
    }
}

