/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.nal.impl.neal;

import se.ericsson.cello.neal.cm.CmException;
import se.ericsson.cello.neal.cm.Transaction;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalTransaction;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.backend.NalTransactionBackend;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.neal.NalFactoryNeal;

public class NalTransactionNeal
extends NalTransactionBackend
implements NalTransaction {
    private static final int DEFAULT_TIMEOUT = 300000;
    private final NalFactoryNeal factory;
    private final Transaction transaction;

    NalTransactionNeal(NalFactoryNeal nalFactoryNeal, Transaction transaction) {
        super(transaction == null);
        this.factory = nalFactoryNeal;
        this.transaction = transaction == null ? this.factory.getCmService().createNullTransaction() : transaction;
    }

    public NalTransactionNeal(NalFactoryNeal nalFactoryNeal) {
        this(nalFactoryNeal, 300000);
    }

    public NalTransactionNeal(NalFactoryNeal nalFactoryNeal, int n) {
        super(false);
        this.factory = nalFactoryNeal;
        try {
            this.transaction = nalFactoryNeal.getCmService().createTransaction(n);
            if (n > 300000) {
                Nal.getLog().nalTrace(4, this.getClass(), "Created transaction " + this.transaction + " with long time out (ms): " + n);
            }
        }
        catch (CmException cmException) {
            throw new NalCmException("Could not create or start transaction", cmException);
        }
    }

    public void commit() {
        try {
            this.transaction.commit();
        }
        catch (Exception exception) {
            throw new NalCmException("Error during commit of transaction", exception);
        }
    }

    public void rollback(String string, Throwable throwable) throws NalCmException {
        try {
            this.transaction.rollback();
        }
        catch (Exception exception) {
            String string2 = "ERROR during rollback of transaction=" + this + "!" + (string == null ? "" : "\n   Rollback message=" + string) + (throwable == null ? "" : "\n   Rollback cause=" + throwable);
            Nal.getLog().nalTraceError(this.getClass(), string2, exception);
            throw new NalCmException(string2, exception);
        }
    }

    public Object getNative() {
        return this.transaction;
    }

    public String toString() {
        if (this.transaction != null) {
            return this.transaction.toString();
        }
        return super.toString();
    }
}

