/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.pmcommon;

import java.util.Arrays;
import se.ericsson.crbs.cat.pmcommon.PmDeepCloneable;
import se.ericsson.crbs.cat.pmcommon.PmInstance;
import se.ericsson.crbs.cat.pmcommon.PmMaps;

public class PmClassInstance
implements Comparable,
PmDeepCloneable {
    public final int moClassId;
    private final PmMaps.PmInstanceIdMap instanceIdMap;
    private final PmMaps.PmInstanceNameMap instanceNameMap;

    public PmClassInstance(int clsId) {
        this.moClassId = clsId;
        this.instanceIdMap = new PmMaps.PmInstanceIdMap();
        this.instanceNameMap = new PmMaps.PmInstanceNameMap();
    }

    public PmClassInstance(int clsId, PmMaps.PmInstanceIdMap idMap, PmMaps.PmInstanceNameMap nameMap) {
        this.moClassId = clsId;
        this.instanceIdMap = idMap;
        this.instanceNameMap = nameMap;
    }

    public boolean addInstance(PmInstance instance) {
        return this.instanceIdMap.add(instance.moInstanceId, instance) && this.instanceNameMap.add(instance.moInstanceName, instance);
    }

    public boolean removeInstanceByName(String instanceName) {
        PmInstance instance = this.instanceNameMap.get(instanceName);
        if (instance == null) {
            return false;
        }
        return this.instanceIdMap.remove(instance.moInstanceId) && this.instanceNameMap.remove(instance.moInstanceName);
    }

    public PmInstance findInstanceById(long moInstanceId) {
        return this.instanceIdMap.get(moInstanceId);
    }

    public PmInstance findInstanceByName(String instanceName) {
        return this.instanceNameMap.get(instanceName);
    }

    public PmInstance[] getInstances() {
        Object[] result = this.instanceIdMap.getValues();
        Arrays.sort(result);
        return result;
    }

    public int compareTo(Object other) {
        if (other instanceof PmClassInstance) {
            PmClassInstance o = (PmClassInstance)other;
            if (this.moClassId < o.moClassId) {
                return -1;
            }
            if (this.moClassId > o.moClassId) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public PmClassInstance typeSafeClone() {
        return new PmClassInstance(this.moClassId, this.instanceIdMap.typeSafeClone(), this.instanceNameMap.typeSafeClone());
    }

    public PmDeepCloneable deepClone() {
        return this.typeSafeClone();
    }
}

