/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.pmcommon;

import java.util.Arrays;
import se.ericsson.crbs.cat.pmcommon.PmClassInstance;
import se.ericsson.crbs.cat.pmcommon.PmDeepCloneable;
import se.ericsson.crbs.cat.pmcommon.PmMaps;

public class PmClassInstances
implements PmDeepCloneable {
    private final PmMaps.PmClassInstanceIdMap m_classInstanceIdMap;

    public PmClassInstances() {
        this.m_classInstanceIdMap = new PmMaps.PmClassInstanceIdMap();
    }

    private PmClassInstances(PmMaps.PmClassInstanceIdMap classInstanceIdMap) {
        this.m_classInstanceIdMap = classInstanceIdMap;
    }

    public PmClassInstance getClassInstance(int moClassId) {
        PmClassInstance classInstance = this.m_classInstanceIdMap.get(moClassId);
        if (classInstance == null) {
            classInstance = new PmClassInstance(moClassId);
            this.m_classInstanceIdMap.add(classInstance.moClassId, classInstance);
        }
        return classInstance;
    }

    public PmClassInstance addClassInstance(int moClassId) {
        PmClassInstance classInstance = new PmClassInstance(moClassId);
        this.m_classInstanceIdMap.add(classInstance.moClassId, classInstance);
        return classInstance;
    }

    public boolean removeClassInstanceById(int moClassId) {
        boolean result = this.m_classInstanceIdMap.remove(moClassId);
        return result;
    }

    public PmClassInstance findClassInstanceById(int moClassId) {
        return this.m_classInstanceIdMap.get(moClassId);
    }

    public PmClassInstance[] getClassInstances() {
        Object[] result = this.m_classInstanceIdMap.getValues();
        Arrays.sort(result);
        return result;
    }

    public PmClassInstances typeSafeClone() {
        PmClassInstances classInstances = new PmClassInstances(this.m_classInstanceIdMap.typeSafeClone());
        return classInstances;
    }

    public PmDeepCloneable deepClone() {
        return this.typeSafeClone();
    }
}

