/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.security;

import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.security.mom.EnumCertCategory;

public class CertSpec {
    private int category = -1;
    private String fileName = null;
    private String serialNumber = null;
    private String fingerprint = null;

    public CertSpec() throws MoAccessException {
    }

    public CertSpec(Struct struct) throws MoAccessException {
        String[] stringArray = struct.getNames();
        if (stringArray.length != 4) {
            throw new ValueOutOfRangeException("Missing member in certSpec", "Security");
        }
        if (!(struct.getValue("fileName") instanceof String)) {
            throw new WrongAttributeTypeException("fileName", "Security");
        }
        this.fileName = (String)struct.getValue("fileName");
        if (!(struct.getValue("serialNumber") instanceof String)) {
            throw new WrongAttributeTypeException("serialNumber", "Security");
        }
        this.serialNumber = (String)struct.getValue("serialNumber");
        if (!(struct.getValue("fingerprint") instanceof String)) {
            throw new WrongAttributeTypeException("fingerprint", "Security");
        }
        this.fingerprint = (String)struct.getValue("fingerprint");
        if (!(struct.getValue("category") instanceof Integer)) {
            throw new WrongAttributeTypeException("category", "Security");
        }
        this.category = (Integer)struct.getValue("category");
        this.check();
    }

    protected int getCategory() {
        return this.category;
    }

    protected String getSerialNumber() {
        return this.serialNumber;
    }

    protected String getFileName() {
        return this.fileName;
    }

    protected String getFingerprint() {
        return this.fingerprint;
    }

    private void check() throws MoAccessException {
        if (this.serialNumber == null || this.serialNumber.length() < 1 || this.serialNumber.length() > 64) {
            throw new ValueOutOfRangeException("serialNumber String too long/empty", "Security");
        }
        if (this.fileName == null || this.fileName.length() > 255) {
            throw new ValueOutOfRangeException("fileName String too long/empty", "Security");
        }
        if (this.fingerprint == null || this.fingerprint.length() > 127) {
            throw new ValueOutOfRangeException("fingerprint String too long/empty", "Security");
        }
        MoAttributeValidator.checkEnumAttribute((String)"category", (int)this.category, (int[])EnumCertCategory.VALUES_ARRAY, (String)"Security");
    }
}

