/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.security;

import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.security.SshMoGen;
import se.ericsson.cello.transaction.Coordinator;

public class SshMoImpl
extends SshMoGen {
    public SshMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, maoFroIndicationHandler);
    }

    public SshMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, true, froProxy, maoFroIndicationHandler);
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        if (System.getProperty("is.using.nat", "false").equalsIgnoreCase("true")) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                    objectArray[i] = super.getNamingAttributeValue();
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("selectedCipher")) {
                    objectArray[i] = SELECTED_CIPHER_DEFAULT;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("selectedKeyExchange")) {
                    objectArray[i] = SELECTED_KEY_EXCHANGE_DEFAULT;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("selectedMac")) {
                    objectArray[i] = SELECTED_MAC_DEFAULT;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("supportedCipher")) {
                    objectArray[i] = new String[0];
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("supportedKeyExchange")) {
                    objectArray[i] = new String[0];
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("supportedMac")) {
                    objectArray[i] = new String[0];
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("idleSessionTimeout")) {
                    objectArray[i] = new Integer(1);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("userLabel")) {
                    objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("froId")) {
                    objectArray[i] = new Integer(1);
                    continue;
                }
                throw new NoSuchAttributeException(stringArray[i], "Ssh");
            }
        } else {
            objectArray = super.getAttributes(stringArray, coordinator);
        }
        return objectArray;
    }

    protected void validateSelectedCipher(String[] stringArray, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateSelectedCipher(stringArray, setRequestContext);
        this.checkSelectedLength(stringArray, "selectedCipher");
    }

    protected void validateSelectedKeyExchange(String[] stringArray, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateSelectedKeyExchange(stringArray, setRequestContext);
        this.checkSelectedLength(stringArray, "selectedKeyExchange");
    }

    protected void validateSelectedMac(String[] stringArray, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateSelectedMac(stringArray, setRequestContext);
        this.checkSelectedLength(stringArray, "selectedMac");
    }

    private void checkSelectedLength(String[] stringArray, String string) throws MoAccessException {
        int n = 64;
        if (stringArray.length > n) {
            throw new ValueOutOfRangeException(string, "Ssh");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() <= n) continue;
            throw new ValueOutOfRangeException(string, "Ssh", "Length of Attribute element at " + i + " has exceeded maximum limit of 64");
        }
    }
}

