/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.log;

import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.IpAddressValidation;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;

public class AccountInformation {
    private String remoteHost = "";
    private String userID = "";
    private String password = "";

    public AccountInformation() throws MoAccessException {
        this.check();
    }

    public AccountInformation(Struct struct) throws MoAccessException {
        String[] stringArray = struct.getNames();
        if (stringArray.length != 3) {
            throw new ValueOutOfRangeException("Missing member in accountInfo", "Log");
        }
        if (!(struct.getValue("userID") instanceof String)) {
            throw new WrongAttributeTypeException("userID", "Log");
        }
        this.userID = (String)struct.getValue("userID");
        if (!(struct.getValue("remoteHost") instanceof String)) {
            throw new WrongAttributeTypeException("remoteHost", "Log");
        }
        this.remoteHost = (String)struct.getValue("remoteHost");
        if (!(struct.getValue("password") instanceof String)) {
            throw new WrongAttributeTypeException("password", "Log");
        }
        MoAttributeValidator.validateForIllegalCharacters((String)"password", (String)((String)struct.getValue("password")), (String)"Log");
        this.password = (String)struct.getValue("password");
        this.check();
    }

    protected String getRemoteHost() {
        return this.remoteHost;
    }

    protected String getUserID() {
        return this.userID;
    }

    protected String getPassword() {
        return this.password;
    }

    private void check() throws MoAccessException {
        if (!this.remoteHost.equals("")) {
            IpAddressValidation.validateHostName((String)this.remoteHost, (String)"Log", (String)"");
            if (IpAddressValidation.isLoopBackIpAddress((String)this.remoteHost) || IpAddressValidation.getIpAddress((String)this.remoteHost).equals(IpAddressValidation.getIpAddress((String)"::")) || IpAddressValidation.isDefault((String)this.remoteHost)) {
                throw new IllegalAttributeValueException("The value " + this.remoteHost + " is not a valid Ipv4/Ipv6 address or domain name", "Log");
            }
        }
        if (this.userID == null || this.userID.equals("0") || this.userID.length() > 21) {
            throw new ValueOutOfRangeException("userIDString Value Incorrect", "Log");
        }
        if (this.password == null || this.password.equals("0") || this.password.length() > 21) {
            throw new ValueOutOfRangeException("passwordString Value Incorrect", "Log");
        }
    }
}

