/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import se.ericsson.cello.neal.HttpClient;
import se.ericsson.cello.neal.HttpsClient;
import se.ericsson.cello.neal.internal.NealLog;

class IorResolver {
    static final String IOR_PATH = "/cello/ior_files/nameroot.ior";
    static final String DEFAULT_HTTP_PORT = "80";
    static final String DEFAULT_HTTPS_PORT = "443";
    private static IorResolver _instance;
    InputStream is = null;
    BufferedReader in = null;

    static synchronized IorResolver getInstance() {
        if (_instance == null) {
            _instance = new IorResolver();
        }
        return _instance;
    }

    private IorResolver() {
    }

    String getIorFromAny(String string) throws IOException {
        String string2 = null;
        if (IorResolver.isIorString(string)) {
            string2 = string;
        } else if (IorResolver.isIorFile(string)) {
            string2 = this.fromFile(string);
        } else if (IorResolver.isUrl(string)) {
            string2 = this.fromURL(string, false);
        } else if (IorResolver.isUrlUsingHttps(string)) {
            string2 = this.fromURL(string, true);
        } else {
            String string3 = IorResolver.getValidIpAddressForURL(string);
            String string4 = IorResolver.getPort(string);
            String string5 = null;
            try {
                string5 = this.createURLfromIPAddressAndPort(string3, string4, false);
                string2 = this.fromURL(string5, false);
            }
            catch (IOException iOException) {
                NealLog.fine("HTTP Connection Failed. Trying HTTPS Connection");
                string5 = this.createURLfromIPAddressAndPort(string3, string4, true);
                string2 = this.fromURL(string5, true);
            }
        }
        return string2;
    }

    String getWebServerUrlFromAny(String string) throws IOException {
        String string2 = null;
        if (IorResolver.isIorString(string)) {
            return null;
        }
        if (IorResolver.isIorFile(string)) {
            return null;
        }
        if (IorResolver.isUrl(string) || IorResolver.isUrlUsingHttps(string)) {
            URL uRL = new URL(string);
            string2 = uRL.getProtocol() + "://" + uRL.getHost() + ":" + uRL.getPort();
        } else {
            String string3 = IorResolver.getValidIpAddressForURL(string);
            String string4 = IorResolver.getPort(string);
            string2 = "http://" + string3 + ":" + string4;
        }
        return string2;
    }

    String getHostFromAny(String string) throws IOException {
        if (IorResolver.isIorString(string)) {
            return null;
        }
        if (IorResolver.isIorFile(string)) {
            return null;
        }
        if (IorResolver.isUrl(string) || IorResolver.isUrlUsingHttps(string)) {
            URL uRL = new URL(string);
            return uRL.getHost();
        }
        return IorResolver.getIpAddress(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String fromFile(String string) throws IOException {
        String string2;
        if (string.startsWith("file://")) {
            string = string.substring("file://".length());
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            string2 = bufferedReader.readLine();
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string2;
    }

    private String fromURLUsingJavaRead(String string) throws IOException {
        String string2;
        HttpClient httpClient = null;
        try {
            System.setProperty("sun.net.client.defaultConnectTimeout", "50000");
            System.setProperty("sun.net.client.defaultReadTimeout", "50000");
            httpClient = new HttpClient(string);
            if (httpClient.getResponseCode() != 200) {
                throw new IOException("HTTP server returned status code " + httpClient.getResponseCode() + ", Reason=\"" + httpClient.getReasonPhrase() + "\"");
            }
            InputStream inputStream = httpClient.getInputStream();
            byte[] byArray = new byte[512];
            StringBuffer stringBuffer = new StringBuffer();
            try {
                int n;
                do {
                    if (-1 == (n = inputStream.read(byArray, 0, byArray.length))) continue;
                    stringBuffer.append(new String(byArray, 0, n));
                } while (-1 != n);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            string2 = new String(stringBuffer);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (httpClient != null) {
                httpClient.close();
            }
        }
        return string2;
    }

    String fromURL(String string, boolean bl) throws IOException {
        if (!bl) {
            return this.fromURLUsingJavaRead(string);
        }
        return this.fromURLUsingJavaReadUsingHttps(string);
    }

    String fromIPAddress(String string) throws IOException {
        return this.fromURL(this.createURLfromIPAddress(string), false);
    }

    String fromIPAddressAndPort(String string, String string2) throws IOException {
        return this.fromURL(this.createURLfromIPAddressAndPort(string, string2, false), false);
    }

    String createURLfromIPAddress(String string) {
        return this.createURLfromIPAddressAndPort(string, null, false);
    }

    String createURLfromIPAddressAndPort(String string, String string2, boolean bl) {
        if (!bl) {
            if (string2 == null) {
                string2 = DEFAULT_HTTP_PORT;
            }
            return "http://" + string + ":" + string2 + IOR_PATH;
        }
        if (string2.equals(DEFAULT_HTTP_PORT) || string2 == null) {
            string2 = DEFAULT_HTTPS_PORT;
        }
        return "https://" + string + ":" + string2 + IOR_PATH;
    }

    static boolean isIorString(String string) {
        return string.startsWith("IOR:");
    }

    static boolean isIorFile(String string) {
        return string.startsWith("file://");
    }

    static boolean isUrl(String string) {
        return string.startsWith("http://");
    }

    static String getPort(String string) {
        String string2 = DEFAULT_HTTP_PORT;
        if (!IorResolver.isIpv6(string)) {
            int n = string.lastIndexOf(":");
            if (n != -1) {
                int n2;
                if ((n2 = string.indexOf("/", ++n)) == -1) {
                    n2 = string.length();
                }
                if (n2 > n) {
                    string2 = string.substring(n, n2);
                }
            }
        } else {
            int n = string.indexOf("]");
            string2 = n == -1 ? DEFAULT_HTTP_PORT : IorResolver.getPort(string.substring(n));
        }
        return string2;
    }

    static String getIpAddress(String string) {
        String string2 = string;
        if (!IorResolver.isIpv6(string2)) {
            int n = string.lastIndexOf(":");
            if (n != -1) {
                string2 = string.substring(0, n);
            }
        } else if (string2.startsWith("[")) {
            int n = string2.indexOf("[") + 1;
            int n2 = string2.indexOf("]");
            if (n < string2.length() && n != -1 && n2 != -1) {
                string2 = string2.substring(n, n2);
            }
        }
        return string2;
    }

    static String getValidIpAddressForURL(String string) {
        String string2 = IorResolver.getIpAddress(string);
        if (IorResolver.isIpv6(string2)) {
            string2 = "[" + string2 + "]";
        }
        return string2;
    }

    static boolean isIpv6(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ':') continue;
            ++n;
        }
        return n >= 2;
    }

    static boolean isUrlUsingHttps(String string) {
        return string.startsWith("https://");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String fromURLUsingJavaReadUsingHttps(String string) throws IOException {
        String string2;
        HttpsClient httpsClient = null;
        String string3 = null;
        try {
            System.setProperty("sun.net.client.defaultConnectTimeout", "50000");
            System.setProperty("sun.net.client.defaultReadTimeout", "50000");
            httpsClient = new HttpsClient(string);
            if (httpsClient.getResponseCode() != 200) {
                throw new IOException("HTTPS server returned status code " + httpsClient.getResponseCode() + "\"");
            }
            this.is = httpsClient.getInputStream();
            this.in = new BufferedReader(new InputStreamReader(this.is));
            StringBuffer stringBuffer = new StringBuffer();
            try {
                while ((string3 = this.in.readLine()) != null) {
                    stringBuffer.append(string3);
                }
                string2 = stringBuffer.toString();
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            string2 = new String(stringBuffer);
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (httpsClient != null) {
                    httpsClient.close();
                }
                if (this.in == null) throw throwable;
                this.in.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (httpsClient != null) {
            httpsClient.close();
        }
        if (this.in == null) return string2;
        this.in.close();
        return string2;
    }
}

