/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.cm;

import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.threegppsa5.NotificationIRPConstDefs.CorrelatedNotification;
import se.ericsson.cello.neal.cm.CelloManagedObject;
import se.ericsson.cello.neal.cm.CorrelatedNotifications;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.internal.ServiceContext;
import se.ericsson.cello.neal.internal.jvm_version.NealArrays;

class CorrelatedNotificationsImpl
implements CorrelatedNotifications {
    private final CorrelatedNotification[] correlatedNotifs;
    private final ServiceContext service_context;
    private TreeMap moToNids;
    private TreeMap nidToMos;

    public CorrelatedNotificationsImpl(CorrelatedNotification[] correlatedNotificationArray, ServiceContext serviceContext) {
        this.correlatedNotifs = correlatedNotificationArray;
        this.service_context = serviceContext;
    }

    private SortedSet getSet(Mo mo) {
        TreeSet treeSet = (TreeSet)this.moToNids.get(mo);
        if (treeSet == null) {
            treeSet = new TreeSet();
            this.moToNids.put(mo, treeSet);
        }
        return treeSet;
    }

    private SortedSet getSet(Integer n) {
        TreeSet treeSet = (TreeSet)this.nidToMos.get(n);
        if (treeSet == null) {
            treeSet = new TreeSet();
            this.nidToMos.put(n, treeSet);
        }
        return treeSet;
    }

    private synchronized void buildCash() {
        if (this.moToNids != null) {
            return;
        }
        this.moToNids = new TreeMap();
        this.nidToMos = new TreeMap();
        for (int i = 0; i < this.correlatedNotifs.length; ++i) {
            String string = this.correlatedNotifs[i].source;
            int[] nArray = this.correlatedNotifs[i].notifIDSet;
            CelloManagedObject celloManagedObject = new CelloManagedObject(this.service_context, string);
            SortedSet sortedSet = this.getSet(celloManagedObject);
            for (int j = 0; j < nArray.length; ++j) {
                Integer n = new Integer(nArray[j]);
                sortedSet.add(n);
                this.getSet(n).add(celloManagedObject);
            }
        }
    }

    public int getMoCount() {
        this.buildCash();
        int n = this.moToNids.size();
        return n;
    }

    public int getNotificationCount() {
        this.buildCash();
        int n = this.nidToMos.size();
        return n;
    }

    public Mo[] getMos() {
        this.buildCash();
        Mo[] moArray = new Mo[this.moToNids.size()];
        moArray = this.moToNids.keySet().toArray(moArray);
        return moArray;
    }

    public Mo[] getMos(Integer n) {
        this.buildCash();
        SortedSet sortedSet = this.getSet(n);
        Mo[] moArray = new Mo[sortedSet.size()];
        moArray = sortedSet.toArray(moArray);
        return moArray;
    }

    public Integer[] getNotificationIds() {
        this.buildCash();
        Integer[] integerArray = new Integer[this.nidToMos.size()];
        integerArray = this.nidToMos.keySet().toArray(integerArray);
        return integerArray;
    }

    public Integer[] getNotificationIds(Mo mo) {
        this.buildCash();
        SortedSet sortedSet = this.getSet(mo);
        Integer[] integerArray = new Integer[sortedSet.size()];
        integerArray = sortedSet.toArray(integerArray);
        return integerArray;
    }

    public String toString() {
        this.buildCash();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CorrelatedNotifications{");
        stringBuffer.append("\n      Mos    : getMoCount()=" + this.getMoCount() + ", getMos()=" + NealArrays.toString(this.getMos()));
        stringBuffer.append("\n      Notifs : Notifs count=" + this.getNotificationCount() + ",   Notifs=" + NealArrays.toString(this.getNotificationIds()));
        stringBuffer.append("\n      For each MO: What Notifications? ").append(this.moToNids);
        stringBuffer.append("\n      For each Notification: What Mos? ").append(this.nidToMos);
        stringBuffer.append("\n}");
        return stringBuffer.toString();
    }
}

