/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.cm;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class UtcTime
implements Comparable {
    public final long time;
    public final long inaccuracy;
    public final short tdf;
    private static final long GREGORIAN_EPOCH_MILLIS = 12219292800000L;
    private final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public UtcTime(long l, int n, short s, short s2) {
        this.time = l;
        long l2 = s;
        long l3 = n;
        this.inaccuracy = l2 << 32 | l3 & 0xFFFFFFFFL;
        this.tdf = s2;
    }

    public Date getDate() {
        return new Date(this.time / 10000L - 12219292800000L);
    }

    public synchronized String toString() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        gregorianCalendar.setTime(new Date(this.time / 10000L - 12219292800000L));
        this.TIME_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        return this.TIME_FORMAT.format(gregorianCalendar.getTime());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UtcTime)) {
            return false;
        }
        UtcTime utcTime = (UtcTime)object;
        return this.time == utcTime.time;
    }

    public int hashCode() {
        int n = (int)(this.time >> 13);
        return n;
    }

    public int compareTo(Object object) {
        UtcTime utcTime = (UtcTime)object;
        if (this.time < utcTime.time) {
            return -1;
        }
        if (this.time > utcTime.time) {
            return 1;
        }
        return 0;
    }
}

