/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.MomAction;
import se.ericsson.cello.mimparser.MomAssociationEnd;
import se.ericsson.cello.mimparser.MomAttribute;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.MomRelationship;
import se.ericsson.cello.mimparser.model.MimModelImpl;
import se.ericsson.cello.mimparser.model.MomActionImpl;
import se.ericsson.cello.mimparser.model.MomAttributeImpl;
import se.ericsson.cello.mimparser.model.MomBase;
import se.ericsson.cello.mimparser.model.MomRelationshipImpl;
import se.ericsson.cello.mimparser.parser.MomParser;
import se.ericsson.cello.mimparser.state.DeprecatedSettable;
import se.ericsson.cello.mimparser.state.LockBeforeDeleteSettable;
import se.ericsson.cello.mimparser.state.TransactionConstraintSettable;

public class MomClassImpl
extends MomBase
implements MomClass,
DeprecatedSettable,
LockBeforeDeleteSettable,
TransactionConstraintSettable {
    private static final String NOTIFICATION_TYPES = "notificationTypes :";
    private static final String TRUE = "true";
    private Map myAttributes = new HashMap(0);
    private Map myActions = new HashMap(0);
    private List parents = new ArrayList(0);
    private List children = new ArrayList(0);
    private List parentRelationships = new ArrayList(0);
    private List childrenRelationships = new ArrayList(0);
    private List allRelationships = new ArrayList(0);
    private List containmentChildren = new ArrayList(0);
    private List containmentParents = new ArrayList(0);
    private List softLinkChildren = new ArrayList(0);
    private List softLinkParents = new ArrayList(0);
    private List supporters = new ArrayList(0);
    private List supported = new ArrayList(0);
    private List directionalAccociationsTo = new ArrayList();
    private List directionalAccociationsFrom = new ArrayList(0);
    private String notificationTypes;
    private String deprecated = null;
    private boolean systemCreated;
    private String lockBeforeDelete = null;
    private boolean nonPersistant;
    static final String DEPRECATED = "deprecated: ";
    static final String LOCK_BEFORE_DELETE = "lockBeforeDelete: ";
    private static final String NON_PERSISTENT = "nonPersistent: ";
    private static final String SYSTEM_CREATED = "systemCreated: ";
    private static final String APPLICATION_TAG = "applicationTag: ";
    private static final String DESCRIPTION = "description: ";
    private static final String TRANSACTION_REQUIRED = "transactionRequired: ";
    private static final String TRANSACTION = "transactionConstraint: ";
    private static final String NEW_LINE = "\n";
    private boolean transactionRequired;
    private String transactionConstraint;

    public MomClassImpl(String xmlType, Attributes attributes, MimModelImpl model, int id) {
        super(xmlType, attributes, model, id);
    }

    public void addAttribute(String name, MomAttributeImpl moAttribute) {
        this.myAttributes.put(name, moAttribute);
    }

    public MomAttribute getAttribute(String attributeName) {
        Iterator iter = this.getAttributes();
        while (iter.hasNext()) {
            MomAttribute currentAttribute = (MomAttribute)iter.next();
            if (!currentAttribute.getName().equals(attributeName)) continue;
            return currentAttribute;
        }
        return null;
    }

    public Iterator getAttributes() {
        return this.myAttributes.values().iterator();
    }

    public void addAction(String name, MomActionImpl moAction) {
        this.myActions.put(name, moAction);
    }

    public MomAction getAction(String name) {
        return (MomAction)this.myActions.get(name);
    }

    public Iterator getActions() {
        return this.myActions.values().iterator();
    }

    public void addParent(MomClass parentMo, MomRelationship parentRelationship) {
        this.parents.add(parentMo);
        this.parentRelationships.add(parentRelationship);
    }

    public void addChild(MomClassImpl childMo, MomRelationshipImpl childRelationship) {
        this.children.add(childMo);
        this.childrenRelationships.add(childRelationship);
    }

    public void addRelationship(MomRelationshipImpl relationship) {
        this.allRelationships.add(relationship);
    }

    public Iterator getParents() {
        return this.parents.iterator();
    }

    public Iterator getChildren() {
        return this.children.iterator();
    }

    public Iterator getRelationships() {
        return this.allRelationships.iterator();
    }

    public Iterator getParentRelationships() {
        return this.parentRelationships.iterator();
    }

    public Iterator getChildrenRelationships() {
        return this.childrenRelationships.iterator();
    }

    public boolean isSystemCreated() {
        return this.systemCreated;
    }

    public void setSystemCreated() {
        this.systemCreated = true;
    }

    public boolean isTransactionRequired() {
        return this.transactionRequired;
    }

    public void setTransactionRequired() {
        this.transactionRequired = true;
    }

    public String getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(String deprecated) {
        this.deprecated = deprecated;
    }

    public String getTransactionConstraint() {
        return this.transactionConstraint;
    }

    public void setTransactionConstraint(String transactionConstraint) {
        this.transactionConstraint = transactionConstraint;
    }

    public boolean isLockBeforeDelete() {
        return TRUE.equals(this.lockBeforeDelete);
    }

    public void setLockBeforeDelete() {
        this.lockBeforeDelete = TRUE;
    }

    public boolean isNonPersistent() {
        return this.nonPersistant;
    }

    public void setNonPersistent() {
        this.nonPersistant = true;
    }

    public void setNotificationTypes(String notificationTypes) {
        this.notificationTypes = notificationTypes;
    }

    public String getNotificationTypes() {
        return this.notificationTypes;
    }

    public String getDescription() {
        if (this.description == null && this.getModel().getContentLevel() == 2) {
            MomBase element;
            HashMap<Integer, MomBase> momBases = new HashMap<Integer, MomBase>(0);
            Iterator iter = this.getActions();
            while (iter.hasNext()) {
                element = (MomBase)iter.next();
                momBases.put(new Integer(element.getId()), element);
            }
            iter = this.getAttributes();
            while (iter.hasNext()) {
                element = (MomBase)iter.next();
                momBases.put(new Integer(element.getId()), element);
            }
            if (this.getModel().getCacheSize() < momBases.size()) {
                momBases.clear();
            }
            MomParser.reParseMomBase(this, momBases);
        }
        return this.description;
    }

    public void addContainmentChild(MomClassImpl child) {
        this.containmentChildren.add(child);
    }

    public Iterator getContainmentChildren() {
        return this.containmentChildren.iterator();
    }

    public Iterator getContainmentParents() {
        return this.containmentParents.iterator();
    }

    public Iterator getAssociationEndsFrom() {
        return this.directionalAccociationsFrom.iterator();
    }

    public Iterator getAssociationEndsTo() {
        return this.directionalAccociationsTo.iterator();
    }

    public Iterator getSoftLinkChildren() {
        return this.softLinkChildren.iterator();
    }

    public Iterator getSoftLinkParents() {
        return this.softLinkParents.iterator();
    }

    public Iterator getSupported() {
        return this.supported.iterator();
    }

    public Iterator getSupporters() {
        return this.supporters.iterator();
    }

    public void addContaimentParent(MomClassImpl parentClass) {
        this.containmentParents.add(parentClass);
    }

    public void addSoftLinkParent(MomClassImpl parentClass) {
        this.softLinkParents.add(parentClass);
    }

    public void addSoftLinkChild(MomClassImpl childClass) {
        this.softLinkChildren.add(childClass);
    }

    public void addSupporter(MomClassImpl parentClass) {
        this.supporters.add(parentClass);
    }

    public void addSupported(MomClassImpl supportedClass) {
        this.supported.add(supportedClass);
    }

    public void addDirectionalAssociationTo(MomAssociationEnd associationEnd) {
        this.directionalAccociationsTo.add(associationEnd);
    }

    public void addDirectionalAssociationFrom(MomAssociationEnd associationEnd) {
        this.directionalAccociationsFrom.add(associationEnd);
    }

    public String getExtendedDescription() {
        StringBuffer buf = new StringBuffer();
        if (this.getDescription() != null) {
            buf.append("description: \n" + this.getDescription() + NEW_LINE + NEW_LINE);
        }
        if (this.getApplicationTag() != null) {
            buf.append(APPLICATION_TAG + this.getApplicationTag() + NEW_LINE);
        }
        if (this.getTransactionConstraint() != null) {
            buf.append(TRANSACTION + this.getTransactionConstraint() + NEW_LINE);
        }
        if (this.getNotificationTypes() != null) {
            buf.append(NOTIFICATION_TYPES + this.getNotificationTypes() + NEW_LINE);
        }
        if (this.getDeprecated() != null) {
            buf.append(DEPRECATED + this.getDeprecated() + NEW_LINE);
        }
        buf.append(LOCK_BEFORE_DELETE + this.isLockBeforeDelete() + NEW_LINE);
        buf.append(SYSTEM_CREATED + this.isSystemCreated() + NEW_LINE);
        buf.append(NON_PERSISTENT + this.isNonPersistent() + NEW_LINE);
        buf.append(TRANSACTION_REQUIRED + this.isTransactionRequired() + NEW_LINE);
        return buf.toString();
    }
}

