/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.model.MomEntityResolvable;
import se.ericsson.cello.mimparser.model.MomEnumRefImpl;

public class ReferenceResolver {
    private HashMap structRefsToResolve = new HashMap(0);
    private HashMap moRefsToResolve = new HashMap(0);
    private HashMap enumRefsToResolve = new HashMap(0);
    private HashMap derivedDataTypeRefsToResolve = new HashMap(0);
    private static final int STRUCT_FLAG = 1;
    private static final int MO_FLAG = 2;
    private static final int ENUM_FLAG = 3;
    private static final int DATA_TYPE_FLAG = 4;

    ReferenceResolver() {
    }

    void addStructRef(String name, MomEntityResolvable structReferencingObject) {
        this.add(name, structReferencingObject, this.structRefsToResolve);
    }

    void addMoRef(String name, MomEntityResolvable moReferencingObject) {
        this.add(name, moReferencingObject, this.moRefsToResolve);
    }

    void addEnumRef(String name, MomEntityResolvable enumReferencingObject) {
        this.add(name, enumReferencingObject, this.enumRefsToResolve);
    }

    void addDerivedDataTypeRef(String name, MomEntityResolvable derivedDataTypeReferencingObject) {
        this.add(name, derivedDataTypeReferencingObject, this.derivedDataTypeRefsToResolve);
    }

    private void add(String name, Object obj, HashMap map) {
        ArrayList<Object> l = (ArrayList<Object>)map.get(name);
        if (l == null) {
            l = new ArrayList<Object>(0);
        }
        l.add(obj);
        map.put(name, l);
    }

    void resolve(MimModel model) {
        this.resolveMap(model, this.structRefsToResolve, 1);
        this.resolveMap(model, this.moRefsToResolve, 2);
        this.resolveMap(model, this.enumRefsToResolve, 3);
        this.resolveMap(model, this.derivedDataTypeRefsToResolve, 4);
        this.resolveEnumRefDefaultValues(model);
        this.structRefsToResolve = null;
        this.moRefsToResolve = null;
        this.enumRefsToResolve = null;
        this.derivedDataTypeRefsToResolve = null;
    }

    private void resolveMap(MimModel model, HashMap map, int flag) {
        Iterator names = map.entrySet().iterator();
        while (names.hasNext()) {
            Map.Entry entry = names.next();
            String name = (String)entry.getKey();
            MomEntity momEntity = this.getMomEntity(model, flag, name);
            List references = (List)entry.getValue();
            for (int i = 0; i < references.size(); ++i) {
                MomEntityResolvable res = (MomEntityResolvable)references.get(i);
                res.setResolvedEntity(momEntity);
            }
        }
    }

    private void resolveEnumRefDefaultValues(MimModel model) {
        Iterator names = this.enumRefsToResolve.keySet().iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            List references = (List)this.enumRefsToResolve.get(name);
            for (int i = 0; i < references.size(); ++i) {
                MomEnumRefImpl enumRef = (MomEnumRefImpl)references.get(i);
                enumRef.resolveDefault();
            }
        }
    }

    private MomEntity getMomEntity(MimModel model, int flag, String name) {
        MomEntity me = null;
        String flagString = null;
        if (flag == 1) {
            me = model.getStruct(name);
            flagString = "structRef";
        } else if (flag == 2) {
            me = model.getClass(name);
            flagString = "moRef (class)";
        } else if (flag == 3) {
            me = model.getEnum(name);
            flagString = "enumRef";
        } else if (flag == 4) {
            me = model.getDerivedDataType(name);
            flagString = "derivedDataTypeRef";
        }
        if (me == null) {
            String errorMsg = "Can not resolve reference of type " + flagString + ". The referenced entry can not be found. name=" + name + " method=ReferenceResolver.getMomEntity()";
            throw new RuntimeException(errorMsg);
        }
        return me;
    }
}

