/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.licensing.view;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.SwingUtilities;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogImpl;
import se.ericsson.cello.licensing.LicensingLogger;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;

public class DisplayKeyFileListener
implements ActionListener {
    private static final String LICENSING_LDN = "ManagedElement=1,SystemFunctions=1,Licensing=1";
    private LauncherInterface launcher;
    private Properties properties;
    private Launchable parent;
    private NodeServices nodeServices;

    public DisplayKeyFileListener(LauncherInterface launcher, Launchable parent, Properties properties, NodeServices ns) {
        this.launcher = launcher;
        this.properties = properties;
        this.parent = parent;
        this.nodeServices = ns;
    }

    public void actionPerformed(ActionEvent e) {
        LicensingLogger.logger().fine("DisplayKeyFileListener: actionPerformed");
        this.displayKeyFile();
    }

    private void displayKeyFile() {
        if (SwingUtilities.isEventDispatchThread()) {
            Runnable runner = new Runnable(){

                public void run() {
                    DisplayKeyFileListener.this.displayKeyFile();
                }
            };
            new Thread(runner).start();
            return;
        }
        if (this.requiredServicesAvailable()) {
            CmService cm = this.nodeServices.getNode().getCmService();
            Mo licensingMo = cm.getMo(LICENSING_LDN);
            NameValue licensFileAttribute = licensingMo.getAttribute("licenseFileUrl", null);
            String url = licensFileAttribute.getStringValue();
            LicensingLogger.logger().info("The attribute value of licenseFileUrl is: " + url);
            if (null == url || 0 == url.trim().length()) {
                new MessageDialogImpl("Licence key file unknown.", "The License MO attribute licenseFileUrl, which contains the URL to the key file, had no value. The key file cannot be displayed.", false, null).setVisible(true);
            } else {
                this.launchHelpService(url);
            }
        }
    }

    private void launchHelpService(String url) {
        Properties props = new Properties();
        props.setProperty("LDNs", LICENSING_LDN);
        String icon = this.properties.getProperty("TOOL_ICON");
        if (null != icon) {
            props.setProperty("TOOL_ICON", icon);
        }
        props.setProperty("URL", url);
        String myHost = this.properties.getProperty("HOST", "Host is not defined");
        String myHelpCfg = this.getHelpCfg();
        try {
            this.launcher.runResource(myHelpCfg, myHost, props, this.parent);
        }
        catch (Exception e) {
            LicensingLogger.logger().warning("Failed to start Help Service: \n" + LicensingLogger.stackToString(e));
            MessageDialogFactory.createMessageDialog((String)"Failed to display license key file.", (Exception)e, (boolean)false, null).setVisible(true);
        }
    }

    private boolean requiredServicesAvailable() {
        MessageDialogImpl msgDia;
        boolean servicesOk = true;
        if (null == this.nodeServices) {
            msgDia = new MessageDialogImpl("Node connection failure", "No connection to the node", false, null);
            msgDia.setVisible(true);
            servicesOk = false;
        }
        if (null == this.launcher) {
            LicensingLogger.logger().warning("Not able to start Help Service.");
            msgDia = new MessageDialogImpl("Failed to display license key file", "No valid EM Launcher available.", false, null);
            msgDia.setVisible(true);
            servicesOk = false;
        }
        return servicesOk;
    }

    private String getHelpCfg() {
        String myHelpCfg = this.properties.getProperty("HELPSERVICE_CONFIG", "");
        if (myHelpCfg.equals("")) {
            LicensingLogger.logger().warning("Did not get property HELPSERVICE_CONFIG. Will try with /cello/emas/helpservcfg.xml");
            myHelpCfg = "/cello/emas/helpservcfg.xml";
        }
        return myHelpCfg;
    }
}

