/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.licensing.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import se.ericsson.cello.licensing.LicensingLogger;
import se.ericsson.cello.licensing.model.LicenseType;
import se.ericsson.cello.licensing.model.TableEntry;
import se.ericsson.cello.licensing.view.ViewData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseView
implements ViewData {
    private static final String MO = "MO";
    static final String REFRESH_TABLE = "Refresh Table";
    static final String MO_PROPERTIES = "MO Properties";
    static final String OPEN_KEY_FILE = "Open Key File";
    private JPanel licenseView;
    private JPanel buttonP;
    private JButton keyFileButton;
    private JButton propButton;
    private JButton refreshButton;
    private JTable table;
    private int CELLGAP = 4;
    private List<String> hyperTools;
    private List<JMenuItem> menuItems;
    private LicenseType type;

    public LicenseView(TableModel model, String[] hyperTools, LicenseType type) {
        this.hyperTools = Arrays.asList(hyperTools);
        this.type = type;
        this.initGUI(model);
    }

    private void initGUI(TableModel model) {
        LicensingLogger.logger().fine("LicenseView init GUI");
        this.licenseView = new JPanel();
        this.licenseView.setName(this.type.tabName);
        BorderLayout layout = new BorderLayout();
        this.licenseView.setLayout(layout);
        this.createTable(model);
        this.initButtons();
        this.initPopupMenu();
        JScrollPane scroller = new JScrollPane();
        scroller.setHorizontalScrollBarPolicy(30);
        scroller.setVerticalScrollBarPolicy(20);
        scroller.setViewportView(this.table);
        this.licenseView.add(scroller);
        this.licenseView.setVisible(true);
    }

    private void createTable(TableModel model) {
        this.table = new JTable(model);
        this.table.setName(this.type.tableName);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.setLdnCellRenderer();
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent ev) {
                Point p = ev.getPoint().getLocation();
                int rowNo = LicenseView.this.table.rowAtPoint(p);
                int colNo = LicenseView.this.table.columnAtPoint(p);
                Object entry = LicenseView.this.table.getValueAt(rowNo, colNo);
                if (entry instanceof TableEntry) {
                    String tooltip = ((TableEntry)entry).getTooltipText();
                    if (tooltip != null && tooltip.length() > 0) {
                        LicenseView.this.table.setToolTipText(tooltip);
                    } else {
                        LicenseView.this.table.setToolTipText(null);
                    }
                } else {
                    LicenseView.this.table.setToolTipText(entry.toString());
                }
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int selRow = LicenseView.this.table.getSelectedRow();
                    if (-1 == selRow) {
                        LicenseView.this.propButton.setEnabled(false);
                    } else {
                        LicenseView.this.propButton.setEnabled(true);
                    }
                }
            }
        });
        int gapHeight = 4;
        this.table.setIntercellSpacing(new Dimension(this.CELLGAP, gapHeight));
        this.table.setRowHeight(this.table.getRowHeight() + gapHeight);
    }

    private void setLdnCellRenderer() {
        int ldnColumn = this.getLdnColumn();
        if (ldnColumn > -1) {
            LicensingLogger.logger().fine("LicenseView: setting LdnCellRenderer");
            this.table.getColumnModel().getColumn(ldnColumn).setCellRenderer(new LdnCellRenderer());
        }
    }

    private void initButtons() {
        LicensingLogger.logger().fine("LicenseView: initButtons");
        this.buttonP = new JPanel(new FlowLayout(2));
        this.keyFileButton = new JButton(OPEN_KEY_FILE);
        this.keyFileButton.setToolTipText("Open the License key file in a web browser");
        this.keyFileButton.setMnemonic('k');
        this.buttonP.add(this.keyFileButton);
        this.propButton = new JButton(MO_PROPERTIES);
        this.propButton.setEnabled(false);
        this.propButton.setToolTipText("Display Properties of the selected MO");
        this.propButton.setMnemonic('m');
        this.buttonP.add(this.propButton);
        this.refreshButton = new JButton(REFRESH_TABLE);
        this.refreshButton.setMnemonic('f');
        this.buttonP.add(this.refreshButton);
        this.licenseView.add((Component)this.buttonP, "South");
    }

    private void initPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        this.menuItems = new ArrayList<JMenuItem>();
        for (String menuName : this.hyperTools) {
            JMenuItem item = new JMenuItem(menuName);
            this.menuItems.add(item);
            popupMenu.add(item);
        }
        this.table.setComponentPopupMenu(popupMenu);
    }

    protected void setModel(TableModel model) {
        LicensingLogger.logger().fine("LicenseView: setModel");
        this.table.setModel(model);
        this.setLdnCellRenderer();
    }

    public JComponent getComponent() {
        return this.licenseView;
    }

    public void setKeyFileListener(ActionListener listener) {
        this.keyFileButton.addActionListener(listener);
    }

    public void removeKeyFileListener(ActionListener listener) {
        this.keyFileButton.removeActionListener(listener);
    }

    public void setPropsListener(ActionListener listener) {
        this.propButton.addActionListener(listener);
    }

    public void setHyperToolsListener(ActionListener listener) {
        for (JMenuItem menuItem : this.menuItems) {
            menuItem.addActionListener(listener);
        }
    }

    public void removePropsListener(ActionListener listener) {
        this.propButton.removeActionListener(listener);
    }

    public void setRefreshListener(ActionListener listener) {
        this.refreshButton.addActionListener(listener);
    }

    public void removeRefreshListener(ActionListener listener) {
        this.refreshButton.removeActionListener(listener);
    }

    @Override
    public List<String> getSelectedLdns() {
        ArrayList<String> selected = new ArrayList<String>();
        int ldnColumn = this.getLdnColumn();
        if (ldnColumn > -1) {
            int[] rows = this.table.getSelectedRows();
            for (int i = 0; i < rows.length; ++i) {
                String ldn = this.table.getModel().getValueAt(rows[i], ldnColumn).toString();
                selected.add(ldn);
            }
        }
        return selected;
    }

    private int getLdnColumn() {
        int nrOfColumns = this.table.getModel().getColumnCount();
        int ldnColumn = -1;
        for (int i = 0; i < nrOfColumns; ++i) {
            if (!this.table.getModel().getColumnName(i).equalsIgnoreCase(MO)) continue;
            ldnColumn = i;
        }
        return ldnColumn;
    }

    private class LdnCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -1886824193906980034L;

        private LdnCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof TableEntry) {
                value = ((TableEntry)value).toString();
                StringBuffer valueBuf = new StringBuffer((String)value);
                FontMetrics fontMetrics = this.getFontMetrics(table.getFont());
                int valueWidth = fontMetrics.stringWidth((String)value);
                int columnWidth = table.getColumnModel().getColumn(column).getWidth() - LicenseView.this.CELLGAP;
                if (columnWidth - 4 < valueWidth) {
                    int i = 1;
                    while (columnWidth - 4 < fontMetrics.stringWidth(valueBuf.substring(i++))) {
                    }
                    value = valueBuf.length() >= i + 2 ? "..." + valueBuf.substring(i + 2) : "...";
                }
            }
            this.setHorizontalAlignment(4);
            super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            return this;
        }
    }
}

