/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.licensing.view;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogImpl;
import se.ericsson.cello.emt.utils.launchhandler.LaunchHandler;
import se.ericsson.cello.licensing.LicensingLogger;
import se.ericsson.cello.licensing.view.ViewData;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;

public class OpenPropsListener
implements ActionListener {
    private LauncherInterface launcher;
    private Properties properties;
    private Launchable parent;
    private ViewData data;

    public OpenPropsListener(LauncherInterface launcher, Launchable parent, Properties properties, ViewData data) {
        this.launcher = launcher;
        this.properties = properties;
        this.parent = parent;
        this.data = data;
    }

    public void actionPerformed(ActionEvent e) {
        LicensingLogger.logger().fine("OpenPropsListener: actionPerformed");
        this.openProperties();
    }

    private void openProperties() {
        String myMoPropCfg = this.getCfgProp(this.properties);
        String myHost = this.properties.getProperty("HOST", "Host is not defined");
        if (null == this.launcher) {
            LicensingLogger.logger().warning("No EM Launcher available. Not able to open MO properties");
            MessageDialogImpl msgDia = new MessageDialogImpl("Failed displaying MO Properties", "No EM Launcher available.", false, null);
            msgDia.setVisible(true);
        } else {
            for (String ldn : this.data.getSelectedLdns()) {
                LicensingLogger.logger().info("Open MO Properties for: " + ldn);
                Properties props = new Properties();
                props.setProperty("LDNs", ldn);
                LaunchHandler.launchTool((LauncherInterface)this.launcher, (String)myMoPropCfg, (String)myHost, (Properties)props, (Launchable)this.parent);
            }
        }
    }

    private String getCfgProp(Properties props) {
        String moPropCfg = props.getProperty("MOPROPERTIES_CONFIG", "");
        if (moPropCfg.equals("")) {
            LicensingLogger.logger().warning("Did not get property MOPROPERTIES_CONFIG. Using default /cello/emas/mopropcfg.xml");
            moPropCfg = "/cello/emas/mopropcfg.xml";
        }
        return moPropCfg;
    }
}

