/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.managedelement;

import se.ericsson.cello.managedelement.RestartNode;
import se.ericsson.cello.mao.MaRevisionHelper;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoData;

public class MoDataRecoveryHelper {
    private MoData data;
    private ManagedObject mo;

    public MoDataRecoveryHelper(MoData moData, ManagedObject managedObject) {
        this.data = moData;
        this.mo = managedObject;
    }

    private String buildMoMsg() {
        return "MO type:" + this.mo.getType() + "MO instance:" + this.data.getLocalDistinguishedName() + " , " + "MA:" + MaRevisionHelper.getMaProductNumber((Object)this.mo) + " , " + "revision:" + MaRevisionHelper.getMaRevision((Object)this.mo) + " , " + "AueRevision:" + MaRevisionHelper.getAueRevision((Object)this.mo);
    }

    public void assertMoDataRevision(int n) {
        int n2 = this.data.getRevision();
        if (n2 != n) {
            String string = "Wrong MO data revision (" + this.data.getRevision() + " instead of " + n + ") in " + this.buildMoMsg();
            this.restart(string);
        }
    }

    public void assertAttribute(String string) {
        if (this.data.getAttribute(string) == null) {
            String string2 = "Missing attribute '" + string + "' in " + this.buildMoMsg() + " , MoDataRevision : " + this.data.getRevision();
            this.restart(string2);
        }
    }

    public void fail(String string) {
        this.restart(string + " " + this.buildMoMsg());
    }

    private void restart(String string) {
        UpgradeTrace.log1((Class)MoDataRecoveryHelper.class, (String)"restart(String message)", (String)string);
        UpgradeTrace.flushToTraceFile();
        RestartNode.restartIfNull(null, string);
    }
}

