/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.cmaaue.to;

import se.ericsson.cello.aueframework.collector.AttrListImpl;
import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.DataCollectorAction;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.cmaaue.to.AtmConfMoServiceFilter;
import se.ericsson.cello.cmaaue.to.Constants;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;

public class CreateAtmConfServiceMoAction
implements DataCollectorAction,
Constants {
    private String identity;
    private static final String USERLABEL = "userLabel";
    private ManagedObject AtmConfMo = null;

    public CreateAtmConfServiceMoAction(String string) throws NullPointerException {
        if (string == null) {
            throw new NullPointerException("AtmConfService MO identity is null");
        }
        this.identity = string;
    }

    public void perform(CollectorContext collectorContext, Coordinator coordinator, String string) throws AueException {
        MoIterator moIterator = collectorContext.getMoAccessor().select((MoFilter)new AtmConfMoServiceFilter());
        if (moIterator != null && moIterator.size() > 0) {
            if (!this.moAlreadyExists(collectorContext)) {
                this.createAtmConfServiceMo(collectorContext, coordinator);
            } else {
                collectorContext.getLogger().info(this.getClass(), " AtmConfService MO already exists...");
            }
        } else {
            collectorContext.getLogger().info(this.getClass(), " This node is not ATM configred...");
        }
    }

    private void createAtmConfServiceMo(CollectorContext collectorContext, Coordinator coordinator) throws AueException {
        AttrListImpl attrListImpl = new AttrListImpl(1);
        attrListImpl.addElement(USERLABEL, (Object)"");
        ManagedObject managedObject = collectorContext.getMoAccessor().lookupType("TransportNetwork").nextMo();
        MoFactory moFactory = collectorContext.getMoAccessor().lookupMoFactory("AtmConfService");
        if (managedObject == null) {
            return;
        }
        try {
            this.AtmConfMo = moFactory.createMo(managedObject, (AttrList)attrListImpl, this.identity, null, coordinator);
            collectorContext.getLogger().info(this.getClass(), this.AtmConfMo.getLocalDistinguishedName() + " MO created successfully...");
        }
        catch (MoAccessException moAccessException) {
            throw new AueException("Unable to create AtmConfService", (Throwable)moAccessException);
        }
    }

    private boolean moAlreadyExists(CollectorContext collectorContext) {
        this.AtmConfMo = this.findAtmConfServiceMo(collectorContext);
        return this.AtmConfMo != null;
    }

    public ManagedObject findAtmConfServiceMo(CollectorContext collectorContext) {
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("AtmConfService");
        if (moIterator != null && moIterator.hasMoreElements()) {
            return moIterator.nextMo();
        }
        return null;
    }
}

