/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.cmaaue.to;

import se.ericsson.cello.aueframework.collector.AttrListImpl;
import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.DataCollectorAction;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.cmaaue.to.Constants;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;

public class CreateIpLicensingMoAction
implements DataCollectorAction,
Constants {
    ManagedObject ipLicenseMo = null;
    static final String USER_LABEL = "userLabel";
    static final String FEATURE_STATE_IP_FLOW_MONITORING = "featureStateIpFlowMonitoring";

    public void perform(CollectorContext collectorContext, Coordinator coordinator, String string) throws AueException {
        if (this.isIpFlowMoExisting(collectorContext) && !this.isIpLicenseMoExisting(collectorContext)) {
            this.createIpLicenseMo(collectorContext, coordinator);
        }
    }

    private boolean isIpFlowMoExisting(CollectorContext collectorContext) {
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("IpFlowMonitor");
        return moIterator != null && moIterator.size() > 0;
    }

    private boolean isIpLicenseMoExisting(CollectorContext collectorContext) {
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("IpLicensing");
        return moIterator != null && moIterator.size() > 0;
    }

    private void createIpLicenseMo(CollectorContext collectorContext, Coordinator coordinator) throws AueException {
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("IpSystem");
        MoFactory moFactory = collectorContext.getMoAccessor().lookupMoFactory("IpLicensing");
        if (moFactory == null) {
            return;
        }
        AttrListImpl attrListImpl = new AttrListImpl(2);
        attrListImpl.addElement(USER_LABEL, (Object)"IpLicensing");
        attrListImpl.addElement(FEATURE_STATE_IP_FLOW_MONITORING, (Object)new Integer(1));
        try {
            while (moIterator != null && moIterator.hasMoreElements()) {
                ManagedObject managedObject = moIterator.nextMo();
                this.ipLicenseMo = moFactory.createMo(managedObject, (AttrList)attrListImpl, "1", null, coordinator);
                collectorContext.getLogger().info(this.getClass(), this.ipLicenseMo.getLocalDistinguishedName() + " MO created successfully...");
            }
        }
        catch (MoAccessException moAccessException) {
            throw new AueException("Unable to create IpLicensing MO with identity 1" + (Object)((Object)moAccessException));
        }
    }
}

