/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step1.actions;

import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.MoAccessor;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.cello.managedelement.ManagedElementMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class ChangeHwuRdnValueAction
extends AbstractConversionAction {
    private static final String RBS6601 = "RBS6601";
    private static final String CHANGE_HWU_RDN_VALUE_STEP2_ACTION_SHOULD_RUN = "ChangeHwuRdnValueActionShouldRun";
    private static final Class THIS_CLASS = ChangeHwuRdnValueAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String MANAGED_ELEMENT_LDN = "ManagedElement=1";
    private static final String[] possibleChildren = new String[]{"AlarmPort", "ControlPort", "EcPort"};

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        try {
            String string = this.getProductNameFromManagedElementMO(aueContext);
            logger.info(THIS_CLASS, "RBS product name = " + string);
            if (string != null && string.startsWith(RBS6601) && tableHandler != null) {
                if (this.changeHwUnitRdnValue(tableHandler, tableHandler.getTableData("HwUnit"), ",HwUnit=SCU", ",HwUnit=SUP")) {
                    this.informStep2ToRun(tableHandler, true);
                } else {
                    this.informStep2ToRun(tableHandler, false);
                }
            } else {
                this.informStep2ToRun(tableHandler, false);
            }
        }
        catch (TableDataException tableDataException) {
            logger.traceError(THIS_CLASS, "Could not store information in AuePersistency. Reason: " + tableDataException.getMessage());
            throw new CrbsAueException("Could not store information in AuePersistency. Reason: " + tableDataException.getMessage());
        }
        catch (Exception exception) {
            logger.traceError(THIS_CLASS, "Convert failed: " + exception.getMessage());
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private boolean changeHwUnitRdnValue(TableHandler tableHandler, TableData tableData, String string, String string2) throws TableDataException, CrbsAueException {
        String string3;
        int n;
        Object[] objectArray;
        boolean bl = false;
        logger.traceEnter(THIS_CLASS, "changeHwUnitRdnValue()");
        try {
            objectArray = tableData.getAttributeValues("ldn");
        }
        catch (TableDataException tableDataException) {
            bl = false;
            objectArray = new Object[]{};
        }
        for (n = 0; n < objectArray.length; ++n) {
            string3 = objectArray[n].toString();
            logger.info(THIS_CLASS, "Check ldn: '" + string3 + "' for RDN: '" + string2 + "'");
            if (!string3.endsWith(string2)) continue;
            logger.info(THIS_CLASS, "Found '" + string2 + "' in existing configuration.");
            logger.info(THIS_CLASS, "Aborting. No LDN's will be updated.");
            return false;
        }
        for (n = 0; n < objectArray.length; ++n) {
            string3 = objectArray[n].toString();
            logger.info(THIS_CLASS, "Check ldn: " + string3 + " for RDN: " + string);
            if (string3.endsWith(string)) {
                String string4 = AueUtil.replaceInString((String)string3, (String)string, (String)string2);
                tableData.setAttributeValue(n, "ldn", (Object)string4);
                bl = true;
                tableData.setTableDataUpdated(true);
                logger.info(THIS_CLASS, string3 + " renamed to " + string4);
                this.findAndUpdateChildren(tableHandler, string3, string4);
                continue;
            }
            logger.info(THIS_CLASS, "No need to rename " + string3);
        }
        logger.traceReturn(THIS_CLASS, "changeHwUnitRdnValue()");
        return bl;
    }

    private void findAndUpdateChildren(TableHandler tableHandler, String string, String string2) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "findAndUpdateChildren");
        for (int i = 0; i < possibleChildren.length; ++i) {
            Object object;
            String string3 = possibleChildren[i];
            boolean bl = false;
            try {
                TableData tableData = tableHandler.getTableData(string3);
                bl = tableData.isTableDataUpdated();
                object = tableData.getAttributeValues("ldn");
                for (int j = 0; j < ((Object[])object).length; ++j) {
                    String string4 = object[j].toString();
                    logger.info(THIS_CLASS, "Check if " + string + " is parent to " + string4);
                    if (string.equalsIgnoreCase(this.getParentLdn(string4))) {
                        logger.info(THIS_CLASS, "Update ldn: " + string4);
                        String string5 = AueUtil.replaceInString((String)string4, (String)string, (String)string2);
                        tableData.setAttributeValue(j, "ldn", (Object)string5);
                        logger.info(THIS_CLASS, "Child " + string4 + " renamed to " + string5);
                        tableData.setTableDataUpdated(true);
                        continue;
                    }
                    logger.info(THIS_CLASS, "Mo " + string + " is not parent to " + string4);
                }
                tableHandler.checkAndDropIfNotUpdated(bl, tableData);
                continue;
            }
            catch (Exception exception) {
                object = "Could not update " + AueUtil.doubleQuote((String)string3);
                logger.traceError(THIS_CLASS, AueUtil.appendReason((String)object, (Throwable)exception));
                throw new CrbsAueException((String)object, (Throwable)exception);
            }
        }
        logger.traceReturn(THIS_CLASS, "findAndUpdateChildren");
    }

    private void informStep2ToRun(TableHandler tableHandler, boolean bl) throws TableDataException {
        if (bl) {
            tableHandler.storeInAuePersistency("", CHANGE_HWU_RDN_VALUE_STEP2_ACTION_SHOULD_RUN, "yes");
        } else {
            tableHandler.storeInAuePersistency("", CHANGE_HWU_RDN_VALUE_STEP2_ACTION_SHOULD_RUN, "no");
        }
    }

    private String getProductNameFromManagedElementMO(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getProductNameFromManagedElementMO");
        try {
            MoAccessor moAccessor = ((CollectorContext)aueContext).getMoAccessor();
            ManagedElementMo managedElementMo = (ManagedElementMo)moAccessor.lookup(MANAGED_ELEMENT_LDN);
            if (null == managedElementMo) {
                throw new CrbsAueException("Can't find ManagedElement=1");
            }
            String string = managedElementMo.getProductName(null);
            logger.traceReturn(THIS_CLASS, "getProductNameFromManagedElementMO - productName: " + string);
            return string;
        }
        catch (MoAccessException moAccessException) {
            throw new CrbsAueException("Failed to find read productName from ManagedElement.", (Throwable)moAccessException);
        }
    }
}

