/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step1.actions;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractCreateInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.TableDataUtil;

public class UpdateEcBusRefOnEcPortAction
extends AbstractCreateInstanceAction {
    private static final Class THIS_CLASS = UpdateEcBusRefOnEcPortAction.class;
    private static TableHandler tableHandler;
    private static final AbstractLogger logger;
    private static final String ECPORT_MO_TYPE = "EcPort";
    private static final String ECPORT_ATT_ECBUSREF = "ecBusRef";

    public void createInstance(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createInstance()");
        tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        try {
            TableData tableData = tableHandler.getTableData(ECPORT_MO_TYPE);
            if (tableData != null && tableData.getNumberOfRecords() != 0) {
                logger.traceGeneral(THIS_CLASS, "Found ecPortTable data with " + tableData.getNumberOfRecords() + " rows.");
                this.updateAllEcBusMaos(tableData);
            } else {
                logger.traceGeneral(THIS_CLASS, "No ecPortTableData found.");
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Failed to find read EcPort tabledata.", (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "createInstance()");
    }

    private void updateAllEcBusMaos(TableData tableData) throws TableDataException {
        logger.traceEnter(THIS_CLASS, "updateAllEcBusMaos()");
        Object[] objectArray = tableData.getAttributeValues(ECPORT_ATT_ECBUSREF);
        Object[] objectArray2 = tableData.getAttributeValues("ldn");
        for (int i = 0; i < objectArray.length; ++i) {
            String string = TableDataUtil.getLdnFromMoRef((String)objectArray[i].toString());
            String string2 = objectArray2[i].toString();
            logger.traceGeneral(THIS_CLASS, "Passing EcPort LDN to step2: " + string2);
            logger.traceGeneral(THIS_CLASS, "Passing EcBus LDN to step2: " + string);
            tableHandler.storeInAuePersistency(string2, ECPORT_ATT_ECBUSREF, string);
        }
        logger.traceReturn(THIS_CLASS, "updateAllEcBusMaos()");
    }

    static {
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    }
}

