/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.common.fropxy;

import enea.ose.io.SignalInputStream;
import enea.ose.system.UnlinkedSignal;
import java.io.IOException;
import se.ericsson.cello.common.fropxy.FroSignalInterface;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.support.debug.MessageLog;

public abstract class FroFaultInd
extends UnlinkedSignal
implements FroSignalInterface {
    private int SIGNO = 0;
    protected int froId;
    protected int specificProblem;
    protected int primaryInd = 1;
    protected int noOfEventId;
    protected int[] eventId;

    public FroFaultInd(int n) {
        super(n);
        this.SIGNO = n;
    }

    public int getSignalNumber() {
        return this.SIGNO;
    }

    public int getFroId() {
        return this.froId;
    }

    public int getSpecificProblem() {
        return this.specificProblem;
    }

    public boolean isPrimary() {
        return this.primaryInd != 0;
    }

    public boolean isSecondary() {
        return !this.isPrimary();
    }

    public int getNoOfEvent() {
        return this.noOfEventId;
    }

    public int[] getEventId() {
        return this.eventId;
    }

    public AdditionalInfo[] getAdditionalInfo() {
        return null;
    }

    public void initReceive() {
        SignalInputStream signalInputStream = this.getSignalInputStream();
        try {
            this.froId = (int)signalInputStream.readU32();
            this.specificProblem = (int)signalInputStream.readU32();
            this.primaryInd = (int)signalInputStream.readU32();
            this.noOfEventId = (int)signalInputStream.readU32();
            this.eventId = new int[this.noOfEventId];
            this.readEventIds(signalInputStream);
            this.readAdditionalInfo(signalInputStream);
        }
        catch (IOException iOException) {
            MessageLog.traceError(this.getClass(), (String)"Reading faultInd failed", (Throwable)iOException);
        }
    }

    public void initSend() {
    }

    protected void readEventIds(SignalInputStream signalInputStream) throws IOException {
        for (int i = 0; i < this.eventId.length; ++i) {
            this.eventId[i] = signalInputStream.readU8();
        }
    }

    protected void readAdditionalInfo(SignalInputStream signalInputStream) throws IOException {
    }
}

