/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pmapp.fropxy;

public class GenericPmFroProxyException
extends RuntimeException {
    private int requestType;
    private int resultCode;
    private String resultText;
    private static final int BASE = 21;
    public static final int DICTIONARY_PROBLEM = 22;
    public static final int INTERNAL_PROBLEM = 23;
    public static final int NO_FRO_RESPONSE = 24;
    public static final int OTHER_PROBLEM = 25;
    public static final int NO_SESSION_AVAILABLE = 26;
    public static final int MAO_FRO_GET_CURRENT_PM_REQ = 100;
    public static final int MAO_FRO_SUBSCRIBE_PM_REQ = 101;
    public static final int MAO_FRO_UNSUBSCRIBE_PM_REQ = 102;
    public static final int TAG_NAME_DICTIONARY = 103;
    public static final int REQUEST_SESSION_FROM_FRO = 104;

    public GenericPmFroProxyException(int n, int n2, String string) {
        this.resultCode = n2;
        this.resultText = string;
        this.requestType = n;
    }

    public String getMessage() {
        return "requestType=" + this.translateRequestType(this.requestType) + ", description=" + this.translateProblem(this.resultCode) + ", resultText=" + this.resultText;
    }

    private String translateProblem(int n) {
        switch (n) {
            case 1: {
                return "MAOFRO_PM_REJ_NO_PM_AVAILABLE";
            }
            case 2: {
                return "MAOFRO_PM_REJ_ANOTHER_GP_INUSE";
            }
            case 3: {
                return "MAOFRO_PM_REJ_UNKNOWN_FROID";
            }
            case 4: {
                return "MAOFRO_PM_REJ_TRANSACTION_FAULT";
            }
            case 5: {
                return "MAOFRO_PM_REJ_FAULTY_PMDATA";
            }
            case 6: {
                return "MAOFRO_PM_REJ_NOT_SUBSCRIBED";
            }
            case 22: {
                return "DICTIONARY_PROBLEM";
            }
            case 23: {
                return "INTERNAL_PROBLEM ";
            }
            case 24: {
                return "NO_FRO_RESPONSE";
            }
            case 26: {
                return "FRO_HAS_REJ/SUS_MAOFRO_INITIATE_SERVICE_REQ_OR_IS_NOT_AVAILABLE";
            }
            case 25: {
                return "OTHER_PROBLEM";
            }
        }
        return "OTHER_PROBLEM";
    }

    private String translateRequestType(int n) {
        switch (n) {
            case 100: {
                return "MAO_FRO_GET_CURRENT_PM_REQ";
            }
            case 101: {
                return "MAO_FRO_SUBSCRIBE_PM_REQ";
            }
            case 102: {
                return "MAO_FRO_UNSUBSCRIBE_PM_REQ";
            }
            case 103: {
                return "TAG_NAME_DICTIONARY";
            }
            case 104: {
                return "REQUEST_SESSION_FROM_FRO";
            }
        }
        return "UNKNOWN";
    }

    public int getResultCode() {
        return this.resultCode;
    }
}

