/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.config.CachableConfiguration;
import org.jacorb.config.Configuration;
import org.jacorb.config.DelegatingConfiguration;
import org.jacorb.util.ObjectUtil;

public class CachingConfiguration
extends DelegatingConfiguration {
    private final Map objectDoesNotExist = this.newMap();
    private final Map doesNotExist = this.newMap();
    private final Map attributeCache = this.newMap();
    private final Map booleanCache = this.newMap();
    private final Map integerCache = this.newMap();
    private final Map attributeExists = this.newMap();
    private final Map objectCache = this.newMap();

    public CachingConfiguration(Configuration config) {
        super(config);
    }

    protected Map newMap() {
        return Collections.synchronizedMap(new HashMap());
    }

    public Object getAttributeAsObject(String key) throws ConfigurationException {
        return this.lookupObject(key, false, null);
    }

    public Object getAttributeAsObject(String key, String defaultValue) throws ConfigurationException {
        return this.lookupObject(key, true, defaultValue);
    }

    private Object lookupObject(String name, boolean useDefault, String defaultValue) throws ConfigurationException {
        Object result = this.objectCache.get(name);
        if (result == null) {
            block10: {
                if (this.doesNotExist.containsKey(name)) {
                    throw (ConfigurationException)this.doesNotExist.get(name);
                }
                if (this.objectDoesNotExist.containsKey(name)) {
                    if (useDefault) {
                        return this.delegate.getAttributeAsObject(name, defaultValue);
                    }
                    return null;
                }
                try {
                    result = this.delegate.getAttributeAsObject(name);
                }
                catch (ConfigurationException e2) {
                    this.doesNotExist.put(name, e2);
                    this.attributeExists.put(name, Boolean.FALSE);
                    if (useDefault) break block10;
                    throw e2;
                }
            }
            if (result == null) {
                this.objectDoesNotExist.put(name, Boolean.TRUE);
                this.attributeExists.put(name, Boolean.FALSE);
            } else {
                this.attributeExists.put(name, Boolean.TRUE);
            }
            if (result == null && useDefault) {
                result = this.delegate.getAttributeAsObject(name, defaultValue);
            }
            if (result != null && result instanceof CachableConfiguration) {
                this.objectCache.put(name, result);
            }
        }
        return result;
    }

    public String getAttribute(String name, String defaultValue) {
        try {
            return this.lookupAttribute(name, true, defaultValue);
        }
        catch (ConfigurationException e2) {
            throw new RuntimeException(e2);
        }
    }

    public String getAttribute(String name) throws ConfigurationException {
        return this.lookupAttribute(name, false, null);
    }

    private String lookupAttribute(String name, boolean useDefault, String defaultValue) throws ConfigurationException {
        String result;
        String lookup = (String)this.attributeCache.get(name);
        if (lookup == null) {
            if (this.doesNotExist.containsKey(name)) {
                if (useDefault) {
                    return defaultValue;
                }
                throw (ConfigurationException)this.doesNotExist.get(name);
            }
            try {
                result = this.delegate.getAttribute(name);
                this.attributeCache.put(name, result);
                this.attributeExists.put(name, Boolean.TRUE);
            }
            catch (ConfigurationException e2) {
                this.doesNotExist.put(name, e2);
                this.attributeExists.put(name, Boolean.FALSE);
                if (useDefault) {
                    result = defaultValue;
                }
                throw e2;
            }
        } else {
            result = lookup;
        }
        return result;
    }

    public boolean getAttributeAsBoolean(String name, boolean defaultValue) {
        try {
            return this.lookupBoolean(name, true, defaultValue);
        }
        catch (ConfigurationException e2) {
            throw new RuntimeException(e2);
        }
    }

    public boolean getAttributeAsBoolean(String name) throws ConfigurationException {
        return this.lookupBoolean(name, false, false);
    }

    private boolean lookupBoolean(String name, boolean useDefault, boolean defaultValue) throws ConfigurationException {
        boolean result;
        Boolean lookup = (Boolean)this.booleanCache.get(name);
        if (lookup == null) {
            if (this.doesNotExist.containsKey(name)) {
                if (useDefault) {
                    return defaultValue;
                }
                throw (ConfigurationException)this.doesNotExist.get(name);
            }
            try {
                result = this.delegate.getAttributeAsBoolean(name);
                this.booleanCache.put(name, result);
                this.attributeExists.put(name, Boolean.TRUE);
            }
            catch (ConfigurationException e2) {
                this.doesNotExist.put(name, e2);
                this.attributeExists.put(name, Boolean.FALSE);
                if (useDefault) {
                    result = defaultValue;
                }
                throw e2;
            }
        } else {
            result = lookup;
        }
        return result;
    }

    public int getAttributeAsInteger(String name, int defaultValue) {
        try {
            return this.lookupInteger(name, true, defaultValue);
        }
        catch (ConfigurationException e2) {
            throw new RuntimeException(e2);
        }
    }

    public int getAttributeAsInteger(String name) throws ConfigurationException {
        return this.lookupInteger(name, false, 0);
    }

    private int lookupInteger(String name, boolean useDefault, int defaultValue) throws ConfigurationException {
        int result;
        Integer lookup = (Integer)this.integerCache.get(name);
        if (lookup == null) {
            if (this.doesNotExist.containsKey(name)) {
                if (useDefault) {
                    return defaultValue;
                }
                throw (ConfigurationException)this.doesNotExist.get(name);
            }
            try {
                result = this.delegate.getAttributeAsInteger(name);
                this.integerCache.put(name, ObjectUtil.newInteger(result));
                this.attributeExists.put(name, Boolean.TRUE);
            }
            catch (ConfigurationException e2) {
                this.doesNotExist.put(name, e2);
                this.attributeExists.put(name, Boolean.FALSE);
                if (useDefault) {
                    result = defaultValue;
                }
                throw e2;
            }
        } else {
            result = lookup;
        }
        return result;
    }

    public void setAttribute(String key, String value) {
        super.setAttribute(key, value);
        this.integerCache.clear();
        this.doesNotExist.clear();
        this.attributeCache.clear();
        this.booleanCache.clear();
        this.attributeExists.clear();
        this.objectCache.clear();
    }

    public boolean isAttributeSet(String name) {
        boolean result;
        Boolean lookup = (Boolean)this.attributeExists.get(name);
        if (lookup == null) {
            result = super.isAttributeSet(name);
            this.attributeExists.put(name, result);
        } else {
            result = lookup;
        }
        return result;
    }
}

