/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.ft;

import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.AbstractORBInitializer;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ft.FaultTolerantClientRequestInterceptor;
import org.jacorb.orb.ft.HeartBeatPolicyFactory;
import org.jacorb.orb.ft.RequestDurationPolicyFactory;
import org.jacorb.util.Time;
import org.omg.CORBA.Any;
import org.omg.CORBA.InvalidPolicies;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.PolicyManager;
import org.omg.CORBA.PolicyManagerHelper;
import org.omg.CORBA.SetOverrideType;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.TimeBase.TimeTHelper;

public class FaultTolerantClientORBInit
extends AbstractORBInitializer {
    public static final String PARAM_FT_REQUEST_DURATION_POLICY = "jacorb.ft.request_duration_policy.default";
    private static final long DEFAULT_FT_REQUEST_DURATION_POLICY = Time.millisToTimeT(1500L);

    public void doPostInit(ORBInitInfo info) throws DuplicateName, PolicyError, InvalidName, InvalidPolicies {
        Logger logger = this.config.getNamedLogger("jacorb.ft.client");
        info.add_client_request_interceptor(new FaultTolerantClientRequestInterceptor(this.orb, logger, this.config));
        logger.info("added FT client request interceptors");
        RequestDurationPolicyFactory requestDurationPolicyFactory = new RequestDurationPolicyFactory();
        info.register_policy_factory(47, requestDurationPolicyFactory);
        info.register_policy_factory(48, new HeartBeatPolicyFactory());
        logger.info("registered FT policy factories");
        this.registerDefaultRequestDurationPolicy(this.orb, info, requestDurationPolicyFactory, logger);
    }

    private void registerDefaultRequestDurationPolicy(ORB orb, ORBInitInfo info, RequestDurationPolicyFactory requestDurationPolicyFactory, Logger logger) throws PolicyError, InvalidName, InvalidPolicies {
        Any any = orb.create_any();
        long requestExpirationDefault = orb.getConfiguration().getAttributeAsLong(PARAM_FT_REQUEST_DURATION_POLICY, DEFAULT_FT_REQUEST_DURATION_POLICY);
        TimeTHelper.insert(any, requestExpirationDefault);
        Policy defaultRequestDurationPolicy = requestDurationPolicyFactory.create_policy(47, any);
        PolicyManager policyManager = PolicyManagerHelper.narrow(info.resolve_initial_references("ORBPolicyManager"));
        policyManager.set_policy_overrides(new Policy[]{defaultRequestDurationPolicy}, SetOverrideType.SET_OVERRIDE);
        logger.info("set REQUEST_DURATION_POLICY default to " + requestExpirationDefault + " corba timeunits (" + Time.timeTTomillis(requestExpirationDefault) + " ms).");
    }
}

