/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step2.actions;

import java.util.ArrayList;
import java.util.StringTokenizer;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataFilter;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step2.actions.util.Step2Handler;

public class RemoveDuplicateMOEnergyMeterAction
implements MoDataAction {
    private static final Class THIS_CLASS = RemoveDuplicateMOEnergyMeterAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected static final String REMOVE_DUPLICATE_MO_ENERGYMETER_STEP2_ACTION = "energymetersToRemove";

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        String[] stringArray = this.getLdnsOfEnergyMetersToRemoveFromStep1(converterContext);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].trim();
            this.deleteMo(converterContext, string, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "perform()");
    }

    private String[] getLdnsOfEnergyMetersToRemoveFromStep1(ConverterContext converterContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getLdnsOfEnergyMetersToRemoveFromStep1()");
        String[] stringArray = new String[]{};
        Step2Handler step2Handler = (Step2Handler)converterContext.getAttribute("CURRENT_STEP2_HANDLER");
        String string = step2Handler.retrieveFromAuePersistency("", REMOVE_DUPLICATE_MO_ENERGYMETER_STEP2_ACTION);
        if (string == null || string.length() == 0) {
            logger.traceDebug(THIS_CLASS, "No EnergyMeter to remove.");
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add("ManagedElement=1,Equipment=1,HwUnit=" + stringTokenizer.nextToken().trim() + ",EnergyMeter=1");
            }
            stringArray = arrayList.toArray(stringArray);
        }
        logger.traceReturn(THIS_CLASS, "getLdnsOfEnergyMetersToRemoveFromStep1()");
        return stringArray;
    }

    private void deleteMo(ConverterContext converterContext, final String string, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "deleteMo()");
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        try {
            MoDataWrapper moDataWrapper = moDataAccessor.findFirst(new MoDataFilter(){

                public boolean accept(MoDataWrapper moDataWrapper) {
                    String string2 = RemoveDuplicateMOEnergyMeterAction.this.trimLdn(moDataWrapper.getLocalDistinguishedName());
                    return string2.equals(string);
                }
            });
            if (moDataAccessor != null) {
                moDataAccessor.delete(moDataWrapper, coordinator);
            }
        }
        catch (AueException aueException) {
            CrbsAueException crbsAueException = new CrbsAueException(aueException.getMessage());
            crbsAueException.setStackTrace(aueException.getStackTrace());
            throw crbsAueException;
        }
        logger.traceReturn(THIS_CLASS, "deleteMo()");
    }

    private String trimLdn(String string) {
        return AueUtil.replaceInString((String)string, (String)" ", (String)"");
    }
}

