/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step2.actions;

import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step2.actions.util.Step2Handler;

public class SetCabinetParametesFromFileAction
implements MoDataAction {
    private static final Class THIS_CLASS = SetCabinetParametesFromFileAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String CABINET_PARAMETERS_PROFILE_EXTENDED = "cabinetParametersProfileExtended";
    private static final String CABINET_PARAMETERS_PROFILE_STANDARD = "cabinetParametersProfileStandard";
    private static final int PARAMETERS_ARRAY_LENGHT = 100;

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        MoDataWrapper moDataWrapper2 = null;
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        Collection collection = moDataAccessor.getByType("Cabinet");
        Step2Handler step2Handler = (Step2Handler)converterContext.getAttribute("CURRENT_STEP2_HANDLER");
        if (collection == null || collection.isEmpty()) {
            logger.traceGeneral(THIS_CLASS, "No Cabinet MOs found. Cabinet parameters can not be updated.");
        } else {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object object;
                try {
                    boolean bl;
                    moDataWrapper2 = (MoDataWrapper)iterator.next();
                    String string = moDataWrapper2.getLocalDistinguishedName();
                    object = step2Handler.retrieveFromAuePersistency(string, CABINET_PARAMETERS_PROFILE_STANDARD);
                    String string2 = step2Handler.retrieveFromAuePersistency(string, CABINET_PARAMETERS_PROFILE_EXTENDED);
                    boolean bl2 = object != null && !"".equals(object);
                    boolean bl3 = bl = string2 != null && !"".equals(string2);
                    if (bl2) {
                        this.setSequenceParameters(moDataWrapper2, CABINET_PARAMETERS_PROFILE_STANDARD, (String)object);
                    }
                    if (bl) {
                        this.setSequenceParameters(moDataWrapper2, CABINET_PARAMETERS_PROFILE_EXTENDED, string2);
                        continue;
                    }
                    if (!bl2) continue;
                    this.setSequenceParameters(moDataWrapper2, CABINET_PARAMETERS_PROFILE_EXTENDED, (String)object);
                }
                catch (AueException aueException) {
                    object = new CrbsAueException(aueException.getMessage());
                    object.setStackTrace(aueException.getStackTrace());
                    throw object;
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "perform()");
    }

    private void setSequenceParameters(MoDataWrapper moDataWrapper, String string, String string2) {
        logger.traceEnter(THIS_CLASS, "setSequenceParameters()");
        SequenceAttribute sequenceAttribute = (SequenceAttribute)moDataWrapper.getAttribute(string);
        Attribute[] attributeArray = this.getSequenceContent(string, string2);
        sequenceAttribute.setValue(attributeArray);
        logger.traceReturn(THIS_CLASS, "setSequenceParameters()");
    }

    private Attribute[] getSequenceContent(String string, String string2) {
        String string3;
        logger.traceEnter(THIS_CLASS, "getSequenceContent()");
        IntegerAttribute[] integerAttributeArray = new IntegerAttribute[100];
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            string3 = stringTokenizer.nextElement().toString();
            IntegerAttribute integerAttribute = new IntegerAttribute(string, false);
            integerAttribute.setValue(Integer.parseInt(string3));
            integerAttributeArray[n++] = integerAttribute;
        }
        while (n < integerAttributeArray.length) {
            string3 = new IntegerAttribute(string, false);
            string3.setValue(0);
            integerAttributeArray[n] = string3;
            ++n;
        }
        logger.traceReturn(THIS_CLASS, "getSequenceContent()");
        return integerAttributeArray;
    }
}

