/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step2.actions;

import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step2.actions.util.Step2Handler;

public class UpdateEcBusRefOnEcPortAction
implements MoDataAction {
    private static final String EC_PORT = "EcPort";
    private static final Class THIS_CLASS = UpdateEcBusRefOnEcPortAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String ECPORT_ATT_ECBUSREF = "ecBusRef";

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        if (moDataAccessor == null) {
            logger.traceAbnormal(THIS_CLASS, "MoDataAccessor accessor is null");
        } else {
            Collection collection = moDataAccessor.getByType(EC_PORT);
            if (collection != null) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    MoDataWrapper moDataWrapper2 = (MoDataWrapper)iterator.next();
                    String string = this.getLdnFromStep1(moDataWrapper2, converterContext);
                    ReferenceAttribute referenceAttribute = new ReferenceAttribute(ECPORT_ATT_ECBUSREF, string, true);
                    moDataWrapper2.deregisterAttribute(ECPORT_ATT_ECBUSREF);
                    moDataWrapper2.registerPersistentAttr((Attribute)referenceAttribute);
                    try {
                        moDataWrapper2.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                    }
                    catch (AueException aueException) {
                        CrbsAueException crbsAueException = new CrbsAueException(aueException.getMessage());
                        crbsAueException.setStackTrace(aueException.getStackTrace());
                        throw crbsAueException;
                    }
                }
            } else {
                logger.traceGeneral(THIS_CLASS, "No EcPort MOs found.");
            }
        }
        logger.traceReturn(THIS_CLASS, "perform()");
    }

    private String getLdnFromStep1(MoDataWrapper moDataWrapper, ConverterContext converterContext) throws CrbsAueException {
        String string;
        logger.traceEnter(THIS_CLASS, "getLdnFromStep1()");
        String string2 = moDataWrapper.getLocalDistinguishedName();
        logger.traceGeneral(THIS_CLASS, "Handling EcPort: " + string2);
        Step2Handler step2Handler = (Step2Handler)converterContext.getAttribute("CURRENT_STEP2_HANDLER");
        try {
            string = step2Handler.retrieveFromAuePersistency(string2, ECPORT_ATT_ECBUSREF);
            logger.traceGeneral(THIS_CLASS, "Found ecBusRef passed from step1: " + string);
        }
        catch (Exception exception) {
            throw new CrbsAueException("Can not read ecBusRef from AuePersistency database table for ldn=" + string2 + " Exception=" + exception.toString(), (Throwable)exception);
        }
        logger.traceReturn(THIS_CLASS, "getLdnFromStep1()");
        return string;
    }
}

