/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.convert.actions;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.su.convert.base.ConverterActionBase;
import se.ericsson.cello.su.convert.base.ConverterActionType;
import se.ericsson.cello.su.convert.exception.SuConvertActionException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class ReplaceLdnConverterAction
extends ConverterActionBase {
    private String myNewMoLdn = null;

    public ReplaceLdnConverterAction(String string, String string2) {
        super(ConverterActionType.REPLACE_LDN, string);
        this.myNewMoLdn = string2;
    }

    protected void execute(Collection collection, String string, Integer n) throws SuConvertActionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "execute(Collection aMoDatas, String aMoTypeName, Integer aNewMoDataRevision)", "Number of MoDatas: " + collection.size() + "\n\taMoTypeName: " + string + "\n\taNewMoDataRevision: " + n);
        }
        LinkedList<MoData> linkedList = new LinkedList<MoData>();
        MoData moData = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            moData = (MoData)iterator.next();
            if (!moData.getLocalDistinguishedName().equals(this.myMoLdn)) continue;
            linkedList.add(moData);
        }
        this.createNewMoData(collection, linkedList, n);
        this.deleteOldMoData(collection, linkedList);
    }

    public String getNewMoLdn() {
        return this.myNewMoLdn;
    }

    private void createNewMoData(Collection collection, Collection collection2, Integer n) throws SuConvertActionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createNewMoData(Collection aMoDatas, Collection aMoDatasToBeChanged, Integer aNewMoDataRevision)", "Number of MoDatas: " + collection.size() + "\n\tNumber of MoDatas to be changed: " + collection2.size() + "\n\taNewMoDataRevision: " + n);
        }
        try {
            TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
            Control control = transactionFactory.create(3600);
            Coordinator coordinator = control.getCoordinator();
            MoData moData = null;
            MoData moData2 = null;
            Iterator iterator = collection2.iterator();
            while (iterator.hasNext()) {
                moData2 = (MoData)iterator.next();
                moData = new MoData(this.myNewMoLdn, moData2.getMoTypeName(), true, coordinator);
                Enumeration enumeration = moData2.getAllPersistentAttributes();
                while (enumeration.hasMoreElements()) {
                    moData.registerPersistentAttr((Attribute)enumeration.nextElement());
                }
                moData.setRevision(n.intValue());
                moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                collection.add(moData);
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, "execute(MoData aMoData, Coordinator aContext)", "Created new MoData with LDN: " + moData.getLocalDistinguishedName());
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "execute(MoData aMoData, Coordinator aContext)", "Setting new MoData revision: " + n);
            }
            control.getTerminator().commit();
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createNewMoData(Collection aMoDatas, Collection aMoDatasToBeChanged, Integer aNewMoDataRevision)", "Failed to create new MoData, throwable caught.\n\tNew MoData LDN: " + this.myNewMoLdn, throwable);
            throw new SuConvertActionException("Failed to create new MoData, throwable caught. Throwable info: " + throwable);
        }
    }

    private void deleteOldMoData(Collection collection, Collection collection2) throws SuConvertActionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteOldMoData(Collection aMoDatas, Collection aMoDatasToBeDeleted)", "Number of MoDatas: " + collection.size() + "\n\tNumber of MoDatas to be deleted: " + collection2.size());
        }
        try {
            Vector<MoData> vector = new Vector<MoData>(1);
            TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
            Control control = transactionFactory.create(3600);
            Coordinator coordinator = control.getCoordinator();
            MoData moData = null;
            Iterator iterator = collection2.iterator();
            while (iterator.hasNext()) {
                moData = (MoData)iterator.next();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "deleteOldMoData(Collection aMoDatas, Collection aMoDatasToBeDeleted)", "Removing MoData from database.\n\tMoData LDN: " + moData.getLocalDistinguishedName());
                }
                moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                moData.delete(coordinator);
                vector.add(moData);
            }
            control.getTerminator().commit();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "execute(MoData aMoData, Coordinator aContext)", "Removing all MoData that has been deleted from the MoData collection.");
            }
            Iterator iterator2 = vector.iterator();
            while (iterator2.hasNext()) {
                collection.remove(iterator2.next());
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "execute(MoData aMoData)", "Failed to delete MoData from MoDatas, throwable caught.\n\tMo LDN: " + this.myMoLdn, throwable);
            throw new SuConvertActionException("Failed to delete MoData from MoDatas, throwable caught. Throwable info: " + throwable);
        }
    }

    public String toString() {
        return super.toString() + "\n\tNewMoLdn" + this.myNewMoLdn;
    }
}

