/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.extsuif.upgradepackage.util.helpers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringUtils;

public class StringHandler {
    private static final String EMPTY_STRING = "";
    private static final String WHITE_SPACE = " ";
    private static final char WHITE_SPACE_CHAR = ' ';

    public static boolean isContainingStringIgnoringCase(Collection collection, String string) {
        if (UpgradeTrace.valid((Class)StringHandler.class, (int)25)) {
            UpgradeTrace.debug((Class)StringHandler.class, (int)25, (String)"isContainingStringIgnoringCase(Collection aStrings, String aString)", (String)("aStrings: " + collection + "\n\taString: " + string));
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!((String)iterator.next()).equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isUnique(Collection collection) {
        if (UpgradeTrace.valid((Class)StringHandler.class, (int)25)) {
            UpgradeTrace.debug((Class)StringHandler.class, (int)25, (String)"isUnique ( Collection aStrings )", (String)("aStrings: " + collection));
        }
        Iterator iterator = collection.iterator();
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            if (hashSet.add(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isUnique(String[] stringArray) {
        if (UpgradeTrace.valid((Class)StringHandler.class, (int)25)) {
            UpgradeTrace.debug((Class)StringHandler.class, (int)25, (String)"isUnique ( String[] aStrings )", (String)("aStrings: " + StringUtils.toString(stringArray)));
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (hashSet.add(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isContainingWhiteSpaceOrLowerCase(String string) {
        if (string != null) {
            if (StringHandler.containsWhiteSpace(string)) {
                return true;
            }
            if (StringHandler.containsLowerCase(string)) {
                return true;
            }
        }
        return false;
    }

    public static String optimize(String string) {
        if (string != null) {
            if (StringHandler.containsWhiteSpace(string)) {
                string = StringHandler.removeWhiteSpaces(string);
            }
            if (StringHandler.containsLowerCase(string)) {
                string = string.toUpperCase();
            }
        }
        return string;
    }

    public static boolean containsWhiteSpace(String string) {
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != ' ') continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsLowerCase(String string) {
        boolean bl = false;
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                if (!Character.isLowerCase(string.charAt(i))) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static String removeSingleDotsAndDoubleDots(String string) {
        if (UpgradeTrace.valid((Class)StringHandler.class, (int)25)) {
            UpgradeTrace.debug((Class)StringHandler.class, (int)25, (String)"removeSingleDotsAndDoubleDots(String aString)", (String)("aString: " + string));
        }
        if (string == null || string.length() == 0) {
            return string;
        }
        int n = string.indexOf("/./");
        int n2 = string.indexOf("/../");
        while (n != -1) {
            string = n == 0 ? (string.length() == 3 ? "/" : "/" + string.substring(3)) : (n + 3 == string.length() ? string.substring(0, n) + "/" : string.substring(0, n) + "/" + string.substring(n + 3));
            n = string.indexOf("/./");
        }
        while (n2 != -1) {
            string = n2 == 0 ? (string.length() == 4 ? "/" : "/" + string.substring(4)) : (n2 + 4 == string.length() ? string.substring(0, n2) + "/" : string.substring(0, n2) + "/" + string.substring(n2 + 4));
            n2 = string.indexOf("/./");
        }
        return string;
    }

    public static String removeWhiteSpaces(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = EMPTY_STRING;
        StringTokenizer stringTokenizer = new StringTokenizer(string, WHITE_SPACE);
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + stringTokenizer.nextToken();
        }
        return string2;
    }

    public static String truncateFromTheMiddle(String string, int n) {
        if (UpgradeTrace.valid((Class)StringHandler.class, (int)25)) {
            UpgradeTrace.debug((Class)StringHandler.class, (int)25, (String)"truncateFromTheMiddle(String aStringToTruncate, int aRequestedLength)", (String)("aStringToTruncate: " + string + "\n\taRequestedLength: " + n));
        }
        int n2 = string.length() - n;
        int n3 = string.length() / 2;
        while (n2 > 0) {
            if (n2 == 1) {
                string = string.substring(0, n3) + string.substring(n3 + 1, string.length());
                --n2;
            } else {
                string = string.substring(0, n3 - n2 / 2) + string.substring(n3 + n2 / 2, string.length());
                n2 = n2 - n2 / 2 - n2 / 2;
            }
            n3 = string.length() / 2;
        }
        return string.substring(0, n3) + "." + string.substring(n3 + 1, string.length());
    }

    public static boolean stringsAreEqualIgnoringWhiteSpaceAndCase(String string, String string2) {
        if (UpgradeTrace.valid((Class)StringHandler.class, (int)25)) {
            UpgradeTrace.debug((Class)StringHandler.class, (int)25, (String)"stringsAreEqualIgnoringWhiteSpaceAndCase(String aFirstString, String aSecondString)", (String)("aFirstString: " + string + "\n\taSecondString: " + string2));
        }
        return string == null ? StringHandler.removeWhiteSpaces(string2) == null : (string2 == null ? StringHandler.removeWhiteSpaces(string) == null : StringHandler.removeWhiteSpaces(string).equalsIgnoreCase(StringHandler.removeWhiteSpaces(string2)));
    }

    public static boolean stringsAreEqual(String string, String string2) {
        if (UpgradeTrace.valid((Class)StringHandler.class, (int)25)) {
            UpgradeTrace.debug((Class)StringHandler.class, (int)25, (String)"stringsAreEqual(String aFirstString, String aSecondString)", (String)("aFirstString: " + string + "\n\taSecondString: " + string2));
        }
        if (string == null) {
            if (string2 == null) {
                return true;
            }
        } else {
            if (string2 == null) {
                return false;
            }
            if (string.equals(string2)) {
                return true;
            }
        }
        return false;
    }

    public static String[] splitString(char c, String string) {
        char[] cArray = new char[]{c};
        String string2 = new String(cArray);
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        System.out.println("\nThe number of tokens: " + stringTokenizer.countTokens());
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }
}

