/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.uci.control;

import java.util.Collection;
import java.util.LinkedList;
import se.ericsson.cello.su.uci.verify.VerificationResult;
import se.ericsson.cello.upgradepackage.main.util.ActionResultData;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class TriggerExecutionResult {
    public int confirmStatus = 0;
    public Collection actionResultDatas = new LinkedList();

    public TriggerExecutionResult(int n) {
        this.confirmStatus = n;
    }

    public TriggerExecutionResult(int n, ActionResultData actionResultData) {
        this.confirmStatus = n;
        this.actionResultDatas.add(actionResultData);
    }

    public TriggerExecutionResult(VerificationResult verificationResult) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "TriggerExecutionResult(VerificationResult aVerificationResult)", "aVerificationResult: " + verificationResult);
        }
        if (verificationResult.isCheckExecuted) {
            if (verificationResult.isResultOfCheckOK) {
                this.confirmStatus = 1;
            } else {
                this.confirmStatus = verificationResult.isStopping ? 0 : 2;
                this.actionResultDatas.add(verificationResult.actionResultData);
            }
        } else {
            this.confirmStatus = verificationResult.isStopping ? 0 : 2;
            this.actionResultDatas.add(verificationResult.actionResultData);
        }
    }

    public void addVerificationResult(VerificationResult verificationResult) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addTriggerExecutionResult(VerificationResult aVerificationResult)", "aVerificationResult: " + verificationResult);
        }
        if (verificationResult != null) {
            if (verificationResult.isCheckExecuted) {
                if (!verificationResult.isResultOfCheckOK) {
                    if (verificationResult.isStopping) {
                        this.confirmStatus = 0;
                    } else if (this.confirmStatus == 1) {
                        this.confirmStatus = 2;
                    }
                    this.actionResultDatas.add(verificationResult.actionResultData);
                }
            } else {
                if (verificationResult.isStopping) {
                    this.confirmStatus = 0;
                } else if (this.confirmStatus == 1) {
                    this.confirmStatus = 2;
                }
                this.actionResultDatas.add(verificationResult.actionResultData);
            }
        }
    }

    public String toString() {
        return "\n\tconfirmStatus: " + this.confirmStatus + "\n\tactionResultDatas: " + this.actionResultDatas;
    }
}

