/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence;

import java.util.Collection;
import java.util.LinkedList;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.TypeOfUpgrade;
import se.ericsson.cello.sudom.extsuif.proxy.exceptions.SequenceInformationException;

public class ValidUpgradeCasesInformation {
    private LinkedList myRebootNodeCases = null;
    private LinkedList myUpgradeCases = null;
    private LinkedList myUpdateCases = null;

    public ValidUpgradeCasesInformation(LinkedList linkedList, LinkedList linkedList2, LinkedList linkedList3) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"ValidUpgradeCasesInformation(LinkedList aRebootNodeCases, LinkedList anUpgradeCases, LinkedList anUpdateCases)", (String)("aRebootNodeCases: " + linkedList + "\n\tanUpgradeCases: " + linkedList2 + "\n\tanUpdateCases: " + linkedList3));
        }
        this.myRebootNodeCases = linkedList;
        this.myUpgradeCases = linkedList2;
        this.myUpdateCases = linkedList3;
    }

    public Collection getValidUpgradeCases(TypeOfUpgrade typeOfUpgrade) throws SequenceInformationException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getValidUpgradeCases(TypeOfUpgrade aTypeOfUpgrade)");
        }
        if (TypeOfUpgrade.RebootNodeUpgrade.getValue().equals(typeOfUpgrade.getValue())) {
            return this.myRebootNodeCases;
        }
        if (TypeOfUpgrade.Upgrade.getValue().equals(typeOfUpgrade.getValue())) {
            return this.myUpgradeCases;
        }
        if (TypeOfUpgrade.Update.getValue().equals(typeOfUpgrade.getValue())) {
            return this.myUpdateCases;
        }
        UpgradeTrace.error(this.getClass(), (String)"getValidUpgradeCases(TypeOfUpgrade aTypeOfUpgrade)", (String)("Unexpected type of upgrade received (no sequence is found for this one...)\n\taTypeOfUpgrade: " + typeOfUpgrade));
        return new LinkedList();
    }

    public String getFirstFoundSupportedUpgradeCase() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getFirstFoundSupportedUpgradeCase( )");
        }
        String string = null;
        if (this.myRebootNodeCases != null && !this.myRebootNodeCases.isEmpty()) {
            string = (String)this.myRebootNodeCases.getFirst();
        } else if (this.myUpgradeCases != null && !this.myUpgradeCases.isEmpty()) {
            string = (String)this.myUpgradeCases.getFirst();
        } else if (this.myUpdateCases != null && !this.myUpdateCases.isEmpty()) {
            string = (String)this.myUpdateCases.getFirst();
        }
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getFirstFoundSupportedUpgradeCase()", (String)("Returning - theAllFirstSupportedUpgradeCases: " + string));
        }
        return string;
    }

    public String toString() {
        return "\n\tmyRebootNodeCases: " + this.myRebootNodeCases + "\n\tmyUpgradeCases: " + this.myUpgradeCases + "\n\tmyUpdateCases: " + this.myUpdateCases;
    }
}

