/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.control.transform;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.parser.control.transform.TransformException;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectUpgradePackage;
import se.ericsson.cello.sudom.parser.dom.repertoire.LoadModuleRef;
import se.ericsson.cello.sudom.parser.dom.repertoire.LoadModuleRefAttributeName;
import se.ericsson.cello.sudom.parser.dom.repertoire.PiuTypeLoadList;
import se.ericsson.cello.sudom.parser.dom.repertoire.Repertoire;
import se.ericsson.cello.sudom.parser.dom.transform.Value;

public class RepertoireTransformer {
    public static final String LoadModuleRefPath = "UpgradePackage/Repertoire/PiuTypeLoadList/LoadModuleRef";

    public void execute(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("execute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)aTransformValueElement: " + value + "\n\taDOUP: " + documentObjectUpgradePackage));
        }
        if (value.getElementPath().equals(LoadModuleRefPath)) {
            this.transformLoadModuleRefAttribute(value, documentObjectUpgradePackage);
        } else {
            UpgradeTrace.info(this.getClass(), (String)"execute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("Unexpected element path has been specified which is ignored\n\tUCF Element path: " + value.getElementPath() + "\n\tUCF Attribute name: " + value.getAttributeName() + "\n\tUCF From value: " + value.getFrom() + "\n\tUCF To value: " + value.getTo()));
        }
    }

    private void transformLoadModuleRefAttribute(Value value, DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"transformLoadModuleRefAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("aTransformValueElement: " + value + "\n\taDOUP: " + documentObjectUpgradePackage));
        }
        Collection collection = this.getLoadModuleRefs(documentObjectUpgradePackage);
        Iterator iterator = collection.iterator();
        LoadModuleRef loadModuleRef = null;
        while (iterator.hasNext()) {
            loadModuleRef = (LoadModuleRef)iterator.next();
            if (value.getAttributeName().equals(LoadModuleRefAttributeName.LoaderName.getValue())) {
                if (loadModuleRef.getLoaderName() == null || !loadModuleRef.getLoaderName().equals(value.getFrom())) continue;
                loadModuleRef.setLoaderName(value.getTo());
                continue;
            }
            UpgradeTrace.info(this.getClass(), (String)"transformLoadModuleRefAttribute(Value aTransformValueElement, DocumentObjectUpgradePackage aDOUP)", (String)("Unexpected attribute (ignored)\n\tElement path: " + value.getElementPath() + "\n\tAttribute name: " + value.getAttributeName() + "\n\tFrom value: " + value.getFrom() + "\n\tTo value: " + value.getTo()));
        }
    }

    private Collection getLoadModuleRefs(DocumentObjectUpgradePackage documentObjectUpgradePackage) throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getLoadModuleRefs(DocumentObjectUpgradePackage aDOUP)aDOUP: " + documentObjectUpgradePackage));
        }
        Vector vector = documentObjectUpgradePackage.getRepertoires();
        Iterator iterator = vector.iterator();
        LinkedList linkedList = new LinkedList();
        Repertoire repertoire = null;
        Iterator iterator2 = null;
        PiuTypeLoadList piuTypeLoadList = null;
        while (iterator.hasNext()) {
            repertoire = (Repertoire)iterator.next();
            iterator2 = repertoire.getPiuTypeLoadLists().iterator();
            while (iterator2.hasNext()) {
                piuTypeLoadList = (PiuTypeLoadList)iterator2.next();
                linkedList.addAll(piuTypeLoadList.getLoadModuleRefs());
            }
        }
        return linkedList;
    }
}

