/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom;

import org.xml.sax.AttributeList;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.parser.ControlFileDocumentHandler;
import se.ericsson.cello.sudom.parser.MainElementHolder;
import se.ericsson.cello.sudom.parser.RootElementName;
import se.ericsson.cello.sudom.parser.control.transform.TransformController;
import se.ericsson.cello.sudom.parser.control.transform.TransformException;
import se.ericsson.cello.sudom.parser.dom.CommonDocumentObjectInformation;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectControllerInterface;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectHolder;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectInterface;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectUpgradePackage;
import se.ericsson.cello.sudom.parser.dom.exceptions.UnexpectedElementException;
import se.ericsson.cello.sudom.parser.dom.util.locator.LocatorProxy;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;

public class DocumentObjectController
implements DocumentObjectControllerInterface {
    private int myCurrentDocumentObect = -1;
    private MainElementHolder myMainElementHolder = null;
    private boolean myValidationNeeded = false;
    private int myReceivedDocumentObjectLevel = -1;
    private DocumentObjectUpgradePackage myDocumentObjectUpgradePackage = null;
    private DocumentObjectHolder myCurrentDocumentObjects = new DocumentObjectHolder();
    private ControlFileDocumentHandler myControlFileDocumentHandler;

    public DocumentObjectController(ControlFileDocumentHandler controlFileDocumentHandler, boolean bl) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"DocumentObjectController ( ControlFileDocumentHandler aControlFileDocumentHandler, boolean aValidationNeeded )", (String)("aControlFileDocumentHandler: " + controlFileDocumentHandler + "\t\naValidationNeeded: " + bl));
        }
        this.myControlFileDocumentHandler = controlFileDocumentHandler;
        this.myValidationNeeded = bl;
    }

    public DocumentObjectUpgradePackage getDocumentObjectForUpgradePackage() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getDocumentObjectForUpgradePackage ( )");
        }
        return this.myDocumentObjectUpgradePackage;
    }

    public void startDocument(Locator locator) throws SAXException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"startDocument ( Locator aLocator )", (String)("aLocator: " + locator));
        }
        try {
            this.myMainElementHolder = this.myControlFileDocumentHandler.getMainElements();
            if (UpgradeTrace.valid(this.getClass(), (int)27)) {
                UpgradeTrace.debug(this.getClass(), (int)27, (String)"startDocument ( Locator aLocator )", (String)("myMainElementHolder: " + this.myMainElementHolder));
            }
            if (this.myMainElementHolder == null) {
                this.myMainElementHolder = new MainElementHolder();
            }
            CommonDocumentObjectInformation.getInstance().setValidationNeeded(this.myValidationNeeded);
        }
        catch (Exception exception) {
            UpgradeTrace.error(this.getClass(), (String)"startDocument(Locator aLocator)", (String)("Exception caught when start of UCF detected.\taLocator: " + LocatorProxy.getLocatorInfo(locator) + "\n\tmyDocumentObjectUpgradePackage: " + this.myDocumentObjectUpgradePackage + "\n\tmyCurrentDocumentObect: " + this.myCurrentDocumentObect + "\n\tmyReceivedDocumentObjectLevel: " + this.myReceivedDocumentObjectLevel + "\n\tmyCurrentDocumentObjects: " + this.myCurrentDocumentObjects), (Throwable)exception);
            throw new SAXException("Exception caught when start of UCF detected.\taLocator: " + LocatorProxy.getLocatorInfo(locator) + "\n\tmyDocumentObjectUpgradePackage: " + this.myDocumentObjectUpgradePackage + "\n\tmyCurrentDocumentObect: " + this.myCurrentDocumentObect + "\n\tmyReceivedDocumentObjectLevel: " + this.myReceivedDocumentObjectLevel + "\n\tmyCurrentDocumentObjects: " + this.myCurrentDocumentObjects, exception);
        }
    }

    public void startElement(String string, AttributeList attributeList, Locator locator) throws SAXException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"startElement ( String anElementName, AttributeList aListOfAttributes, Locator aLocator )", (String)("anElementName: " + string + "\n\taListOfAttributes: " + attributeList + "\n\taLocator: " + locator));
        }
        try {
            ++this.myReceivedDocumentObjectLevel;
            if (UpgradeTrace.valid(this.getClass(), (int)27)) {
                UpgradeTrace.debug(this.getClass(), (int)27, (String)"startElement ( String anElementName, AttributeList aListOfAttributes, Locator aLocator )", (String)("myDocumentObjectUpgradePackage: " + this.myDocumentObjectUpgradePackage + "\n\tmyCurrentDocumentObect: " + this.myCurrentDocumentObect + "\n\tmyReceivedDocumentObjectLevel: " + this.myReceivedDocumentObjectLevel + "\n\tmyCurrentDocumentObjects: " + this.myCurrentDocumentObjects));
            }
            if (this.myReceivedDocumentObjectLevel == 0) {
                if (string.equals(RootElementName.UpgradePackage.getValue())) {
                    if (this.myDocumentObjectUpgradePackage == null) {
                        this.myDocumentObjectUpgradePackage = new DocumentObjectUpgradePackage(attributeList, this.selectLocatorOrNull(locator));
                        this.myCurrentDocumentObjects = new DocumentObjectHolder();
                        this.myCurrentDocumentObjects.add(this.myDocumentObjectUpgradePackage);
                    }
                    this.myDocumentObjectUpgradePackage.setCommonDocumentInformation();
                    ++this.myCurrentDocumentObect;
                } else {
                    this.errorUnexpectedRootElement("startElement(String anElementName, AttributeList aListOfAttributes, Locator aLocator)", string, locator);
                }
            } else if (this.myReceivedDocumentObjectLevel == 1) {
                if (UpgradeTrace.valid(this.getClass(), (int)27)) {
                    UpgradeTrace.debug(this.getClass(), (int)27, (String)"startElement ( String anElementName, AttributeList aListOfAttributes, Locator aLocator )", (String)("myDocumentObjectUpgradePackage.isMainElement ( anElementName, aLocator)" + this.myDocumentObjectUpgradePackage.isMainElement(string, locator) + "\n\tmyMainElementHolder.contains ( anElementName ): " + this.myMainElementHolder.contains(string)));
                }
                if (this.myDocumentObjectUpgradePackage.isMainElement(string, locator) && this.myMainElementHolder.contains(string)) {
                    if (UpgradeTrace.valid(this.getClass(), (int)27)) {
                        UpgradeTrace.debug(this.getClass(), (int)27, (String)"startElement ( String anElementName, AttributeList aListOfAttributes, Locator aLocator )", (String)("\n---------------------------------------------------------------------------------------------------\n\t-- Received M A I N element  (" + string + ") shall be parsed, invoking create on element\n\t " + this.myCurrentDocumentObjects.get(this.myCurrentDocumentObect).getClass().getName() + "." + "\n---------------------------------------------------------------------------------------------------"));
                    }
                    DocumentObjectInterface documentObjectInterface = this.myCurrentDocumentObjects.get(this.myCurrentDocumentObect).create(string, attributeList, this.selectLocatorOrNull(locator));
                    this.myCurrentDocumentObjects.add(documentObjectInterface);
                    ++this.myCurrentDocumentObect;
                }
            } else if (this.myReceivedDocumentObjectLevel > 1 && this.myCurrentDocumentObect > 0) {
                if (UpgradeTrace.valid(this.getClass(), (int)27)) {
                    UpgradeTrace.debug(this.getClass(), (int)27, (String)"startElement ( String anElementName, AttributeList aListOfAttributes, Locator aLocator )", (String)("--- Received S U B element  (" + string + ") shall be parsed, invoking create on element  " + this.myCurrentDocumentObjects.get(this.myCurrentDocumentObect).getClass().getName() + "."));
                }
                DocumentObjectInterface documentObjectInterface = this.myCurrentDocumentObjects.get(this.myCurrentDocumentObect).create(string, attributeList, this.selectLocatorOrNull(locator));
                this.myCurrentDocumentObjects.add(documentObjectInterface);
                ++this.myCurrentDocumentObect;
            }
        }
        catch (ValidateException validateException) {
            if (UpgradeTrace.valid((Class)DocumentObjectController.class, (int)25)) {
                UpgradeTrace.debug((Class)DocumentObjectController.class, (int)25, (String)"startElement(String anElementName, AttributeList aListOfAttributes, Locator aLocator)", (String)("Validate exception caught.\n\tValidateException info: " + validateException));
            }
            throw validateException;
        }
        catch (Exception exception) {
            UpgradeTrace.error(this.getClass(), (String)"startElement(String anElementName, AttributeList aListOfAttributes, Locator aLocator)", (String)("Exception caught during parsing of UCF.\n\tanElementName: " + string + "\n\taListOfAttributes: " + attributeList + "\n\taLocator: " + locator + "\n\tmyDocumentObjectUpgradePackage: " + this.myDocumentObjectUpgradePackage + "\n\tmyCurrentDocumentObect: " + this.myCurrentDocumentObect + "\n\tmyReceivedDocumentObjectLevel: " + this.myReceivedDocumentObjectLevel + "\n\tmyCurrentDocumentObjects: " + this.myCurrentDocumentObjects), (Throwable)exception);
            throw new SAXException("Exception caught during parsing of UCF.\n\tanElementName: " + string + "\n\taListOfAttributes: " + attributeList + "\n\taLocator: " + locator + "\n\tmyDocumentObjectUpgradePackage: " + this.myDocumentObjectUpgradePackage + "\n\tmyCurrentDocumentObect: " + this.myCurrentDocumentObect + "\n\tmyReceivedDocumentObjectLevel: " + this.myReceivedDocumentObjectLevel + "\n\tmyCurrentDocumentObjects: " + this.myCurrentDocumentObjects, exception);
        }
    }

    public void endElement(String string, Locator locator) throws SAXException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"endElement( String anElementName, Locator aLocator )", (String)("anElementName: " + string + "\n\taLocator: " + locator));
        }
        if (UpgradeTrace.valid(this.getClass(), (int)27)) {
            UpgradeTrace.debug(this.getClass(), (int)27, (String)"endElement( String anElementName, Locator aLocator )", (String)("myDocumentObjectUpgradePackage: " + this.myDocumentObjectUpgradePackage + "\n\tmyCurrentDocumentObect: " + this.myCurrentDocumentObect));
        }
        try {
            --this.myReceivedDocumentObjectLevel;
            if (this.myDocumentObjectUpgradePackage == null) {
                return;
            }
            if (this.myCurrentDocumentObect > 0) {
                this.myCurrentDocumentObjects.remove(this.myCurrentDocumentObect);
                --this.myCurrentDocumentObect;
            }
        }
        catch (Exception exception) {
            UpgradeTrace.error(this.getClass(), (String)"endElement(String anElementName, Locator aLocator)", (String)("Exception caught when an end element in UCF detected.\taLocator: " + LocatorProxy.getLocatorInfo(locator) + "\n\tanElementName: " + string + "\n\tmyDocumentObjectUpgradePackage: " + this.myDocumentObjectUpgradePackage + "\n\tmyCurrentDocumentObect: " + this.myCurrentDocumentObect + "\n\tmyReceivedDocumentObjectLevel: " + this.myReceivedDocumentObjectLevel + "\n\tmyCurrentDocumentObjects: " + this.myCurrentDocumentObjects), (Throwable)exception);
            throw new SAXException("Exception caught when an end element in UCF detected.\taLocator: " + LocatorProxy.getLocatorInfo(locator) + "\n\tanElementName: " + string + "\n\tmyDocumentObjectUpgradePackage: " + this.myDocumentObjectUpgradePackage + "\n\tmyCurrentDocumentObect: " + this.myCurrentDocumentObect + "\n\tmyReceivedDocumentObjectLevel: " + this.myReceivedDocumentObjectLevel + "\n\tmyCurrentDocumentObjects: " + this.myCurrentDocumentObjects, exception);
        }
    }

    public void endDocument(Locator locator) throws SAXException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"endDocument(  Locator aLocator )", (String)("aLocator: " + locator));
        }
        try {
            this.myCurrentDocumentObect = -1;
            if (this.myReceivedDocumentObjectLevel != -1) {
                UpgradeTrace.error(this.getClass(), (String)"endDocument(Locator aLocator)", (String)("The attribute myReceivedDocumentObjectLevel should have value -1 but is has not. The value is " + this.myReceivedDocumentObjectLevel + "Setting it to -1."));
                this.myReceivedDocumentObjectLevel = -1;
            }
            if (this.myDocumentObjectUpgradePackage != null) {
                this.transform();
                if (this.myValidationNeeded) {
                    this.myDocumentObjectUpgradePackage.validate();
                }
            }
        }
        catch (ValidateException validateException) {
            UpgradeTrace.log1(this.getClass(), (String)"endDocument(Locator aLocator)", (String)("Validate exception caught when end of UCF is detected.\taLocator: " + LocatorProxy.getLocatorInfo(locator) + "\n\tmyDocumentObjectUpgradePackage: " + this.myDocumentObjectUpgradePackage + "\n\tmyCurrentDocumentObect: " + this.myCurrentDocumentObect + "\n\tmyReceivedDocumentObjectLevel: " + this.myReceivedDocumentObjectLevel + "\n\tmyCurrentDocumentObjects: " + this.myCurrentDocumentObjects + validateException.toString()));
            throw validateException;
        }
        catch (TransformException transformException) {
            UpgradeTrace.log1(this.getClass(), (String)"endDocument(Locator aLocator)", (String)("TransformE xception caught when end of UCF is detected.\taLocator: " + LocatorProxy.getLocatorInfo(locator) + "\n\tmyDocumentObjectUpgradePackage: " + this.myDocumentObjectUpgradePackage + "\n\tmyCurrentDocumentObect: " + this.myCurrentDocumentObect + "\n\tmyReceivedDocumentObjectLevel: " + this.myReceivedDocumentObjectLevel + "\n\tmyCurrentDocumentObjects: " + this.myCurrentDocumentObjects + transformException.toString()));
            throw new ValidateException(transformException.toString());
        }
        catch (Exception exception) {
            UpgradeTrace.error(this.getClass(), (String)"endDocument(Locator aLocator)", (String)("Exception caught when end of UCF is detected.\taLocator: " + LocatorProxy.getLocatorInfo(locator) + "\n\tmyDocumentObjectUpgradePackage: " + this.myDocumentObjectUpgradePackage + "\n\tmyCurrentDocumentObect: " + this.myCurrentDocumentObect + "\n\tmyReceivedDocumentObjectLevel: " + this.myReceivedDocumentObjectLevel + "\n\tmyCurrentDocumentObjects: " + this.myCurrentDocumentObjects), (Throwable)exception);
            throw new SAXException("Exception caught when end of UCF is detected.\taLocator: " + LocatorProxy.getLocatorInfo(locator) + "\n\tmyDocumentObjectUpgradePackage: " + this.myDocumentObjectUpgradePackage + "\n\tmyCurrentDocumentObect: " + this.myCurrentDocumentObect + "\n\tmyReceivedDocumentObjectLevel: " + this.myReceivedDocumentObjectLevel + "\n\tmyCurrentDocumentObjects: " + this.myCurrentDocumentObjects, exception);
        }
    }

    private void transform() throws TransformException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"transform()");
        }
        if (this.myDocumentObjectUpgradePackage.getTransform() != null) {
            TransformController transformController = new TransformController();
            transformController.execute(this.myDocumentObjectUpgradePackage, this.myDocumentObjectUpgradePackage.getTransform().getValues());
        }
    }

    public void cleanup() {
        this.myMainElementHolder = null;
        this.myDocumentObjectUpgradePackage = null;
        this.myCurrentDocumentObjects = null;
        this.myControlFileDocumentHandler = null;
    }

    private void errorUnexpectedRootElement(String string, String string2, Locator locator) throws UnexpectedElementException {
        String string3 = "Upgrade control file error,\n\troot element of not allowed type " + string2 + " detected," + "\n\tthe root element must be of type " + RootElementName.UpgradePackage.getValue() + ".";
        UpgradeTrace.error(this.getClass(), (String)string, (String)(string3 + "\n\tLocation: " + LocatorProxy.getLocatorInfo(locator)));
        throw new UnexpectedElementException(string3, locator.getLineNumber(), locator.getColumnNumber());
    }

    private Locator selectLocatorOrNull(Locator locator) {
        if (this.myValidationNeeded) {
            return locator;
        }
        return null;
    }
}

