/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom;

import org.xml.sax.Locator;
import org.xml.sax.helpers.LocatorImpl;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringUtils;
import se.ericsson.cello.sudom.parser.AttributeMissingException;
import se.ericsson.cello.sudom.parser.IllegalAttributeValueException;
import se.ericsson.cello.sudom.parser.MandatoryElementIsMissingException;
import se.ericsson.cello.sudom.parser.UnexpectedAttributeException;
import se.ericsson.cello.sudom.parser.dom.CommonDocumentObjectInformation;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectInterface;
import se.ericsson.cello.sudom.parser.dom.LackingSubElementException;
import se.ericsson.cello.sudom.parser.dom.UnexpectedElementReason;
import se.ericsson.cello.sudom.parser.dom.UnknownElement;
import se.ericsson.cello.sudom.parser.dom.exceptions.UnexpectedElementException;
import se.ericsson.cello.sudom.parser.dom.util.locator.LocatorProxy;

public abstract class ParsedData {
    private Locator myLocator = null;
    private String myLocatorString = null;

    protected ParsedData(Locator locator) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"ParsedData(Locator aLocator)", (String)("\n\taLocator: " + locator));
        }
        if (locator != null) {
            this.myLocator = new LocatorImpl(locator);
            this.myLocatorString = LocatorProxy.getLocatorInfo(locator);
        }
    }

    protected ParsedData() {
    }

    protected Locator getLocatorData() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getLocatorData( )");
        }
        if (this.myLocator != null) {
            return this.myLocator;
        }
        return new LocatorImpl();
    }

    public String getLocatorString() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getLocatorString()");
        }
        if (this.myLocatorString != null) {
            return this.myLocatorString;
        }
        return "";
    }

    protected DocumentObjectInterface error(String string, String string2, Locator locator) throws UnexpectedElementException {
        UpgradeTrace.error(this.getClass(), (String)string, (String)(string2 + LocatorProxy.getLocatorInfo(locator)));
        throw new UnexpectedElementException(string2, locator.getLineNumber(), locator.getColumnNumber());
    }

    protected void errorAdditionalInfoAttributeMissing(Class clazz, String string, String string2, String string3, String string4, Locator locator) throws AttributeMissingException {
        String string5 = "Upgrade control file error,\n\tmandatory attribute missing: attribute " + string3 + " not found in element of type " + string2 + "." + string4;
        UpgradeTrace.info((Class)clazz, (String)string, (String)(string5 + LocatorProxy.getLocatorInfo(locator)));
        throw new AttributeMissingException(string5, locator);
    }

    protected static void errorElementIsMissingNoSubElementWithLocatorString(Class clazz, String string, String string2, String string3, String string4, String string5) throws MandatoryElementIsMissingException {
        String string6 = "Upgrade control file error,\n\telement of type " + string3 + " in parent element of type " + string2 + "\n\tdoes not contain mandatory sub element(s).";
        UpgradeTrace.info((Class)clazz, (String)string, (String)(string6 + string4 + string5));
        throw new MandatoryElementIsMissingException(string6, string4, string5);
    }

    protected DocumentObjectInterface errorMoreElementsThanExpected(String string, String string2, String string3, Locator locator) throws UnexpectedElementException {
        return this.errorUnexpectedElement(UnexpectedElementReason.MoreElementsThanExpected, string, string2, string3, locator);
    }

    protected DocumentObjectInterface errorUnexpectedElement(UnexpectedElementReason unexpectedElementReason, String string, String string2, String string3, Locator locator) throws UnexpectedElementException {
        String string4 = "";
        if (unexpectedElementReason.equals(UnexpectedElementReason.SubElementNotAllowed)) {
            string4 = "Upgrade control file error,\n\telement of type " + string2 + " contains sub element of not allowed type " + string3 + ".";
        } else if (unexpectedElementReason.equals(UnexpectedElementReason.MoreElementsThanExpected)) {
            string4 = "Upgrade control file error,\n\telement of type " + string2 + " contains more sub elements of type " + string3 + " than allowed.";
        }
        String string5 = LocatorProxy.getLocatorInfo(locator);
        UpgradeTrace.info(this.getClass(), (String)string, (String)(string4 + "\n\tLocation: " + string5));
        throw new UnexpectedElementException(string4, string5);
    }

    protected void errorUnexpectedElement(UnexpectedElementReason unexpectedElementReason, String string, String string2, String string3, String string4, Locator locator) throws UnexpectedElementException {
        String string5 = "";
        if (unexpectedElementReason.equals(UnexpectedElementReason.SubElementNotAllowed)) {
            string5 = "Upgrade control file error,\n\telement of type " + string2 + " contains sub element of not allowed type " + string3 + ".";
        } else if (unexpectedElementReason.equals(UnexpectedElementReason.MoreElementsThanExpected)) {
            string5 = "Upgrade control file error,\n\telement of type " + string2 + " contains more sub elements of type " + string3 + " than allowed.";
        }
        UpgradeTrace.info(this.getClass(), (String)string, (String)(string5 + string4 + "\n\tLocation: " + LocatorProxy.getLocatorInfo(locator)));
        throw new UnexpectedElementException(string5, string4, locator);
    }

    protected void handleUnexpectedAttribute(String string, String string2, String[] stringArray, Locator locator) throws UnexpectedAttributeException {
        if (CommonDocumentObjectInformation.getInstance().getValidationNeeded()) {
            if (stringArray != null && CommonDocumentObjectInformation.getInstance().getIgnoreUnknownAttributes()) {
                this.addUnexpectedAttributeWarning(string2, stringArray);
            } else {
                this.errorUnexpectedAttribute(string, string2, stringArray, locator);
            }
        } else {
            this.debugUnexpectedAttribute(string2, stringArray, locator);
        }
    }

    protected DocumentObjectInterface handleUnexpectedElement(String string, String string2, String string3, Locator locator) throws UnexpectedElementException {
        return this.handleUnexpectedElement(UnexpectedElementReason.SubElementNotAllowed, string, string2, string3, locator);
    }

    protected DocumentObjectInterface handleUnexpectedElement(UnexpectedElementReason unexpectedElementReason, String string, String string2, String string3, Locator locator) throws UnexpectedElementException {
        if (CommonDocumentObjectInformation.getInstance().getValidationNeeded()) {
            if (unexpectedElementReason.equals(UnexpectedElementReason.SubElementNotAllowed) && CommonDocumentObjectInformation.getInstance().getIgnoreUnknownElements()) {
                this.addUnexpectedSubElementWarning(string2, string3);
                return new UnknownElement(locator);
            }
            return this.errorUnexpectedElement(unexpectedElementReason, string, string2, string3, locator);
        }
        this.debugUnexpectedElement(unexpectedElementReason, string2, string3, locator);
        return new UnknownElement(locator);
    }

    protected void errorUnexpectedAttribute(String string, String string2, String[] stringArray, Locator locator) throws UnexpectedAttributeException {
        String string3 = "Upgrade control file error,\n\telement of type " + string2 + " contains unexpected attribute(s)." + "\n\tUnexpected attribute(s): ";
        String string4 = StringUtils.toString(stringArray);
        UpgradeTrace.info(this.getClass(), (String)string, (String)(string3 + string4 + "\n\tLocation: " + LocatorProxy.getLocatorInfo(locator)));
        throw new UnexpectedAttributeException(string3 + string4, locator.getLineNumber(), locator.getColumnNumber());
    }

    protected void errorLackingSubElementException(Class clazz, String string, String string2, Locator locator) throws LackingSubElementException {
        String string3 = "Upgrade control file error.\n\telement of type " + string2 + " Lacking TransformValue sub-element(s) where there is a Transform Element.";
        UpgradeTrace.info((Class)clazz, (String)string, (String)(string3 + "\n\tLocation: " + LocatorProxy.getLocatorInfo(locator)));
        throw new LackingSubElementException(string3, locator);
    }

    protected void errorUnexpectedAttribute(Class clazz, String string, String string2, String string3, String[] stringArray, String string4, Locator locator) throws UnexpectedAttributeException {
        String string5 = "Upgrade control file error,\n\telement of type " + string3 + " in parent element of type " + string2 + " contains unexpected attribute(s)." + "\n\tUnexpected attribute(s): ";
        String string6 = StringUtils.toString(stringArray);
        UpgradeTrace.info((Class)clazz, (String)string, (String)(string5 + string6 + string4 + "\n\tLocation: " + LocatorProxy.getLocatorInfo(locator)));
        throw new UnexpectedAttributeException(string5 + string6, string4, locator);
    }

    private void addUnexpectedAttributeWarning(String string, String[] stringArray) {
        CommonDocumentObjectInformation.getInstance().addIgnoredUnknownAttributes(string, stringArray);
    }

    private void addUnexpectedSubElementWarning(String string, String string2) {
        CommonDocumentObjectInformation.getInstance().addIgnoredUnknownSubElement(string, string2);
    }

    private void debugUnexpectedAttribute(String string, String[] stringArray, Locator locator) {
        if (UpgradeTrace.valid((Class)ParsedData.class, (int)25)) {
            UpgradeTrace.debug((Class)ParsedData.class, (int)25, (String)"debugUnexpectedAttribute(String anElementName, String[] anAttributeNames, Locator aDocumentLocator)", (String)("Attribute(s) in Upgrade Control File are ignored,\n\telement of type " + string + " contains unexpected attribute(s)." + "\n\tUnexpected and ignored attribute(s): " + StringUtils.toString(stringArray) + "\n\tLocation: " + LocatorProxy.getLocatorInfo(locator)));
        }
    }

    private void debugUnexpectedElement(UnexpectedElementReason unexpectedElementReason, String string, String string2, Locator locator) {
        String string3 = "Element in Upgrade control file is ignored,\n\telement of type " + string;
        if (unexpectedElementReason.equals(UnexpectedElementReason.SubElementNotAllowed)) {
            string3 = string3 + " contains sub element of not expected type " + string2 + "." + "\n\tThis sub element and its contents are ignored.";
        } else if (unexpectedElementReason.equals(UnexpectedElementReason.MoreElementsThanExpected)) {
            string3 = string3 + " contains more sub elements of type " + string2 + " than expected." + "\n\tThese sub elements and their contents are ignored.";
        }
        if (UpgradeTrace.valid((Class)ParsedData.class, (int)25)) {
            UpgradeTrace.debug((Class)ParsedData.class, (int)25, (String)"debugUnexpectedElement(UnexpectedElementReason anUnexpectedElementReason, String anElementName, String aSubElementName, Locator aDocumentLocator)", (String)(string3 + "\n\tLocation: " + LocatorProxy.getLocatorInfo(locator)));
        }
    }

    protected void errorIllegalAttributeValue(Class clazz, String string, String string2, String string3, String string4, String string5, String string6, Locator locator) throws IllegalAttributeValueException {
        String string7 = "Upgrade control file error,illegal attribute value " + string4 + " found in element of type " + string3 + " in parent element of type  " + string2 + ".";
        UpgradeTrace.info((Class)clazz, (String)string, (String)(string7 + string6 + LocatorProxy.getLocatorInfo(locator)));
        throw new IllegalAttributeValueException(string7, string6, locator);
    }
}

