/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom.repertoire;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.Locator;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.parser.ParseException;
import se.ericsson.cello.sudom.parser.UnexpectedAttributeException;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectInterface;
import se.ericsson.cello.sudom.parser.dom.ParsedData;
import se.ericsson.cello.sudom.parser.dom.repertoire.PiuTypeLoadList;
import se.ericsson.cello.sudom.parser.dom.repertoire.RepertoireAttributeName;
import se.ericsson.cello.sudom.parser.dom.repertoire.RepertoireSubElementName;
import se.ericsson.cello.sudom.parser.dom.repertoire.RepertoireValidator;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;

public class Repertoire
extends ParsedData
implements DocumentObjectInterface {
    private String myName = null;
    private String myInformation = null;
    private Vector myPiuTypeLoadLists = new Vector(1);

    public Repertoire(AttributeList attributeList, Locator locator) throws UnexpectedAttributeException {
        super(locator);
        String[] stringArray;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"Repertoire(AttributeList anAttributeList, Locator aLocator)", (String)("anAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if ((stringArray = RepertoireAttributeName.verifyNames(attributeList)) == null || stringArray.length > 0) {
            super.handleUnexpectedAttribute("Repertoire(AttributeList anAttributeList, Locator aLocator)", "Repertoire", stringArray, locator);
        }
        this.myName = attributeList.getValue(RepertoireAttributeName.Name.getValue());
        this.myInformation = attributeList.getValue(RepertoireAttributeName.Information.getValue());
    }

    public DocumentObjectInterface create(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"create(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if (string.equals(RepertoireSubElementName.PiuTypeLoadList.getValue())) {
            return this.createPiuTypeLoadList(attributeList, locator);
        }
        return super.handleUnexpectedElement("create(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", "Repertoire", string, locator);
    }

    public void print(PrintStream printStream, String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"print(PrintStream aPrintStream, String anIndentation)", (String)("aPrintStream: " + printStream + "\n\tanIndentation: " + string));
        }
        printStream.println(string + "<" + "Repertoire");
        if (this.myName != null) {
            printStream.println(string + "  " + RepertoireAttributeName.Name.getValue() + " = \"" + this.myName + "\"");
        }
        if (this.myInformation != null) {
            printStream.println(string + "  " + RepertoireAttributeName.Information.getValue() + " = \"" + this.myInformation + "\"");
        }
        printStream.println(string + "  " + ">");
        Enumeration enumeration = this.myPiuTypeLoadLists.elements();
        while (enumeration.hasMoreElements()) {
            ((PiuTypeLoadList)enumeration.nextElement()).print(printStream, string + "  ");
        }
        printStream.println(string + "</" + "Repertoire" + ">");
    }

    public void validate() throws ValidateException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validate( )");
        }
        RepertoireAttributeName.Name.validate(this.myName, super.getLocatorData());
        RepertoireAttributeName.Information.validate(this.myInformation, super.getLocatorData());
        RepertoireSubElementName.PiuTypeLoadList.validate(this.myPiuTypeLoadLists, super.getLocatorData());
        Enumeration enumeration = this.myPiuTypeLoadLists.elements();
        while (enumeration.hasMoreElements()) {
            ((PiuTypeLoadList)enumeration.nextElement()).validate();
        }
        RepertoireValidator.validate(this, super.getLocatorData());
    }

    public String getName() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getName( )");
        }
        return this.myName;
    }

    public String getInformation() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getInformation( )");
        }
        return this.myInformation;
    }

    public Vector getPiuTypeLoadLists() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getPiuTypeLoadLists( )");
        }
        return this.myPiuTypeLoadLists;
    }

    public void setName(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setName(String aName)", (String)("aName: " + string));
        }
        this.myName = string;
    }

    public void setInformation(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setInformation(String anInformation)", (String)("anInformation: " + string));
        }
        this.myInformation = string;
    }

    public void setPiuTypeLoadLists(Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setPiuTypeLoadLists(Vector aPiuTypeLoadLists)", (String)("aPiuTypeLoadLists: " + vector));
        }
        this.myPiuTypeLoadLists = vector;
    }

    private PiuTypeLoadList createPiuTypeLoadList(AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createPiuTypeLoadList(AttributeList anAttributeList, Locator aLocator)", (String)("anAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        this.myPiuTypeLoadLists.addElement(new PiuTypeLoadList(attributeList, locator));
        return (PiuTypeLoadList)this.myPiuTypeLoadLists.lastElement();
    }
}

