/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.proxy.repertoire;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.parser.dom.repertoire.LoadModuleRef;
import se.ericsson.cello.sudom.parser.dom.repertoire.PiuTypeLoadList;
import se.ericsson.cello.sudom.parser.dom.repertoire.PiuTypeRef;
import se.ericsson.cello.sudom.parser.dom.repertoire.Repertoire;
import se.ericsson.cello.sudom.proxy.repertoire.RepertoireProxyInterface;
import se.ericsson.cello.swmanagement.suaccess.RepertoireMoSU_Access;

public class RepertoireProxy
implements RepertoireProxyInterface {
    private Repertoire myRepertoire = null;

    public RepertoireProxy(Repertoire repertoire) {
        this.myRepertoire = repertoire;
    }

    public Repertoire getRepertoire() {
        return this.myRepertoire;
    }

    public boolean isJavaHeapSizeSpecifiedInAnyPiuTypeRef() {
        if (UpgradeTrace.valid(this.getClass(), (int)29)) {
            UpgradeTrace.debug(this.getClass(), (int)29, (String)"isJavaHeapSizeSpecifiedInAnyPiuTypeRef()");
        }
        Iterator iterator = this.getAllPiuTypeRefInformations().iterator();
        PiuTypeRef piuTypeRef = null;
        while (iterator.hasNext()) {
            piuTypeRef = (PiuTypeRef)iterator.next();
            if (piuTypeRef.getJavaHeapSize() == null) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfPiuTypeLoadLists(RepertoireMoSU_Access repertoireMoSU_Access) {
        if (UpgradeTrace.valid(this.getClass(), (int)29)) {
            UpgradeTrace.debug(this.getClass(), (int)29, (String)("getNumberOfPiuTypeLoadLists() - Name: " + this.myRepertoire.getName() + " Size: " + this.myRepertoire.getPiuTypeLoadLists().size()));
        }
        return this.myRepertoire.getPiuTypeLoadLists().size();
    }

    public Collection getPiuTypeRefInformations(String string, String string2) {
        if (UpgradeTrace.valid(this.getClass(), (int)29)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getJavaHeap(String aProductNumber, String aRevision)", (String)("aProductNumber: " + string + "\n\taRevision: " + string2));
        }
        LinkedList<PiuTypeRef> linkedList = new LinkedList<PiuTypeRef>();
        Iterator iterator = this.myRepertoire.getPiuTypeLoadLists().iterator();
        PiuTypeLoadList piuTypeLoadList = null;
        Iterator iterator2 = null;
        PiuTypeRef piuTypeRef = null;
        while (iterator.hasNext()) {
            piuTypeLoadList = (PiuTypeLoadList)iterator.next();
            iterator2 = piuTypeLoadList.getPiuTypeRefs().iterator();
            while (iterator2.hasNext()) {
                piuTypeRef = (PiuTypeRef)iterator2.next();
                if (!piuTypeRef.getProductNumber().equals(string) || !piuTypeRef.getRevision().equals(string2)) continue;
                linkedList.add(piuTypeRef);
            }
        }
        if (UpgradeTrace.valid(this.getClass(), (int)29)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getJavaHeap(String aProductNumber, String aRevision)", (String)("RETURNS - thePiuTypeRefInfromations: " + linkedList));
        }
        return linkedList;
    }

    public Collection getAllUniquePiuTypeRefs(RepertoireMoSU_Access repertoireMoSU_Access) {
        if (UpgradeTrace.valid(this.getClass(), (int)29)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getAllUniquePiuTypeRefs() - Name: " + this.myRepertoire.getName()));
        }
        Iterator iterator = this.myRepertoire.getPiuTypeLoadLists().iterator();
        PiuTypeLoadList piuTypeLoadList = null;
        Iterator iterator2 = null;
        PiuTypeRef piuTypeRef = null;
        HashMap<String, PiuTypeRef> hashMap = new HashMap<String, PiuTypeRef>();
        while (iterator.hasNext()) {
            piuTypeLoadList = (PiuTypeLoadList)iterator.next();
            iterator2 = piuTypeLoadList.getPiuTypeRefs().iterator();
            while (iterator2.hasNext()) {
                piuTypeRef = (PiuTypeRef)iterator2.next();
                hashMap.put(piuTypeRef.getProductNumber() + "_" + piuTypeRef.getRevision(), piuTypeRef);
            }
        }
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getAllUniquePiuTypeRefs()", (String)("RETURNS - thePiuTypeRefsMap.values(): " + hashMap.values() + "theKeys(): " + hashMap.keySet()));
        }
        return hashMap.values();
    }

    public String getInformation(RepertoireMoSU_Access repertoireMoSU_Access) {
        if (UpgradeTrace.valid(this.getClass(), (int)29)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getInformation() - Information: " + this.myRepertoire.getInformation()));
        }
        return this.myRepertoire.getInformation();
    }

    public String getName(RepertoireMoSU_Access repertoireMoSU_Access) {
        if (UpgradeTrace.valid(this.getClass(), (int)29)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getName() - Name: " + this.myRepertoire.getName()));
        }
        return this.myRepertoire.getName();
    }

    public Collection getAllLoadModuleRefInformations() {
        return this.getAllLoadModuleRefInformations(null);
    }

    public Collection getAllLoadModuleRefInformations(RepertoireMoSU_Access repertoireMoSU_Access) {
        if (UpgradeTrace.valid(this.getClass(), (int)29)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getAllLoadModuleRefInformations() - Repertoire name: " + this.myRepertoire.getName()));
        }
        Iterator iterator = this.myRepertoire.getPiuTypeLoadLists().iterator();
        PiuTypeLoadList piuTypeLoadList = null;
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            piuTypeLoadList = (PiuTypeLoadList)iterator.next();
            hashSet.addAll(piuTypeLoadList.getLoadModuleRefs());
        }
        return hashSet;
    }

    public Collection getAllPiuTypeRefInformations() {
        if (UpgradeTrace.valid(this.getClass(), (int)29)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getAllPiuTypeRefInformations()");
        }
        Iterator iterator = this.myRepertoire.getPiuTypeLoadLists().iterator();
        PiuTypeLoadList piuTypeLoadList = null;
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            piuTypeLoadList = (PiuTypeLoadList)iterator.next();
            hashSet.addAll(piuTypeLoadList.getPiuTypeRefs());
        }
        return hashSet;
    }

    public Collection getLoadModuleRefInformations(RepertoireMoSU_Access repertoireMoSU_Access, String string, String string2) {
        if (UpgradeTrace.valid(this.getClass(), (int)29)) {
            UpgradeTrace.debug(this.getClass(), (int)29, (String)("getLoadModuleRefInformations(String aPiuTypeProductNumber, String aPiuTypeRevision) - Repertoire name: " + this.myRepertoire.getName()), (String)("aPiuTypeProductNumber: " + string + "\n\taPiuTypeRevision: " + string2));
        }
        return this.getLoadModuleRefInformations(repertoireMoSU_Access, string, string2, false);
    }

    public Collection getLoadModuleRefInformations(RepertoireMoSU_Access repertoireMoSU_Access, String string, String string2, boolean bl) {
        if (UpgradeTrace.valid(this.getClass(), (int)29)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getLoadModuleRefInformations(String aPiuTypeProductNumber, String aPiuTypeRevision, boolean aReturnNullIfRequestedPiuTypeNotFound) - Repertoire name: " + this.myRepertoire.getName()), (String)("aPiuTypeProductNumber: " + string + "\n\taPiuTypeRevision: " + string2 + "\n\taReturnNullIfRequestedPiuTypeNotFound: " + bl));
        }
        Iterator iterator = this.myRepertoire.getPiuTypeLoadLists().iterator();
        PiuTypeLoadList piuTypeLoadList = null;
        Iterator iterator2 = null;
        PiuTypeRef piuTypeRef = null;
        boolean bl2 = false;
        HashSet hashSet = new HashSet();
        block0: while (iterator.hasNext()) {
            piuTypeLoadList = (PiuTypeLoadList)iterator.next();
            iterator2 = piuTypeLoadList.getPiuTypeRefs().iterator();
            while (iterator2.hasNext()) {
                piuTypeRef = (PiuTypeRef)iterator2.next();
                if (!piuTypeRef.equals(string, string2)) continue;
                bl2 = true;
                hashSet.addAll(piuTypeLoadList.getLoadModuleRefs());
                continue block0;
            }
        }
        if (bl && !bl2) {
            return null;
        }
        return hashSet;
    }

    public Collection getLoadModuleRefInformations(RepertoireMoSU_Access repertoireMoSU_Access, String string, String string2, Collection collection) {
        if (UpgradeTrace.valid(this.getClass(), (int)29)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)("getLoadModuleRefInformations(String aPiuTypeProductNumber, String aPiuTypeRevision, Collection aTags) - Repertoire name: " + this.myRepertoire.getName()), (String)("aPiuTypeProductNumber: " + string + "\n\taPiuTypeRevision: " + string2 + "\n\taTags: " + collection));
        }
        Iterator iterator = this.myRepertoire.getPiuTypeLoadLists().iterator();
        PiuTypeLoadList piuTypeLoadList = null;
        Iterator iterator2 = null;
        Iterator iterator3 = null;
        PiuTypeRef piuTypeRef = null;
        LoadModuleRef loadModuleRef = null;
        HashSet<LoadModuleRef> hashSet = new HashSet<LoadModuleRef>();
        block0: while (iterator.hasNext()) {
            piuTypeLoadList = (PiuTypeLoadList)iterator.next();
            iterator2 = piuTypeLoadList.getPiuTypeRefs().iterator();
            while (iterator2.hasNext()) {
                piuTypeRef = (PiuTypeRef)iterator2.next();
                if (!piuTypeRef.equals(string, string2)) continue;
                iterator3 = piuTypeLoadList.getLoadModuleRefs().iterator();
                while (iterator3.hasNext()) {
                    loadModuleRef = (LoadModuleRef)iterator3.next();
                    if (!collection.contains(loadModuleRef.getTagAsString())) continue;
                    hashSet.add(loadModuleRef);
                }
                continue block0;
            }
        }
        return hashSet;
    }
}

