/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.create;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import se.ericsson.cello.configurationversion.base.IllegalInputDataException;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.constants.SystemUpgradeConstantsInterface;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.ActualTypeOfUP;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.TypeOfUCF;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.ChecksumFileResultInterface;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.InstallFileResultInformation;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.OsaSwInstallProxyAccess;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageUtil;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.ValidSequencesInformation;
import se.ericsson.cello.sudom.parser.UpgradeControlFileNotFoundException;
import se.ericsson.cello.sudom.parser.UpgradeControlFileParserFactory;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.exceptions.UCF_ValidationException;
import se.ericsson.cello.sudom.proxy.exceptions.UpgradeControlFileParserException;
import se.ericsson.cello.sudom.proxy.interfaces.ProductDataProxyInterface;
import se.ericsson.cello.sudom.util.datacontainer.ProductDataContainer;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.create.BaseUP_Data;
import se.ericsson.cello.upgradepackage.create.CreateException;
import se.ericsson.cello.upgradepackage.create.UpgradePackageCreateAttributeData;
import se.ericsson.cello.upgradepackage.create.UpgradePackageInitialCreator;
import se.ericsson.cello.upgradepackage.main.UpgradePackageMoImpl;
import se.ericsson.cello.upgradepackage.main.exception.FtpServerNotAccessibleException;
import se.ericsson.cello.upgradepackage.main.exception.GetFileException;
import se.ericsson.cello.upgradepackage.main.exception.InsufficientDiskspaceException;
import se.ericsson.cello.upgradepackage.main.exception.IpAddressException;
import se.ericsson.cello.upgradepackage.main.exception.ProductNumberAndRevisionAlreadyInUseException;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.parser.UpgradePackageSAXdh;
import se.ericsson.cello.upgradepackage.util.datacontainer.BasedOnUpgradePackagesContainer;
import se.ericsson.cello.upgradepackage.util.enumer.RequestedTypeOfUP;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.ConfigurationVersionMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.proxyhandler.swinstall.OsaSwInstallProxyHandlerException;
import se.ericsson.cello.upgradepackage.util.proxyhandler.swinstall.OsaSwInstallProxyHandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;
import se.ericsson.cello.upgradepackage.verify.ChecksumHandler;

public class UpgradePackageCreator {
    private static final String EMPTY_STRING = "";
    public static final String ORIGINAL = "Original";
    private static final int SEND_EVENTS_NOT_DEFINED = 0;
    private static final int SEND_EVENTS_ON = 1;
    private static final int SEND_EVENTS_OFF = 2;
    private static final String VIRTUAL_ = "Virtual_";
    private static final String OF = "of";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "create(ManagedObject aParent, AttrList anAttributeList, String anIdentifier, ManagedObject aSource, Coordinator aCoordinator)", "aParent: " + managedObject + "\n\tanAttributeList: " + attrList + "\n\tanIdentifier: " + string + "\n\taSource: " + managedObject2 + "\n\taCoordinator: " + SuLib.toString(coordinator));
        }
        UpgradePackageInitialCreator upgradePackageInitialCreator = new UpgradePackageInitialCreator();
        upgradePackageInitialCreator.createInitUP(coordinator);
        ProductDataContainer productDataContainer = null;
        try {
            try {
                Object object;
                Object object2;
                DocumentObjectProxyInterface documentObjectProxyInterface;
                UpgradePackageCreateAttributeData upgradePackageCreateAttributeData = UpgradePackageCreator.verifyAndGetAttributes(attrList);
                if (!UpgradePackageCreator.isRDN_Allowed(string)) {
                    String string2 = " Virtual_x_of... or OBSOLETE_LM_UP ";
                    Trace.log1(UpgradePackageCreator.class, "create(ManagedObject aParent, AttrList anAttributeList, String anIdentifier, ManagedObject aSource, Coordinator aCoordinator)", "The given RDN value is not allowed i.e. creation of Upgrade Package MOs must not start with" + string2 + "since these names are reserved by the System Upgrade function itself");
                    throw new CreateException("The given RDN value is not allowed i.e. creation of Upgrade Package MOs must not start with" + string2 + "since these names are reserved by the System Upgrade function itself");
                }
                SystemUpgradeConstantsInterface systemUpgradeConstantsInterface = (SystemUpgradeConstantsInterface)ServiceLocatorFacade.getRepository().getService(SystemUpgradeConstantsInterface.class);
                String string3 = systemUpgradeConstantsInterface.getNodeUpRootPath();
                String string4 = systemUpgradeConstantsInterface.getNodeDefaultUCF_Path();
                File file = UpgradePackageCreator.getUpgradeControlFileFromFTP_Server(string4, upgradePackageCreateAttributeData);
                if (Trace.valid(UpgradePackageCreator.class, 22)) {
                    Trace.debug(UpgradePackageCreator.class, 22, "create(ManagedObject aParent, AttrList anAttributeList, String anIdentifier, ManagedObject aSource, Coordinator aCoordinator)", "Parsing of element Productdata of UP itself in the UCF is started.");
                }
                if (!UpgradePackageCreator.isProductNumberAllowed((productDataContainer = (documentObjectProxyInterface = UpgradePackageCreator.validateUCF(file)).getProductDataProxyInterface().getProductDataRaw()).getNumber())) {
                    String string5 = " OBSOLETE_LM_UP ";
                    Trace.log1(UpgradePackageCreator.class, "create(ManagedObject aParent, AttrList anAttributeList, String anIdentifier, ManagedObject aSource, Coordinator aCoordinator)", "The given ProductNumber value in UCF is not allowed i.e. productNumber must not start with" + string5 + "since this number is reserved by the System Upgrade function itself");
                    throw new CreateException("The given ProductNumber value in UCF is not allowed i.e. productNumber must not start with" + string5 + "since this number is reserved by the System Upgrade function itself");
                }
                if (Trace.valid(UpgradePackageCreator.class, 22)) {
                    Trace.debug(UpgradePackageCreator.class, 22, "create(ManagedObject aParent, AttrList anAttributeList, String anIdentifier, ManagedObject aSource, Coordinator aCoordinator)", "Parts of the UCF has been parsed.");
                }
                String string6 = UpgradePackageCreator.getUpgradePackageMO_Id(string, productDataContainer);
                UpgradePackageCreator.verifyThatUpgradePackageMO_DoNotExist(string6, productDataContainer, coordinator);
                ProductDataContainer productDataContainer2 = new ProductDataContainer(EMPTY_STRING, EMPTY_STRING, EMPTY_STRING, EMPTY_STRING, EMPTY_STRING, EMPTY_STRING);
                String string7 = EMPTY_STRING;
                File file2 = new File(UpgradePackageCreator.getUpgradeControlFilePath(string3, productDataContainer.getNumber(), productDataContainer.getRevision()));
                File file3 = new File(UpgradePackageCreator.getUpgradeControlFilePath(string3, productDataContainer.getNumber(), productDataContainer.getRevision()) + UpgradePackageCreator.getUpgradeControlFileName(productDataContainer.getNumber(), productDataContainer.getRevision()));
                String string8 = file3.getAbsolutePath() + ORIGINAL;
                BaseUP_Data baseUP_Data = new BaseUP_Data(EMPTY_STRING, EMPTY_STRING, EMPTY_STRING, EMPTY_STRING);
                BasedOnUpgradePackagesContainer basedOnUpgradePackagesContainer = new BasedOnUpgradePackagesContainer();
                ValidSequencesInformation validSequencesInformation = new ValidSequencesInformation();
                boolean bl = false;
                if (upgradePackageCreateAttributeData.sendEvents == 0) {
                    object2 = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
                    object = object2.getCurrentUpgradePackage(null);
                    if (object != null && object instanceof UpgradePackageMoExtended) {
                        bl = object.getSendEvents(null);
                    }
                } else if (upgradePackageCreateAttributeData.sendEvents == 1) {
                    bl = true;
                }
                object2 = RequestedTypeOfUP.Undefined;
                object = "Undefined";
                file2.mkdirs();
                SuLib.copyUCF(file, file3);
                file.delete();
                SuLib.copyUCF(file3, new File(string8));
                ChecksumHandler checksumHandler = new ChecksumHandler();
                ChecksumFileResultInterface checksumFileResultInterface = checksumHandler.checksumUCF(string8);
                ChecksumFileResultInterface checksumFileResultInterface2 = checksumHandler.checksumUCF(file3.getAbsolutePath());
                UpgradePackageMoImpl upgradePackageMoImpl = new UpgradePackageMoImpl(managedObject, string6, file3, productDataContainer, upgradePackageCreateAttributeData, baseUP_Data, string8, false, (String)object, productDataContainer2, string7, basedOnUpgradePackagesContainer, validSequencesInformation, bl, (RequestedTypeOfUP)object2, checksumFileResultInterface.getChecksum(), checksumFileResultInterface2.getChecksum(), coordinator);
                if (Trace.valid(UpgradePackageCreator.class, 22)) {
                    Trace.debug(UpgradePackageCreator.class, 22, "create(ManagedObject aParent, AttrList anAttributeList, String anIdentifier, ManagedObject aSource, Coordinator aCoordinator)", "Upgrade Package MO created.\n\tUpgradePackageId: " + string6 + "\n\tProduct Number: " + productDataContainer.getNumber() + "\n\tProduct Revision: " + productDataContainer.getRevision() + "\n");
                }
                if (upgradePackageCreateAttributeData.isOneClickUpgrade) {
                    UpgradeDB_StorageUtil.saveOneClickUpgrade(upgradePackageMoImpl.getDocumentNumberOpt(), upgradePackageMoImpl.getDocumentRevisionOpt());
                }
                UpgradePackageMoImpl upgradePackageMoImpl2 = upgradePackageMoImpl;
                Object var31_47 = null;
                if (productDataContainer == null) return upgradePackageMoImpl2;
                UpgradeControlFileParserFactory.instance().removeDocumentObjectForUpgradePackage(productDataContainer.getNumber(), productDataContainer.getRevision());
                return upgradePackageMoImpl2;
            }
            catch (FtpServerNotAccessibleException ftpServerNotAccessibleException) {
                throw new CreateException(ftpServerNotAccessibleException.toString());
            }
            catch (GetFileException getFileException) {
                throw new CreateException(getFileException.toString());
            }
            catch (IpAddressException ipAddressException) {
                throw new CreateException(ipAddressException.toString());
            }
            catch (InsufficientDiskspaceException insufficientDiskspaceException) {
                throw new CreateException(insufficientDiskspaceException.toString());
            }
            catch (FroRequestFailedException froRequestFailedException) {
                throw new CreateException(froRequestFailedException.toString());
            }
            catch (MoNameAlreadyTakenException moNameAlreadyTakenException) {
                throw new CreateException(moNameAlreadyTakenException.toString());
            }
            catch (ProductNumberAndRevisionAlreadyInUseException productNumberAndRevisionAlreadyInUseException) {
                throw new CreateException(productNumberAndRevisionAlreadyInUseException.toString());
            }
            catch (AttrMissingAtCreateException attrMissingAtCreateException) {
                throw new CreateException(attrMissingAtCreateException.toString());
            }
            catch (WrongAttributeTypeException wrongAttributeTypeException) {
                throw new CreateException(wrongAttributeTypeException.toString());
            }
            catch (IllegalInputDataException illegalInputDataException) {
                throw new CreateException(illegalInputDataException.toString());
            }
            catch (NoSuchAttributeException noSuchAttributeException) {
                throw new CreateException(noSuchAttributeException.toString());
            }
            catch (ValueOutOfRangeException valueOutOfRangeException) {
                throw new CreateException(valueOutOfRangeException.toString());
            }
            catch (CreateException createException) {
                throw createException;
            }
            catch (UpgradeControlFileParserException upgradeControlFileParserException) {
                throw new CreateException(upgradeControlFileParserException.toString());
            }
            catch (Throwable throwable) {
                Trace.error(UpgradePackageCreator.class, "create(ManagedObject aParent, AttrList anAttributeList, String anIdentifier, ManagedObject aSource, Coordinator aCoordinator)", "Throwable caught: " + throwable, throwable);
                throw new CreateException(throwable.toString());
            }
        }
        catch (Throwable throwable) {
            Object var31_48 = null;
            if (productDataContainer == null) throw throwable;
            UpgradeControlFileParserFactory.instance().removeDocumentObjectForUpgradePackage(productDataContainer.getNumber(), productDataContainer.getRevision());
            throw throwable;
        }
    }

    private static boolean isRDN_Allowed(String string) {
        if (string.startsWith(VIRTUAL_)) {
            String string2 = string.substring(VIRTUAL_.length(), string.length());
            int n = string2.indexOf("_");
            if (n == -1) {
                return true;
            }
            String string3 = string2.substring(0, n);
            try {
                new Integer(string3);
                return false;
            }
            catch (Throwable throwable) {
                return true;
            }
        }
        return !string.startsWith("OBSOLETE_LM_UP");
    }

    private static boolean isProductNumberAllowed(String string) {
        String string2;
        boolean bl = true;
        String string3 = string.toLowerCase();
        if (string3.startsWith(string2 = "OBSOLETE_LM_UP".toLowerCase())) {
            bl = false;
        }
        return bl;
    }

    private static void areThereMoreUnexpectedAttributes(AttrList attrList) throws NoSuchAttributeException {
        int n;
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "areThereMoreUnexpectedAttributes(AttrList anAttributeList)", "anAttributeList: " + attrList);
        }
        if ((n = attrList.size()) != 0) {
            Trace.info(UpgradePackageCreator.class, "areThereMoreUnexpectedAttributes ( AttrList anAttributeList )", "Unexpected attribute " + attrList.getName(0) + " found in attribute list.");
            throw new NoSuchAttributeException(attrList.getName(0), "UpgradePackage");
        }
    }

    private static String checkAndGetFTP_ServerIP_Address(String string) throws IpAddressException {
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "checkAndGetFTP_ServerIP_Address(String anFTP_ServerHostNameOrIP_Address)", "anFTP_ServerHostNameOrIP_Address: " + string);
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            if (Trace.valid(UpgradePackageCreator.class, 40)) {
                Trace.debug(UpgradePackageCreator.class, 40, "checkAndGetFTP_ServerIP_Address(String anFTP_ServerHostNameOrIP_Address)", "UnknownHostException caught when converting/checking FTP server host name/IP address,\n\tanFTP_ServerHostNameOrIP_Address: " + string + "\n\tUnknownHostException info: " + unknownHostException.toString());
            }
            throw new IpAddressException("Verification of requested host name/IP address failed,\n\trequested host name/IP address: " + string + "\n\tUnknownHostException info: " + unknownHostException.toString());
        }
    }

    public static RequestedTypeOfUP defineRequestedTypeOfUP(TypeOfUCF typeOfUCF) throws MoAccessException {
        ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface;
        UpgradePackageMoExtended upgradePackageMoExtended;
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "defineRequestedTypeOfUP(TypeOfUCF anUCF_Type)", "\n\tTypeOfUCF: " + typeOfUCF);
        }
        RequestedTypeOfUP requestedTypeOfUP = RequestedTypeOfUP.getInstance(typeOfUCF.getValue());
        if (typeOfUCF.isDelta() && (upgradePackageMoExtended = (configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface()).getCurrentUpgradePackage(null)) != null) {
            int n = upgradePackageMoExtended.getActualTypeOfUP(null);
            ActualTypeOfUP actualTypeOfUP = ActualTypeOfUP.getInstance(n);
            if (Trace.valid(UpgradePackageCreator.class, 20)) {
                Trace.debug(UpgradePackageCreator.class, 20, "defineRequestedTypeOfUP(TypeOfUCF anUCF_Type)", "\n\ttheType: " + n + "\n\ttheActualTypeOfUP: " + actualTypeOfUP);
            }
            if (actualTypeOfUP.isAdapted()) {
                requestedTypeOfUP = RequestedTypeOfUP.DeltaAdapted;
            } else if (actualTypeOfUP.isHW_Sensitive()) {
                requestedTypeOfUP = RequestedTypeOfUP.DeltaHW_Sensitive;
            } else if (actualTypeOfUP.isSelective()) {
                requestedTypeOfUP = RequestedTypeOfUP.DeltaSelective;
            } else {
                Trace.warning(UpgradePackageCreator.class, "defineRequestedTypeOfUP", "Received ActualTypeOfUP might be wrong,\n\treceived theActualTypeOfUP: " + actualTypeOfUP + "\n\treceived type: " + n + "\n\treturning RequestedTypeOfUP Adapted. ");
                requestedTypeOfUP = RequestedTypeOfUP.Adapted;
            }
        }
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "defineRequestedTypeOfUP(TypeOfUCF anUCF_Type)", "\n\taTypeOfUCF: " + typeOfUCF + "\n\tReturning theRequestedTypeOfUP: " + requestedTypeOfUP);
        }
        return requestedTypeOfUP;
    }

    private static File getUpgradeControlFileFromFTP_Server(String string, UpgradePackageCreateAttributeData upgradePackageCreateAttributeData) throws MoAccessException {
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "getUpgradeControlFileFromFTP_Server(String aTemporaryUCF_Path, UpgradePackageCreateAttributeData anUpgradePackageCreateAttributeData)", "aTemporaryUCF_Path: " + string + "\n\tanUpgradePackageCreateAttributeData: " + upgradePackageCreateAttributeData);
        }
        return UpgradePackageCreator.getUpgradeControlFileFromFTP_Server(string, upgradePackageCreateAttributeData.ucfPathOnFtpServer, upgradePackageCreateAttributeData.ftpServerIP_Address, upgradePackageCreateAttributeData.userIdentifier, upgradePackageCreateAttributeData.userPassword);
    }

    public static File getUpgradeControlFileFromFTP_Server(String string, String string2, String string3, String string4, String string5) throws FtpServerNotAccessibleException, FroNotAccessibleException, GetFileException, IpAddressException, FroRequestFailedException, InsufficientDiskspaceException {
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "getUpgradeControlFileFromFTP_Server(String aTemporaryUCF_Path, String anUcfPathOnFtpServer, String aFtpServerIP_Address, String anUserIdentifier,  String anUserPassword)", "aTemporaryUCF_Path: " + string + "\n\tanUcfPathOnFtpServer: " + string2 + "\n\taFtpServerIP_Address: " + string3 + "\n\tanUserIdentifier: " + string4 + "\n\tUser password: ****");
        }
        String string6 = UpgradePackageCreator.checkAndGetFTP_ServerIP_Address(string3);
        UpgradePackageCreator.verifyAndGetFTP_ServerUserID_MaxLength(string4);
        OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
        if (Trace.valid(UpgradePackageCreator.class, 22)) {
            Trace.debug(UpgradePackageCreator.class, 22, "getUpgradeControlFileFromFTP_Server(String aTemporaryUCF_Path, String anUcfPathOnFtpServer, String aFtpServerIP_Address, String anUserIdentifier,  String anUserPassword)", "Sending signal 'OsaSwInstallFileReq3'.");
        }
        InstallFileResultInformation installFileResultInformation = osaSwInstallProxyAccess.sendOsaSwInstallFileReq3(string4, string5, string6, string2, string);
        if (installFileResultInformation.result == 1) {
            if (Trace.valid(UpgradePackageCreator.class, 22)) {
                Trace.debug(UpgradePackageCreator.class, 22, "getUpgradeControlFileFromFTP_Server(String aTemporaryUCF_Path, String anUcfPathOnFtpServer, String aFtpServerIP_Address, String anUserIdentifier,  String anUserPassword)", "Response 'OK' received from fro");
            }
            return new File(string);
        }
        if (installFileResultInformation.result == 3) {
            Trace.info(UpgradePackageCreator.class, "getUpgradeControlFileFromFTP_Server(String aTemporaryUCF_Path, String anUcfPathOnFtpServer, String aFtpServerIP_Address, String anUserIdentifier,  String anUserPassword)", "Download of the upgrade control file from the FTP server failed due to invalid user ID, password or IP address for FTP server.\n\tUser identifier: " + string4 + "\n\tUser password: ****" + "\n\tReceived host name or IP address of FTP Server: " + string6 + "\n\tThe Upgrade Control File path on the FTP Server: " + string2 + "\n\tThe creation of the Upgrade Package MO is aborted.");
            throw new FtpServerNotAccessibleException("Invalid user ID, password or IP address for FTP server");
        }
        if (installFileResultInformation.result == 4) {
            Trace.info(UpgradePackageCreator.class, "getUpgradeControlFileFromFTP_Server(String aTemporaryUCF_Path, String anUcfPathOnFtpServer, String aFtpServerIP_Address, String anUserIdentifier,  String anUserPassword)", "Download of the upgrade control file from the FTP server failed due to the upgrade package control file is not found on FTP server.\n\tUser identifier: " + string4 + "\n\tUser password: ****" + "\n\tReceived host name or IP address of FTP Server: " + string6 + "\n\tThe Upgrade Control File path on the FTP Server: " + string2 + "\n\tThe creation of the Upgrade Package MO is aborted.");
            throw new GetFileException("Upgrade package control file not found on FTP server. OR " + installFileResultInformation.errorInformation);
        }
        if (installFileResultInformation.result == 5) {
            Trace.info(UpgradePackageCreator.class, "getUpgradeControlFileFromFTP_Server(String aTemporaryUCF_Path, String anUcfPathOnFtpServer, String aFtpServerIP_Address, String anUserIdentifier,  String anUserPassword)", "Download of the upgrade control file from the FTP server failed due to invalid format in IP address of FTP server.\n\tUser identifier: " + string4 + "\n\tUser password: ****" + "\n\tReceived host name or IP address of FTP Server: " + string6 + "\n\tThe Upgrade Control File path on the FTP Server: " + string2 + "\n\tThe creation of the Upgrade Package MO is aborted.");
            throw new IpAddressException("Invalid format in IP address of FTP server");
        }
        if (installFileResultInformation.result == 8) {
            Trace.info(UpgradePackageCreator.class, "getUpgradeControlFileFromFTP_Server(String aTemporaryUCF_Path, String anUcfPathOnFtpServer, String aFtpServerIP_Address, String anUserIdentifier,  String anUserPassword)", "Download of the upgrade control file from the FTP server failed due to insufficient disk space.\n\tUser identifier: " + string4 + "\n\tUser password: ****" + "\n\tReceived host name or IP address of FTP Server: " + string6 + "\n\tThe Upgrade Control File path on the FTP Server: " + string2 + "\n\tThe creation of the Upgrade Package MO is aborted.");
            throw new InsufficientDiskspaceException("Insufficient disk space. " + installFileResultInformation.errorInformation);
        }
        Trace.error(UpgradePackageCreator.class, "getUpgradeControlFileFromFTP_Server(String aTemporaryUCF_Path, String anUcfPathOnFtpServer, String aFtpServerIP_Address, String anUserIdentifier,  String anUserPassword)", "Download of the upgrade control file from the FTP server failed for unknown reason.\n\tUser identifier: " + string4 + "\n\tUser password: ****" + "\n\tReceived host name or IP address of FTP Server: " + string6 + "\n\tThe Upgrade Control File path on the FTP Server: " + string2 + "\n\tThe theInstallFileResultInformation: " + installFileResultInformation + "\n\tThe creation of the Upgrade Package MO is aborted.");
        throw new FroRequestFailedException("UpgradePackage", "OsaSwInstallFRO", "SwInstallFileReq", installFileResultInformation.result);
    }

    private static String getUpgradeControlFileName(String string, String string2) {
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "getUpgradeControlFileName(String aProductNumber, String aProductRevision)", "aProductNumber: " + string + "\n\taProductRevision: " + string2);
        }
        return UpgradePackageSAXdh.removeSlash(UpgradePackageSAXdh.removeWhiteSpace(string + "_" + string2)) + ".xml";
    }

    public static String getUpgradeControlFilePath(String string, String string2, String string3) {
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "getUpgradeControlFilePath(String aNodeUpRootPath, String aProductNumber, String aProductRevision)", "aNodeUpRootPath: " + string + "\n\taProductNumber: " + string2 + "\n\taProductRevision: " + string3);
        }
        return string + UpgradePackageSAXdh.removeWhiteSpace(UpgradePackageSAXdh.removeSlash(string2 + "_" + string3)) + "/";
    }

    private static String getUpgradePackageMO_Id(String string, ProductDataContainer productDataContainer) throws MoNameAlreadyTakenException, CreateException {
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "getUpgradePackageMO_Id(String aNamingAttributeValue, ProductDataContainer aProductData)", "aNamingAttributeValue: " + string + "\n\taProductData: " + productDataContainer);
        }
        if (string != null && !string.equals(EMPTY_STRING)) {
            return string;
        }
        String string2 = productDataContainer.getNumber() + "_" + productDataContainer.getRevision();
        try {
            UpgradePackageMoImpl upgradePackageMoImpl = UpgradePackageCreator.lookup(string2);
            if (upgradePackageMoImpl != null && (upgradePackageMoImpl = UpgradePackageCreator.lookup(string2 = string2 + "_" + TimeHandler.createActionId().toString())) != null) {
                Trace.info(UpgradePackageCreator.class, "getUpgradePackageMO_Id(String aNamingAttributeValue, ProductDataContainer aProductData)", "Auto-creation of Upgrade Package MO identity failed,\n\tUpgrade Package MO with requested identity ( = " + string2 + " )" + " already exists." + "\nCreation of Upgrade Package MO is aborted.");
                throw new MoNameAlreadyTakenException("An upgrade package MO with the auto-created identity (naming attribute value) '" + string2 + "' already exists");
            }
            return string2;
        }
        catch (MoNameAlreadyTakenException moNameAlreadyTakenException) {
            throw moNameAlreadyTakenException;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(UpgradePackageCreator.class, "getUpgradePackageMO_Id(String aNamingAttributeValue, ProductDataContainer aProductData)", "Failed to auto-create an UpgradePackgeMO identity. MoAccessException caught with reason " + moAccessException.getMessage() + "\n\taNamingAttributeValue: " + string + "\n\taProductData: " + productDataContainer, moAccessException);
            throw new CreateException(moAccessException.toString());
        }
    }

    private static boolean isProductNumberAndRevisionKnown(String string, String string2, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "isProductNumberAndRevisionKnown(String aProductNumber, String aProductRevision, Coordinator aCoordinator)", "aProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\taCoordinator: " + coordinator);
        }
        UpgradePackageMoImpl upgradePackageMoImpl = null;
        MoIterator moIterator = MoRepository.instance().lookupType("UpgradePackage");
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                upgradePackageMoImpl = (UpgradePackageMoImpl)moIterator.nextMo();
                if (upgradePackageMoImpl == null || !StringHandler.stringsAreEqualIgnoringWhiteSpaceAndCase(string, upgradePackageMoImpl.getDocumentNumber(coordinator)) || !StringHandler.stringsAreEqualIgnoringWhiteSpaceAndCase(string2, upgradePackageMoImpl.getDocumentRevision(coordinator))) continue;
                return true;
            }
        }
        return false;
    }

    private static UpgradePackageMoImpl lookup(String string) throws MoAccessException {
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "lookup(String aNamingAttributeValue)", "aNamingAttributeValue: " + string);
        }
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("UpgradePackage");
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    UpgradePackageMoImpl upgradePackageMoImpl = (UpgradePackageMoImpl)moIterator.nextMo();
                    if (!upgradePackageMoImpl.getUpgradePackageId(null).equals(string)) continue;
                    return upgradePackageMoImpl;
                }
            }
            return null;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(UpgradePackageCreator.class, "lookup(String aNamingAttributeValue)", "Failed to lookup given naming identity in the MoIterator. MoAccessException caught with reason " + moAccessException.getMessage() + "aNamingAttributeValue: " + string, moAccessException);
            throw moAccessException;
        }
    }

    private static DocumentObjectProxyInterface validateUCF(File file) throws UpgradeControlFileNotFoundException, UpgradeControlFileParserException {
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "validateUCF(File anUpgradeControlFile)", "anUpgradeControlFile: " + SuLib.toString(file));
        }
        try {
            DocumentObjectProxyInterface documentObjectProxyInterface = UCF_ParserFacade.parseMainElement(file.getAbsolutePath(), "ProductData");
            ProductDataProxyInterface productDataProxyInterface = documentObjectProxyInterface.getProductDataProxyInterface();
            if (productDataProxyInterface == null) {
                Trace.error(UpgradePackageCreator.class, "validateUCF(File anUpgradeControlFile)", "Invalid UCF i.e the ProductData element for UP in UCF is missing.");
                throw new UpgradeControlFileParserException("Invalid UCF i.e the ProductData element for UP in UCF is missing.");
            }
            productDataProxyInterface.validate();
            return documentObjectProxyInterface;
        }
        catch (UpgradeControlFileParserException upgradeControlFileParserException) {
            throw upgradeControlFileParserException;
        }
        catch (UCF_ValidationException uCF_ValidationException) {
            throw new UpgradeControlFileParserException("The upgrade control file is probably faulty i.e. parsing of the file resulted in validation problems.\n\tanUpgradeControlFile: " + SuLib.toString(file) + "\n\tUCF_ValidationException: " + (Object)((Object)uCF_ValidationException) + "\n\tThe creation of the Upgrade Package MO is aborted.");
        }
        catch (Throwable throwable) {
            Trace.error(UpgradePackageCreator.class, "validateUCF(File anUpgradeControlFile)", "The upgrade control file is probably faulty i.e. parsing of the file resulted in error.\n\tanUpgradeControlFile: " + SuLib.toString(file) + "\n\ttheException: " + throwable + "\n\tThe creation of the Upgrade Package MO is aborted.", throwable);
            throw new UpgradeControlFileParserException("The upgrade control file is probably faulty i.e. parsing of the file resulted in error.\n\tanUpgradeControlFile: " + SuLib.toString(file) + "\n\ttheException: " + throwable + "\n\tThe creation of the Upgrade Package MO is aborted.");
        }
    }

    private static UpgradePackageCreateAttributeData verifyAndGetAttributes(AttrList attrList) throws WrongAttributeTypeException, AttrMissingAtCreateException, NoSuchAttributeException, NotHandledAttributeTypeException, MoNotFoundException, IllegalInputDataException, ValueOutOfRangeException {
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "verifyAndGetAttributes(AttrList anAttributeList)", "anAttributeList: " + SuLib.toString(attrList));
        }
        String string = UpgradePackageCreator.verifyAndGetUserLabel(attrList);
        String string2 = UpgradePackageCreator.verifyAndGetFTP_ServerIP_Address(attrList);
        String string3 = UpgradePackageCreator.verifyAndGetUCF_PathOnFTP_Server(attrList);
        String string4 = UpgradePackageCreator.verifyAndGetUserIdentifier(attrList);
        String string5 = UpgradePackageCreator.verifyAndGetUserPassword(attrList);
        int n = UpgradePackageCreator.verifyAndGetSendEvents(attrList);
        boolean bl = UpgradePackageCreator.verifyAndGetOneClickUpgrade(attrList);
        int n2 = UpgradePackageCreator.verifyAndGetMaxTimeBetweenUpgradeEvents(attrList);
        UpgradePackageCreator.areThereMoreUnexpectedAttributes(attrList);
        UpgradePackageCreateAttributeData upgradePackageCreateAttributeData = new UpgradePackageCreateAttributeData(string, string2, string3, string4, string5, n, n2, bl);
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "verifyAndGetAttributes(AttrList anAttributeList)", "RETURNS - theUpgradePackageCreateAttributeData: " + upgradePackageCreateAttributeData);
        }
        return upgradePackageCreateAttributeData;
    }

    private static String verifyAndGetFTP_ServerIP_Address(AttrList attrList) throws WrongAttributeTypeException, AttrMissingAtCreateException, NotHandledAttributeTypeException, MoNotFoundException, IllegalInputDataException {
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "verifyAndGetFTP_ServerIP_Address(AttrList anAttributeList)", "anAttributeList: " + attrList);
        }
        String string = null;
        int n = attrList.indexOf("ftpServerIpAddress");
        if (n == -1) {
            Trace.info(UpgradePackageCreator.class, "checkAndGetFtpServerIpAddess ( AttrList attributes )", "Mandatory attribute 'ftpServerIpAddess' is not included in attribute list.");
            throw new AttrMissingAtCreateException("ftpServerIpAddress", "UpgradePackage");
        }
        if (!(attrList.getValue(n) instanceof String)) {
            Trace.info(UpgradePackageCreator.class, "checkAndGetFtpServerIpAddess ( AttrList attributes )", "Attribute 'ftpServerIpAddess' shall be of the type string but is not.\n\tAttribute 'ftpServerIpAddess': " + attrList.getValue(n));
            throw new WrongAttributeTypeException("ftpServerIpAddress", "UpgradePackage");
        }
        string = (String)attrList.getValue(n);
        UpgradePackageCreator.validateLengthOfString(string, 256, "The max length of the parameter ftpServerIpAddress is 256 characters.\n\tftpServerIpAddress: " + string);
        attrList.removeElementAt(n);
        return string;
    }

    public static void validateLengthOfString(String string, int n, String string2) throws IllegalInputDataException {
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "validateLengthOfString(String aValue, int aMaxLength)", "aValue: " + string + "\n\taMaxLength: " + n);
        }
        if (string == null || string.length() > n) {
            throw new IllegalInputDataException(string2);
        }
    }

    private static int verifyAndGetFTP_ServerUserID_MaxLength(String string) throws FtpServerNotAccessibleException {
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "verifyAndGetFTP_ServerUserID_MaxLength(String aUserIdentifier)", "aUserIdentifier: " + string);
        }
        try {
            OsaSwInstallProxyHandlerInterface osaSwInstallProxyHandlerInterface = ServiceFinder.getOsaSwInstallProxyHandlerInterface();
            return osaSwInstallProxyHandlerInterface.verifyAndGetFTP_ServerUserID_MaxLength(string);
        }
        catch (OsaSwInstallProxyHandlerException osaSwInstallProxyHandlerException) {
            if (Trace.valid(UpgradePackageCreator.class, 22)) {
                Trace.debug(UpgradePackageCreator.class, 22, "verifyAndGetFTP_ServerUserID_MaxLength(String aUserIdentifier)", "OsaSwInstallProxyHandlerException caught when verifying length of requested FTP server user id,\n\taUserIdentifier: " + string + "\n\tOsaSwInstallProxyHandlerException info: " + osaSwInstallProxyHandlerException.toString());
            }
            throw new FtpServerNotAccessibleException("Verification of length of requested FTP server user id failed,\n\trequested user id: " + string + "\n\tOsaSwInstallProxyHandlerException info: " + osaSwInstallProxyHandlerException.toString());
        }
    }

    private static String verifyAndGetUCF_PathOnFTP_Server(AttrList attrList) throws WrongAttributeTypeException, AttrMissingAtCreateException, NotHandledAttributeTypeException, MoNotFoundException {
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "verifyAndGetUCF_PathOnFTP_Server(AttrList anAttributeList)", "anAttributeList: " + attrList);
        }
        String string = EMPTY_STRING;
        int n = attrList.indexOf("upFilePathOnFtpServer");
        if (n == -1) {
            Trace.info(UpgradePackageCreator.class, "verifyAndGetUCF_PathOnFTP_Server ( AttrList anAttributeList )", "Mandatory attribute 'upFilePathOnFtpServer' is not included in attribute list.");
            throw new AttrMissingAtCreateException("upFilePathOnFtpServer", "UpgradePackage");
        }
        if (!(attrList.getValue(n) instanceof String)) {
            Trace.info(UpgradePackageCreator.class, "checkAndGetUpFilePathOnFtpServer ( AttrList anAttributeList )", "Attribute 'upFilePathOnFtpServer' shall be of the type string but is not.\n\tAttribute 'upFilePathOnFtpServer': " + attrList.getValue(n));
            throw new WrongAttributeTypeException("upFilePathOnFtpServer", "UpgradePackage");
        }
        string = (String)attrList.getValue(n);
        attrList.removeElementAt(n);
        return string;
    }

    private static String verifyAndGetUserIdentifier(AttrList attrList) throws WrongAttributeTypeException, NotHandledAttributeTypeException, MoNotFoundException {
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "verifyAndGetUserIdentifier(AttrList anAttributeList)", "anAttributeList: " + attrList);
        }
        String string = "anonymous";
        int n = attrList.indexOf("user");
        if (n == -1) {
            return string;
        }
        if (!(attrList.getValue(n) instanceof String)) {
            Trace.error(UpgradePackageCreator.class, "checkAndGetUser ( AttrList anAttributeList )", "Attribute 'user' shall be of the type string but is not.\n\tAttribute 'user': " + attrList.getValue(n));
            throw new WrongAttributeTypeException("user", "UpgradePackage");
        }
        string = (String)attrList.getValue(n);
        attrList.removeElementAt(n);
        return string;
    }

    private static String verifyAndGetUserLabel(AttrList attrList) throws WrongAttributeTypeException, NotHandledAttributeTypeException, MoNotFoundException {
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "verifyAndGetUserLabel(AttrList anAttributeList)", "anAttributeList: " + attrList);
        }
        String string = EMPTY_STRING;
        int n = attrList.indexOf("userLabel");
        if (n == -1) {
            return string;
        }
        if (!(attrList.getValue(n) instanceof String)) {
            Trace.error(UpgradePackageCreator.class, "verifyAndGetUserLabel ( AttrList anAttributeList )", "Attribute 'UserLabel' shall be of the type string but is not.\n\tAttribute 'userLabel': " + attrList.getValue(n));
            throw new WrongAttributeTypeException("userLabel", "UpgradePackage");
        }
        string = (String)attrList.getValue(n);
        attrList.removeElementAt(n);
        return string;
    }

    private static int verifyAndGetSendEvents(AttrList attrList) throws WrongAttributeTypeException, MoNotFoundException, NotHandledAttributeTypeException {
        int n;
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "verifyAndGetSendEvents(AttrList anAttributeList)", "anAttributeList: " + attrList);
        }
        if ((n = attrList.indexOf("sendEvents")) == -1) {
            return 0;
        }
        if (!(attrList.getValue(n) instanceof Boolean)) {
            Trace.error(UpgradePackageCreator.class, "verifyAndGetSendEvents ( AttrList anAttributeList )", "Attribute 'sendEvents' shall be of the type Boolean but is not.\n\tAttribute 'sendEvents': " + attrList.getValue(n));
            throw new WrongAttributeTypeException("sendEvents", "UpgradePackage");
        }
        boolean bl = (Boolean)attrList.getValue(n);
        attrList.removeElementAt(n);
        if (bl) {
            return 1;
        }
        return 2;
    }

    private static boolean verifyAndGetOneClickUpgrade(AttrList attrList) throws WrongAttributeTypeException, MoNotFoundException, NotHandledAttributeTypeException {
        int n;
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "verifyAndGetOneClickUpgrade(AttrList anAttributeList)", "anAttributeList: " + attrList);
        }
        if ((n = attrList.indexOf("oneClickUpgrade")) == -1) {
            return false;
        }
        if (!(attrList.getValue(n) instanceof Boolean)) {
            Trace.error(UpgradePackageCreator.class, "verifyAndGetOneClickUpgrade ( AttrList anAttributeList )", "Attribute 'oneClickUpgrade' shall be of the type Boolean but is not.\n\tAttribute 'sendEvents': " + attrList.getValue(n));
            throw new WrongAttributeTypeException("oneClickUpgrade", "UpgradePackage");
        }
        boolean bl = (Boolean)attrList.getValue(n);
        attrList.removeElementAt(n);
        return bl;
    }

    private static int verifyAndGetMaxTimeBetweenUpgradeEvents(AttrList attrList) throws WrongAttributeTypeException, MoNotFoundException, NotHandledAttributeTypeException, ValueOutOfRangeException {
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "verifyAndGetMaxTimeBetweenUpgradeEvents(AttrList anAttributeList)", "anAttributeList: " + attrList);
        }
        int n = 1;
        int n2 = attrList.indexOf("maxTimeBetweenUpgradeEvents");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            Trace.error(UpgradePackageCreator.class, "verifyAndGetTimeBetweenUpgradeEvents ( AttrList anAttributeList )", "Attribute 'maxTimeBetweenUpgradeEvents' shall be of the type Integer but is not.\n\tAttribute 'maxTimeBetweenUpgradeEvents': " + attrList.getValue(n2));
            throw new WrongAttributeTypeException("maxTimeBetweenUpgradeEvents", "UpgradePackage");
        }
        n = (Integer)attrList.getValue(n2);
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "verifyAndGetMaxTimeBetweenUpgradeEvents(AttrList anAttributeList)", "theMaxTimeBetweenUpgradeEvents: " + n);
        }
        if (n >= 1 && n <= 60) {
            attrList.removeElementAt(n2);
            return n;
        }
        throw new ValueOutOfRangeException("Attribute 'maxTimeBetweenUpgradeEvents' Valid value range is: 1-60.\n\tAttempt to set it to value " + n + ".", "UpgradePackage");
    }

    public static void validateForIllegalCharacters(String string) throws IllegalInputDataException {
        String[] stringArray = new String[]{"\u00a4", "|", "^", "'", "=", ","};
        for (int i = 0; i < stringArray.length; ++i) {
            if (string.indexOf(stringArray[i]) == -1) continue;
            throw new IllegalInputDataException("Attribute password contains one or more of illegal characters \u00a4,|,^,',=, , ");
        }
    }

    private static String verifyAndGetUserPassword(AttrList attrList) throws WrongAttributeTypeException, NotHandledAttributeTypeException, MoNotFoundException, IllegalInputDataException {
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "verifyAndGetUserPassword(AttrList anAttributeList)", "anAttributeList: " + attrList);
        }
        String string = "anonymous";
        int n = attrList.indexOf("password");
        if (n == -1) {
            return string;
        }
        if (!(attrList.getValue(n) instanceof String)) {
            Trace.error(UpgradePackageCreator.class, "checkAndGetPassword ( AttrList anAttributeList )", "Attribute 'password' shall be of the type string but is not.\n\tAttribute 'password': " + attrList.getValue(n));
            throw new WrongAttributeTypeException("password", "UpgradePackage");
        }
        UpgradePackageCreator.validateForIllegalCharacters((String)attrList.getValue(n));
        string = (String)attrList.getValue(n);
        attrList.removeElementAt(n);
        return string;
    }

    private static void verifyThatUpgradePackageMO_DoNotExist(String string, ProductDataContainer productDataContainer, Coordinator coordinator) throws MoNameAlreadyTakenException, ProductNumberAndRevisionAlreadyInUseException, CreateException {
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "verifyThatUpgradePackageMO_DoNotExist(String aNamingAttributeValue, ProductDataContainer aProductData)", "aNamingAttributeValue: " + string + "\n\taProductData: " + productDataContainer);
        }
        try {
            Object object;
            if (string != null && !string.equals(EMPTY_STRING) && (object = UpgradePackageCreator.lookup(string)) != null) {
                Trace.info(UpgradePackageCreator.class, "verifyThatUpgradePackageMO_DoNotExist(String aNamingAttributeValue, ProductDataContainer aProductData)", "An upgrade package MO with requested identity (naming attribute value) '" + object.getLocalDistinguishedName() + "' already exists" + "\n\tCreation of Upgrade Package MO is aborted.");
                throw new MoNameAlreadyTakenException("An upgrade package MO with requested identity (naming attribute value) '" + object.getLocalDistinguishedName() + "' already exists");
            }
            if (UpgradePackageCreator.isProductNumberAndRevisionKnown(productDataContainer.getNumber(), productDataContainer.getRevision(), coordinator)) {
                Trace.info(UpgradePackageCreator.class, "verifyThatUpgradePackageMO_DoNotExist(String aNamingAttributeValue, ProductDataContainer aProductData)", "Upgrade Package MO with requested product number ( = " + productDataContainer.getNumber() + " )" + "\n\tand revision ( = " + productDataContainer.getRevision() + " ) already exists." + "\n\tCreation of Upgrade Package MO is aborted.");
                throw new ProductNumberAndRevisionAlreadyInUseException("The request to create an upgrade package MO with the product number " + productDataContainer.getNumber() + " and revision " + productDataContainer.getRevision() + " has been rejected due to the product number and revision is in use.");
            }
            object = SuLib.createUpgradePackageDocumentId(productDataContainer.getNumber(), productDataContainer.getRevision());
            if (!SuLib.isUpgradePackageDocumentID_Unique((String)object)) {
                Trace.info(UpgradePackageCreator.class, "verifyThatUpgradePackageMO_DoNotExist(String aNamingAttributeValue, ProductDataContainer aProductData)", "The Upgrade Package ID (i.e. its product number + '_' + product revision) is more than 40 characters long and \n\tthere exists at least an other upgrade package where the first 40 characters are identical to this one.\n\tThis is not allowed due to it will cause problem at deletion of upgrade packages later on\n\tThis Upgrade Package document ID: " + (String)object);
                throw new CreateException("The Upgrade Package ID (i.e. its product number + '_' + product revision) is more than 40 characters long and \n\tthere exists at least an other upgrade package where the first 40 characters are identical to this one.\n\tThis is not allowed due to it will cause problem at deletion of upgrade packages later on\n\tThis Upgrade Package document ID: " + (String)object);
            }
        }
        catch (MoNameAlreadyTakenException moNameAlreadyTakenException) {
            throw moNameAlreadyTakenException;
        }
        catch (ProductNumberAndRevisionAlreadyInUseException productNumberAndRevisionAlreadyInUseException) {
            throw productNumberAndRevisionAlreadyInUseException;
        }
        catch (CreateException createException) {
            throw createException;
        }
        catch (Throwable throwable) {
            Trace.error(UpgradePackageCreator.class, "verifyThatUpgradePackageMO_DoNotExist(String aNamingAttributeValue, ProductDataContainer aProductData)", "Failed to lookup given naming identity. MoAccessException caught with reason " + throwable + "\n\taNamingAttributeValue: " + string + "\n\taProductData: " + productDataContainer, throwable);
            throw new CreateException(throwable.toString());
        }
    }
}

