/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.install;

import java.util.Vector;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.swmanagement.suaccess.RepertoireMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.SwAllocationMoSU_Access;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class RepertoireCollector {
    public RepertoireCollector() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "RepertoireCollector()");
        }
    }

    public Vector getConnectedRepertoires(Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getConnectedRepertoires(Coordinator aCoordinator)", "\taCoordinator: " + coordinator);
        }
        Vector<String> vector = new Vector<String>();
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("SwAllocation");
            if (moIterator == null) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getConnectedRepertoires(Coordinator aCoordinator)", "No SwAllocation found i.e. no repertoires in the UCF will be used during upgrade.");
                }
                return vector;
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getConnectedRepertoires(Coordinator aCoordinator)", "Number of found SwAllocations: " + moIterator.size());
            }
            String string = null;
            while (moIterator.hasMoreElements()) {
                SwAllocationMoSU_Access swAllocationMoSU_Access = (SwAllocationMoSU_Access)moIterator.nextMo();
                ManagedObject[] managedObjectArray = swAllocationMoSU_Access.getRepertoireList(coordinator);
                ManagedObject[] managedObjectArray2 = swAllocationMoSU_Access.getSlotList(coordinator);
                if (managedObjectArray != null && managedObjectArray.length > 0 && managedObjectArray2 != null && managedObjectArray2.length > 0) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "getConnectedRepertoires(Coordinator aCoordinator)", "The SWA " + swAllocationMoSU_Access.getRole(coordinator) + " is connected i.e. have repertoires and slots assigned to it.");
                    }
                    for (int i = 0; i < managedObjectArray.length; ++i) {
                        string = ((RepertoireMoSU_Access)managedObjectArray[i]).getName(coordinator);
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "getConnectedRepertoires(Coordinator aCoordinator)", "Adding repertoire " + string + " to the repertoire list.");
                        }
                        vector.addElement(string);
                    }
                    continue;
                }
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, "getConnectedRepertoires(Coordinator aCoordinator)", "The SWA " + swAllocationMoSU_Access + " is not connected.");
            }
            return vector;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "getConnectedRepertoires(Coordinator aCoordinator)", "Failed to collect connected SWA's.\n\tMoAccessException reason: " + moAccessException.getMessage(), moAccessException);
            throw moAccessException;
        }
    }
}

