/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.upgrade.step.rebootpiuupgrade;

import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.SAXException;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.support.thread.ActionListener;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.step.ExecutableOp;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootpiuupgrade.PIU_AdmStateHandler;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootpiuupgrade.PIU_AdmStateHandlerException;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootpiuupgrade.PIU_AdmStateHandlerFactory;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootpiuupgrade.UpgradeablePIU_AdmStateListenerInterface;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;

public final class UnlockAndWaitOp
implements ExecutableOp,
UpgradeablePIU_AdmStateListenerInterface {
    private boolean myNoRpMove;
    private Vector myPIUsToUnlock = null;

    public UnlockAndWaitOp(Vector vector, Vector vector2, Vector vector3, boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "UnlockAndWaitOp(Vector aSuggestedPIUsToUnlock, Vector aFaultyPIUsLockedBeforeUpgrade, Vector aNonSupportedPIUsLockedBeforeUpgrade, boolean aNoRpuMove)", "aSuggestedPIUsToUnlock: " + vector + "\n\taFaultyPIUsLockedBeforeUpgrade: " + vector2 + "\n\taNonSupportedPIUsLockedBeforeUpgrade: " + vector3 + "\n\taNoRpuMove: " + bl);
        }
        this.myPIUsToUnlock = this.selectPIUsToUnlock(vector, vector2, vector3);
        this.myNoRpMove = bl;
    }

    public synchronized void executeOp(ActionListener actionListener) throws SAXException {
        Trace.log1(this.getClass(), "executeOp(ActionListener observer)", "Execute private operation 'UnlockAndWait'.");
        if (!this.myPIUsToUnlock.isEmpty()) {
            this.requestPIUsToUnlock(this.myPIUsToUnlock);
            this.waitForPIUsUnlockIndication();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "executeOp(ActionListener observer)", "UnlockAndWait executed, all expected PIUs have been unlocked.");
            }
        } else if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "executeOp(ActionListener observer)", "UnlockAndWait executed, no PIUs to unlock.");
        }
    }

    private Vector selectPIUsToUnlock(Vector vector, Vector vector2, Vector vector3) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "selectPIUsToUnlock(Vector aSuggestedPIUsToUnlock, Vector aFaultyPIUsLockedBeforeUpgrade, Vector aNonSupportedPIUsLockedBeforeUpgrade)", "aSuggestedPIUsToUnlock: " + vector + "\n\taFaultyPIUsLockedBeforeUpgrade: " + vector2 + "\n\taNonSupportedPIUsLockedBeforeUpgrade: " + vector3);
        }
        Iterator iterator = vector2.iterator();
        while (iterator.hasNext()) {
            vector.removeElement(iterator.next());
        }
        iterator = vector3.iterator();
        while (iterator.hasNext()) {
            vector.removeElement(iterator.next());
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "selectPIUsToUnlock(Vector aSuggestedPIUsToUnlock, Vector aFaultyPIUsLockedBeforeUpgrade, Vector aNonSupportedPIUsLockedBeforeUpgrade)", "The PIUs To Be Unlocked are: " + vector);
        }
        return vector;
    }

    private void requestPIUsToUnlock(Vector vector) throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "requestPIUsToUnlock(Vector aPIUsToUnlock)", "aPIUsToUnlock: " + vector);
        }
        Control control = null;
        GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = null;
        try {
            control = Transaction.create();
            Coordinator coordinator = Transaction.getCoordinator(control);
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)iterator.next();
                PIU_AdmStateHandlerFactory pIU_AdmStateHandlerFactory = PIU_AdmStateHandlerFactory.instance();
                PIU_AdmStateHandler pIU_AdmStateHandler = pIU_AdmStateHandlerFactory.createPIU_AdmStateHandler();
                if (this.myNoRpMove) {
                    pIU_AdmStateHandler.setAdministrativeStateSwitchReq(genericUpgradeablePlugInUnit, 1, 2, coordinator);
                    if (!Trace.valid(this.getClass(), 22)) continue;
                    Trace.debug(this.getClass(), 22, "requestPIUsToUnlock(Vector aPIUsToUnlock)", "The setting of the administrative state (no switch at lock) to 'UNLOCKED' for\n\tPIU '" + genericUpgradeablePlugInUnit + "' has been requested." + "\n\tmyNoRpMove: " + this.myNoRpMove);
                    continue;
                }
                pIU_AdmStateHandler.setAdministrativeStateReq(genericUpgradeablePlugInUnit, 1, coordinator);
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, "requestPIUsToUnlock(Vector aPIUsToUnlock)", "The setting of the administrative state to 'UNLOCKED' for\n\tPIU '" + genericUpgradeablePlugInUnit + "' has been requested." + "\n\tmyNoRpMove: " + this.myNoRpMove);
            }
            Transaction.commit(control);
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "requestPIUsToUnlock(Vector aPIUsToUnlock)", "Exception caught when trying to set the administrative state of PIUs to unlocked.\n\tcurrent PIU: " + genericUpgradeablePlugInUnit, exception);
            Transaction.rollback(control);
            throw new SAXException(exception.toString());
        }
    }

    private void waitForPIUsUnlockIndication() throws SAXException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "waitForPIUsUnlockIndication()");
        }
        try {
            PIU_AdmStateHandlerFactory pIU_AdmStateHandlerFactory = PIU_AdmStateHandlerFactory.instance();
            PIU_AdmStateHandler pIU_AdmStateHandler = pIU_AdmStateHandlerFactory.getPIU_AdmStateHandler(this.myPIUsToUnlock);
            if (pIU_AdmStateHandler != null) {
                pIU_AdmStateHandler.waitingForAdminStateToBeSet(this);
                pIU_AdmStateHandlerFactory.removePIU_AdmStateHandlers(pIU_AdmStateHandler);
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "waitForPIUsUnlockIndication()", "No PIU admStateHandler was available. proceed the execution anyway.\n\tmyPIUsToUnlock size :" + this.myPIUsToUnlock.size() + "\n\tmyPIUsToUnlock :" + this.myPIUsToUnlock);
            }
        }
        catch (PIU_AdmStateHandlerException pIU_AdmStateHandlerException) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "waitForPIUsUnlockIndication()", "PIU_AdmStateHandlerException caught while waiting for adm state to be set for all requested PIUs.\n\tmyPIUsToUnlock: " + this.myPIUsToUnlock + "\n\tException data: " + pIU_AdmStateHandlerException.toString());
            }
            throw new SAXException("PIU_AdmStateHandlerException caught while waiting for adm state to be set for all requested PIUs.\n\tmyPIUsToUnlock: " + this.myPIUsToUnlock + pIU_AdmStateHandlerException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "waitForPIUsUnlockIndication()", "Exception caught while waiting for adm state to be set for all requested PIUs.\n\tmyPIUsToUnlock: " + this.myPIUsToUnlock, exception);
            throw new SAXException("Exception caught while waiting for adm state to be set for all requested PIUs.\n\tmyPIUsToUnlock: " + this.myPIUsToUnlock + exception.toString());
        }
    }

    public String toString() {
        return "\n\n\tClass: " + this.getClass().getName() + "\n\tmyPIUsToUnlock: " + this.myPIUsToUnlock + "\n\tmyNoRpMove: " + this.myNoRpMove;
    }
}

