/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.upgrade.step.trigger;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.su.uci.suinterface.SuUpgradeMaster;
import se.ericsson.cello.support.thread.ActionEvent;
import se.ericsson.cello.support.thread.ActionListener;
import se.ericsson.cello.support.thread.Alarm;
import se.ericsson.cello.support.thread.BlockingQueue;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeParticipator;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeParticipatorExtended;
import se.ericsson.cello.upgradepackage.main.util.ActionResultData;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.AueCfmWithWarningInfo;
import se.ericsson.cello.upgradepackage.util.datacontainer.AueFailureInfo;
import se.ericsson.cello.upgradepackage.util.datacontainer.AueProgressInfo;
import se.ericsson.cello.upgradepackage.util.datacontainer.SuAueConfirmedWithWarningInfo;
import se.ericsson.cello.upgradepackage.util.datacontainer.SuAueFailureInformation;
import se.ericsson.cello.upgradepackage.util.enumer.TypeOfAUE;
import se.ericsson.cello.upgradepackage.util.library.SuLib;

public class TriggerNotifier
extends Thread
implements SuUpgradeMaster,
ActionListener {
    static final int START = 1;
    static final int CONFIRM_FAILURE = 2;
    static final int CONFIRM_SUCCESS = 3;
    static final int TIMEOUT = 4;
    private Hashtable participatorTable;
    private String triggerName;
    private Alarm clock;
    private int myTimeout = -1;
    private BlockingQueue inQueue = new BlockingQueue();
    private BlockingQueue outQueue = new BlockingQueue();
    int myUP_State = -1;

    public TriggerNotifier(Vector vector, String string, int n, int n2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "TriggerNotifier(Vector participators, String triggerName, int timeout)", "participators: " + vector + "\n\ttriggerName: " + string + "\n\ttimeout: " + n + "\n\tanUP_State: " + n2);
        }
        this.participatorTable = this.constructTable(vector);
        this.triggerName = string;
        this.clock = new Alarm(n * 1000, Alarm.ONE_SHOT);
        this.clock.addActionListener((ActionListener)this);
        this.clock.start();
        this.myTimeout = n;
        this.myUP_State = n2;
    }

    public boolean notifyAndWaitOnAllParticipators() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "notifyAndWaitOnAllParticipators()");
        }
        this.inQueue.enqueue((Object)new Integer(1));
        try {
            return (Boolean)this.outQueue.dequeue();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public synchronized void triggerConfirmed(UpgradeParticipator upgradeParticipator, String string, boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "triggerConfirmed(UpgradeParticipator participator, String triggerName, boolean success)", "\tparticipator: " + upgradeParticipator + "\n\ttriggerName: " + string + "\n\tsuccess: " + bl);
        }
        if (!this.triggerName.equals(string)) {
            Trace.error(this.getClass(), "triggerConfirmed(UpgradeParticipator participator, String triggerName, boolean success)", "Wrong trigger confirmed!? Expected: " + this.triggerName + " Received: " + string);
            return;
        }
        if (!this.participatorTable.containsKey(upgradeParticipator)) {
            if (!this.participatorTable.isEmpty()) {
                Trace.error(this.getClass(), "triggerConfirmed(UpgradeParticipator participator, String triggerName, boolean success)", "Participator table does not contain upgrade participator with name " + upgradeParticipator.participatorName());
            }
            return;
        }
        Reply reply = (Reply)this.participatorTable.get(upgradeParticipator);
        reply.hasConfirmed = true;
        reply.success = bl;
        if (!reply.success) {
            if (upgradeParticipator.participatorName() == null || !upgradeParticipator.participatorName().equals("se.ericsson.cello.upgradepackage.upgrade.step.trigger.UpiTriggerSender")) {
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new AueFailureInfo(this, new String[0], upgradeParticipator.participatorName(), TypeOfAUE.JavaAUE));
            }
            this.inQueue.enqueue((Object)new Integer(2));
        } else {
            if (upgradeParticipator.participatorName() != null && upgradeParticipator.participatorName().equals("se.ericsson.cello.upgradepackage.upgrade.step.trigger.UpiTriggerSender")) {
                Trace.suTestLog(this.getClass(), "triggerConfirmed(UpgradeParticipator participator, String triggerName, boolean success)", "All C-AUE's have now confirmed the trigger '" + string + "'.");
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "triggerConfirmed(UpgradeParticipator participator, String triggerName, boolean success)", "A Java AUE has confirmed the trigger '" + string + "'." + "\n\tAUE Name: " + upgradeParticipator.participatorName());
            }
            this.inQueue.enqueue((Object)new Integer(3));
        }
    }

    public synchronized void triggerConfirmed(UpgradeParticipator upgradeParticipator, String string, int n, String[] stringArray) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "triggerConfirmed(UpgradeParticipator aParticipator, String aTriggerName, int confirmStatus, String[] anAdditionalInfo )", "\tparticipator: " + upgradeParticipator + "\n\ttriggerName: " + string + "\n\tconfirmStatus: " + n + "\n\tanAdditionalInfo: " + SuLib.toString(stringArray));
        }
        if (!this.triggerName.equals(string)) {
            Trace.error(this.getClass(), "triggerConfirmed(UpgradeParticipator aParticipator, String aTriggerName, int confirmStatus, String[] anAdditionalInfo )", "Wrong trigger confirmed!? Expected: " + this.triggerName + " Received: " + string);
            return;
        }
        if (!this.participatorTable.containsKey(upgradeParticipator)) {
            if (!this.participatorTable.isEmpty()) {
                Trace.error(this.getClass(), "triggerConfirmed(UpgradeParticipator aParticipator, String aTriggerName, int confirmStatus, String[] anAdditionalInfo )", "Participator table does not contain upgrade participator with name " + upgradeParticipator.participatorName());
            }
            return;
        }
        Reply reply = (Reply)this.participatorTable.get(upgradeParticipator);
        reply.hasConfirmed = true;
        reply.success = n != 0;
        if (n == 0) {
            if (upgradeParticipator.participatorName() != null && upgradeParticipator.participatorName().equals("se.ericsson.cello.upgradepackage.upgrade.step.trigger.UpiTriggerSender")) {
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new AueFailureInfo(this, stringArray, upgradeParticipator.participatorName(), TypeOfAUE.C_AUE));
            } else {
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new AueFailureInfo(this, stringArray, upgradeParticipator.participatorName(), TypeOfAUE.JavaAUE));
            }
            this.inQueue.enqueue((Object)new Integer(2));
        } else if (n == 1) {
            if (upgradeParticipator.participatorName() != null && upgradeParticipator.participatorName().equals("se.ericsson.cello.upgradepackage.upgrade.step.trigger.UpiTriggerSender")) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "triggerConfirmed(UpgradeParticipator aParticipator, String aTriggerName, int confirmStatus, String[] anAdditionalInfo)", "All C-AUE's have now confirmed the trigger '" + string + "'.");
                }
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "triggerConfirmed(UpgradeParticipator aParticipator, String aTriggerName, int confirmStatus, String[] anAdditionalInfo)", "A Java AUE has confirmed the trigger '" + string + "'." + "\n\tAUE Name: " + upgradeParticipator.participatorName() + "\n\tAdditional Info: " + SuLib.toString(stringArray));
            }
            this.inQueue.enqueue((Object)new Integer(3));
        } else if (n == 2) {
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new AueCfmWithWarningInfo(this, stringArray, upgradeParticipator.participatorName(), TypeOfAUE.JavaAUE));
            this.inQueue.enqueue((Object)new Integer(3));
        }
    }

    public synchronized void triggerConfirmed(UpgradeParticipator upgradeParticipator, String string, int n, ActionResultData[] actionResultDataArray) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "triggerConfirmed(UpgradeParticipator aParticipator, String aTriggerName, int confirmStatus, ActionResultData[] anActionResultData)", "\tparticipator: " + upgradeParticipator + "\n\ttriggerName: " + string + "\n\tconfirmStatus: " + n + "\n\tanAdditionalInfo: " + SuLib.toString(actionResultDataArray));
        }
        if (!this.triggerName.equals(string)) {
            Trace.error(this.getClass(), "triggerConfirmed(UpgradeParticipator aParticipator, String aTriggerName, int confirmStatus, ActionResultData[] anActionResultData)", "Wrong trigger confirmed!? Expected: " + this.triggerName + " Received: " + string);
            return;
        }
        if (!this.participatorTable.containsKey(upgradeParticipator)) {
            if (!this.participatorTable.isEmpty()) {
                Trace.error(this.getClass(), "triggerConfirmed(UpgradeParticipator aParticipator, String aTriggerName, int confirmStatus, ActionResultData[] anActionResultData)", "Participator table does not contain upgrade participator with name " + upgradeParticipator.participatorName());
            }
            return;
        }
        Reply reply = (Reply)this.participatorTable.get(upgradeParticipator);
        reply.hasConfirmed = true;
        reply.success = n != 0;
        if (n == 0) {
            if (upgradeParticipator.participatorName() != null && upgradeParticipator.participatorName().equals("se.ericsson.cello.upgradepackage.upgrade.step.trigger.UpiTriggerSender")) {
                Trace.error(this.getClass(), "triggerConfirmed(UpgradeParticipator aParticipator, String aTriggerName, int confirmStatus, ActionResultData[] anActionResultData)", "A C-AUE has failed at execution of trigger '" + string + "' (see earlier logs for information of which C-AUE that reported failure)." + "\n\tAdditional Info: " + SuLib.toString(actionResultDataArray));
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new SuAueFailureInformation(this, upgradeParticipator.participatorName(), TypeOfAUE.C_AUE, actionResultDataArray));
            } else {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "triggerConfirmed(UpgradeParticipator aParticipator, String aTriggerName, int confirmStatus, ActionResultData[] anActionResultDatas)", "A Java AUE has failed at execution of trigger '" + string + "'." + "\n\tAUE Name: " + upgradeParticipator.participatorName() + "\n\tAdditional Info: " + SuLib.toString(actionResultDataArray));
                }
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new SuAueFailureInformation(this, upgradeParticipator.participatorName(), TypeOfAUE.JavaAUE, actionResultDataArray));
            }
            this.inQueue.enqueue((Object)new Integer(2));
        } else if (n == 1) {
            if (upgradeParticipator.participatorName() != null && upgradeParticipator.participatorName().equals("se.ericsson.cello.upgradepackage.upgrade.step.trigger.UpiTriggerSender")) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "triggerConfirmed(UpgradeParticipator aParticipator, String aTriggerName, int confirmStatus, ActionResultData[] anActionResultDatas)", "All C-AUE's have now confirmed the trigger '" + string + "'.");
                }
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "triggerConfirmed(UpgradeParticipator aParticipator, String aTriggerName, int confirmStatus, ActionResultData[] anActionResultDatas)", "A Java AUE has confirmed the trigger '" + string + "'." + "\n\tAUE Name: " + upgradeParticipator.participatorName() + "\n\tAdditional Info: " + SuLib.toString(actionResultDataArray));
            }
            this.inQueue.enqueue((Object)new Integer(3));
        } else if (n == 2) {
            if (upgradeParticipator.participatorName() != null && upgradeParticipator.participatorName().equals("se.ericsson.cello.upgradepackage.upgrade.step.trigger.UpiTriggerSender")) {
                Trace.info(this.getClass(), "triggerConfirmed(UpgradeParticipator aParticipator, String aTriggerName, int confirmStatus, ActionResultData[] anAdditionalInfo)", "All C-AUE's have now confirmed (with warning info(s) the trigger '" + string + "'.");
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "triggerConfirmed(UpgradeParticipator aParticipator, String aTriggerName, int confirmStatus, ActionResultData[] anAdditionalInfo)", "A Java AUE has confirmed with warning information(s),  the trigger '" + string + "'." + "\n\tAUE Name: " + upgradeParticipator.participatorName() + "\n\tAdditional Info: " + SuLib.toString(actionResultDataArray));
            }
            this.inQueue.enqueue((Object)new Integer(3));
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new SuAueConfirmedWithWarningInfo(this, upgradeParticipator.participatorName(), TypeOfAUE.JavaAUE, actionResultDataArray));
        }
    }

    public synchronized void triggerProgress(UpgradeParticipator upgradeParticipator, String string, String[] stringArray) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "triggerProgress(UpgradeParticipator aParticipator, String aTriggerName, boolean aSuccess, String[] anAdditionalInfo )", "\tparticipator: " + upgradeParticipator + "\n\ttriggerName: " + string + "\n\tanAdditionalInfo: " + SuLib.toString(stringArray));
        }
        if (!this.triggerName.equals(string)) {
            Trace.error(this.getClass(), "triggerProgress(UpgradeParticipator aParticipator, String aTriggerName,String[] anAdditionalInfo )", "Wrong trigger confirmed!? Expected: " + this.triggerName + " Received: " + string);
            return;
        }
        if (!this.participatorTable.containsKey(upgradeParticipator)) {
            if (!this.participatorTable.isEmpty()) {
                Trace.error(this.getClass(), "triggerProgress(UpgradeParticipator aParticipator, String aTriggerName, String[] anAdditionalInfo )", "Participator table does not contain upgrade participator with name " + upgradeParticipator.participatorName());
            }
            return;
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "triggerProgress(UpgradeParticipator aParticipator, String aTriggerName, String[] anAdditionalInfo )", "A Java AUE has sent progress information at execution of trigger '" + this.triggerName + "'." + "\n\tAUE Name: " + upgradeParticipator.participatorName() + "\n\tProgress information: " + SuLib.toString(stringArray));
        }
        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new AueProgressInfo(this, stringArray, upgradeParticipator.participatorName(), TypeOfAUE.JavaAUE));
    }

    public void run() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "run()");
        }
        try {
            while (true) {
                try {
                    block12: while (true) {
                        int n = (Integer)this.inQueue.dequeue();
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "run()", "Incoming message from queue: " + n);
                        }
                        switch (n) {
                            case 1: {
                                if (Trace.valid(this.getClass(), 22)) {
                                    Trace.debug(this.getClass(), 22, "run()", "Incoming message from queue: START i.e. notify all UCI participators");
                                }
                                this.notifyAllParticipators();
                                break;
                            }
                            case 3: {
                                if (Trace.valid(this.getClass(), 22)) {
                                    Trace.debug(this.getClass(), 22, "run()", "Incoming message from queue: CONFIRM_SUCCESS");
                                }
                                if (!this.inQueue.isEmpty() || !this.allParticipatorsHaveConfirmed()) continue block12;
                                this.stopTimer();
                                if (this.allParticipatorsHaveConfirmedWithSuccess()) {
                                    this.outQueue.enqueue((Object)true);
                                } else {
                                    this.outQueue.enqueue((Object)false);
                                }
                                this.participatorTable.clear();
                                return;
                            }
                            case 2: {
                                if (Trace.valid(this.getClass(), 22)) {
                                    Trace.debug(this.getClass(), 22, "run()", "Incoming message from queue: CONFIRM_FAILURE");
                                }
                                this.stopTimer();
                                this.outQueue.enqueue((Object)false);
                                this.participatorTable.clear();
                                return;
                            }
                            case 4: {
                                if (Trace.valid(this.getClass(), 22)) {
                                    Trace.debug(this.getClass(), 22, "run()", "Incoming message from queue: TIMEOUT");
                                }
                                this.stopTimer();
                                this.outQueue.enqueue((Object)false);
                                this.participatorTable.clear();
                                return;
                            }
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    Trace.info(this.getClass(), "run ()", "Interrupted exception caught. Still in while loop");
                    this.stopTimer();
                    this.outQueue.enqueue((Object)false);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "run ()", "RuntimeError", exception);
        }
        catch (Error error) {
            Trace.error(this.getClass(), "run ()", "RuntimeError", error);
        }
    }

    private void stopTimer() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "stopTimer()");
        }
        if (this.clock != null) {
            this.clock.removeActionListener((ActionListener)this);
            this.clock.stop();
        }
        this.clock = null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "actionPerformed(ActionEvent e)", "\te: " + actionEvent);
        }
        if (actionEvent.getActionCommand().equals("expired")) {
            Collection collection = this.findNonConfirmedParticipator();
            Iterator iterator = collection.iterator();
            String string = null;
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (string == null || string.equals("se.ericsson.cello.upgradepackage.upgrade.step.trigger.UpiTriggerSender")) continue;
                String[] stringArray = new String[]{"Timeout in Java-AUE (i.e. the Java-AUE has not confirmed the trigger within specified time)"};
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new AueFailureInfo(this, stringArray, string, TypeOfAUE.JavaAUE));
            }
            Trace.error(this.getClass(), "actionPerformed(ActionEvent e)", "Time out while waiting for confirmation(s) from AUE'sThe upgrade Participators that have not confirmed within pre-defined time are: " + collection + "\n\tThe timeout value (in seconds): " + this.myTimeout);
            this.inQueue.enqueue((Object)new Integer(4));
        }
    }

    private Collection findNonConfirmedParticipator() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "findNonConfirmedParticipator()");
        }
        Enumeration enumeration = this.participatorTable.keys();
        UpgradeParticipator upgradeParticipator = null;
        HashSet<String> hashSet = new HashSet<String>();
        while (enumeration.hasMoreElements()) {
            upgradeParticipator = (UpgradeParticipator)enumeration.nextElement();
            if (((Reply)this.participatorTable.get((Object)upgradeParticipator)).hasConfirmed || upgradeParticipator.participatorName() == null || upgradeParticipator.participatorName().equals("se.ericsson.cello.upgradepackage.upgrade.step.trigger.UpiTriggerSender")) continue;
            hashSet.add(upgradeParticipator.participatorName());
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "findNonConfirmedParticipator()", "RETURNS - " + hashSet);
        }
        return hashSet;
    }

    private Hashtable constructTable(Vector vector) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, " constructTable(Vector participators)", "\tparticipators: " + vector);
        }
        Hashtable<UpgradeParticipator, Reply> hashtable = new Hashtable<UpgradeParticipator, Reply>(vector.size());
        Enumeration enumeration = vector.elements();
        UpgradeParticipator upgradeParticipator = null;
        while (enumeration.hasMoreElements()) {
            upgradeParticipator = (UpgradeParticipator)enumeration.nextElement();
            hashtable.put(upgradeParticipator, new Reply(upgradeParticipator));
        }
        return hashtable;
    }

    private void notifyAllParticipators() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "notifyAllParticipators()", "participatorTable: " + this.participatorTable);
        }
        Enumeration enumeration = this.participatorTable.keys();
        UpgradeParticipator upgradeParticipator = null;
        while (enumeration.hasMoreElements()) {
            upgradeParticipator = (UpgradeParticipator)enumeration.nextElement();
            try {
                if (upgradeParticipator instanceof UpgradeParticipatorExtended) {
                    ((UpgradeParticipatorExtended)upgradeParticipator).triggerIndicated(this, this.triggerName, this.myUP_State);
                } else if (upgradeParticipator instanceof UpgradeParticipator) {
                    upgradeParticipator.triggerIndicated(this, this.triggerName);
                } else {
                    Trace.error(this.getClass(), "notifyAllParticipators()", "An AUE has added itself as listener to trigger with an unknown type of subclass\n\tparticipator: " + upgradeParticipator);
                }
                ((Reply)this.participatorTable.get((Object)upgradeParticipator)).isIndicated = true;
            }
            catch (RuntimeException runtimeException) {
                Trace.error(this.getClass(), "notifyAllParticipators()", "Upgrade participator throws runtime exception when indicated.", runtimeException);
            }
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "notifyAllParticipators()", "Trigger has been sent to all participators\n\ttriggerName: " + this.triggerName + "\n\tparticipatorTable: " + this.participatorTable + "\n\tNoOfParticipators: " + this.participatorTable.size());
        }
    }

    private boolean allParticipatorsHaveConfirmed() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "allParticipatorsHaveConfirmed()");
        }
        Enumeration enumeration = this.participatorTable.elements();
        Reply reply = null;
        while (enumeration.hasMoreElements()) {
            reply = (Reply)enumeration.nextElement();
            if (reply.hasConfirmed) continue;
            return false;
        }
        return true;
    }

    private boolean allParticipatorsHaveConfirmedWithSuccess() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "allParticipatorsHaveConfirmed()");
        }
        Enumeration enumeration = this.participatorTable.elements();
        Reply reply = null;
        while (enumeration.hasMoreElements()) {
            reply = (Reply)enumeration.nextElement();
            if (reply.success) continue;
            Trace.log1(this.getClass(), "allParticipatorsHaveConfirmedWithSuccess()", "participatorTable: " + this.participatorTable + "At least one of the participators has returned failure");
            return false;
        }
        return true;
    }

    public Alarm getClock() {
        return this.clock;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    private class Reply {
        UpgradeParticipator participator;
        boolean isIndicated = false;
        boolean hasConfirmed = false;
        boolean success = false;

        Reply(UpgradeParticipator upgradeParticipator) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "Reply(UpgradeParticipator participator)::inner class to 'TriggerNotifier'", "\tparticipator: " + upgradeParticipator);
            }
            this.participator = upgradeParticipator;
        }

        public String toString() {
            return "\n\tparticipator: " + this.participator + "\n\tisIndicated: " + this.isIndicated + "\n\thasConfirmed: " + this.hasConfirmed + "\n\tsuccess: " + this.success;
        }
    }
}

