/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.eventhandler;

import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.NotifyingUpgradePackagePropertyName;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.PreUpgradeStateInformation;
import se.ericsson.cello.upgradepackage.util.eventhandler.EventClientInterface;

public class RestoreSU_EventHandler
implements PropertyChangeListener {
    private EventClientInterface myUpgradePackage = null;
    private String myAdditionalText = "";

    public RestoreSU_EventHandler(EventClientInterface eventClientInterface, boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "RestoreSU_EventHandler(EventClientInterface anUpgradePackage, boolean anInvokedActionIsRestoreSU)", "anUpgradePackage: " + eventClientInterface + "\n\tanInvokedActionIsRestoreSU: " + bl);
        }
        this.myUpgradePackage = eventClientInterface;
        this.myAdditionalText = bl ? "Invoked action/operation: restoreSU." : "Invoked action/operation: delete (upgradePackage).";
        this.addAsListener();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "aPropertyChangeEvent: " + propertyChangeEvent);
        }
        try {
            if (propertyChangeEvent.getNewValue() instanceof PreUpgradeStateInformation) {
                PreUpgradeStateInformation preUpgradeStateInformation = (PreUpgradeStateInformation)propertyChangeEvent.getNewValue();
                if (preUpgradeStateInformation.getEventId() != -1) {
                    this.handleRestoreSU_ProgressPropertyChange(preUpgradeStateInformation);
                } else if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "PreUpgradeStateInformation containing preUpgradeState=" + PreUpgradeStateInformation.getPreUpgradeStateAsString(preUpgradeStateInformation.getPreUpgradeState()) + " received (and ignored).");
                }
            } else {
                Trace.info(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Unexpected property type received (ignored),\n\taPropertyChangeEvent: " + propertyChangeEvent + "\n\tNewValue: " + propertyChangeEvent.getNewValue());
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Throwable caught.\n\tThrowable data: " + throwable.toString(), throwable);
        }
    }

    public void stop() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "stop( )");
        }
        this.removeAsListener();
        this.myUpgradePackage = null;
        this.myAdditionalText = "";
        if (Trace.valid(this.getClass(), 40)) {
            Trace.debug(this.getClass(), 40, "stop( )", "The RestoreSU_EventHandler has been deactivated.");
        }
    }

    private void addAsListener() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addAsListener( )");
        }
        this.myUpgradePackage.addPropertyChangeListener(NotifyingUpgradePackagePropertyName.PreUpgradeStateInformation, this);
    }

    private void handleRestoreSU_ProgressPropertyChange(PreUpgradeStateInformation preUpgradeStateInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleRestoreSU_ProgressPropertyChange(PreUpgradeStateInformation aPreUpgradeStateInformation)", "aPreUpgradeStateInformation: " + preUpgradeStateInformation);
        }
        this.sendEvent(preUpgradeStateInformation.getEventId(), this.myAdditionalText);
    }

    private void removeAsListener() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeAsListener( )");
        }
        this.myUpgradePackage.removePropertyChangeListener(NotifyingUpgradePackagePropertyName.PreUpgradeStateInformation, this);
    }

    private void sendEvent(int n, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendEvent(int anEventId, String anAdditionalText)", "anEventId: " + n + "\n\tanAdditionalText: " + string);
        }
        AdditionalInfo[] additionalInfoArray = new AdditionalInfo[]{};
        try {
            AlarmManager.getReporter().reportEvent(n, (ManagedObject)this.myUpgradePackage, null, string, additionalInfoArray);
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "sendEvent(int anEventId, String anAdditionalText)", "Event has been sent, id=" + n + ", additional text=" + string);
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "sendEvent(int anEventId, String anAdditionalText)", "Event has been sent.\n\tanEventId: " + n + "\n\tanAdditionalText: " + string);
            }
        }
        catch (Throwable throwable) {
            Trace.info(this.getClass(), "sendEvent(int anEventId, String anAdditionalText)", "Failed to send an event due to Throwable was caught (IGNORED).\n\t\tFullDistinguishedName: " + ((ManagedObject)this.myUpgradePackage).getFullDistinguishedName() + "\n\tType eventId: " + ((ManagedObject)this.myUpgradePackage).getType() + " " + n + "\n\tanAdditionalText: " + string + "\n\tThrowable data: " + throwable.toString());
        }
    }
}

