/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.handler;

import java.util.Collection;
import java.util.LinkedList;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.LoaderName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.TypeOfUpgrade;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.ValidSequencesInformation;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.exceptions.DocumentObjectProxyException;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModulesProxyInterface;
import se.ericsson.cello.sudom.proxy.repertoire.RepertoiresProxyInterface;
import se.ericsson.cello.swmanagement.suaccess.SwAllocationMoSU_Access;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.SwAllocationHelper;
import se.ericsson.cello.upgradepackage.upgrade.SwAllocationHelperException;
import se.ericsson.cello.upgradepackage.util.handler.HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.JvmMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class JvmHandler {
    public Collection getJVM_LMsForTO_State(DocumentObjectProxyInterface documentObjectProxyInterface, ValidSequencesInformation validSequencesInformation) throws HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getJVM_LMsForTO_State(DocumentObjectProxyInterface aDocumentObjectProxyInterface, ValidSequencesInformation aValidSequencesInformation)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taValidSequencesInformation: " + validSequencesInformation);
        }
        try {
            String string = null;
            if (validSequencesInformation.isSupported(TypeOfUpgrade.RebootNodeUpgrade)) {
                string = validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.RebootNodeUpgrade).getFirstSequenceInformation().currentCase;
            } else if (validSequencesInformation.isSupported(TypeOfUpgrade.Upgrade)) {
                string = validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.Upgrade).getFirstSequenceInformation().currentCase;
            } else if (validSequencesInformation.isSupported(TypeOfUpgrade.Update)) {
                string = validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.Update).getFirstSequenceInformation().currentCase;
            } else {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getJVM_LMsForTO_State(String aCase, OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, ValidSequencesInformation aValidSequencesInformation)", "No variant of upgrade is supported and therefor not possible to collect the Java LMs to be used in TO state.\n\taValidSequencesInformation: " + validSequencesInformation);
                }
                return new LinkedList();
            }
            return this.getJVM_LMsForTO_State(documentObjectProxyInterface, string);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getJVM_LMsForTO_State()", "Throwable caught," + throwable);
            throw new HandlerException(throwable);
        }
    }

    public Collection getCurrentConnectedRepertoires() throws HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getCurrentConnectedRepertoires()");
        }
        try {
            JvmMO_HandlerInterface jvmMO_HandlerInterface = ServiceFinder.getJvmMO_HandlerInterface();
            SwAllocationMoSU_Access swAllocationMoSU_Access = (SwAllocationMoSU_Access)jvmMO_HandlerInterface.getJvmMO().getReservedSwAllocationMo(null);
            SwAllocationHelper swAllocationHelper = new SwAllocationHelper();
            return swAllocationHelper.getConnectedRepertoirNames(swAllocationMoSU_Access);
        }
        catch (SwAllocationHelperException swAllocationHelperException) {
            throw new HandlerException((Throwable)((Object)swAllocationHelperException));
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getCurrentConnectedRepertoires()", "Throwable caught", throwable);
            throw new HandlerException(throwable);
        }
    }

    public Collection getJVM_LMsForTO_State(DocumentObjectProxyInterface documentObjectProxyInterface, String string) throws HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getJVM_LMsForTO_State(DocumentObjectProxyInterface aDocumentObjectProxyInterface, String aCase)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taCase: " + string);
        }
        try {
            Collection collection = this.getCurrentConnectedRepertoires();
            Collection collection2 = documentObjectProxyInterface.getRepertoireNamesToBeUsed(collection, string);
            Collection collection3 = null;
            if (!collection2.isEmpty()) {
                RepertoiresProxyInterface repertoiresProxyInterface = documentObjectProxyInterface.getRepertoiresProxyInterface();
                collection3 = repertoiresProxyInterface.getProductNumberAndRevisionsOfAllLoadModulesConnectedToRepertoires(collection2);
            } else {
                collection3 = this.getJVM_LMsFromUCF(documentObjectProxyInterface);
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getJVM_LMsForTO_State(DocumentObjectProxyInterface aDocumentObjectProxyInterface, String aCase)", "RETURNS - theLoadModules: " + collection3);
            }
            return collection3;
        }
        catch (DocumentObjectProxyException documentObjectProxyException) {
            throw new HandlerException((Throwable)((Object)documentObjectProxyException));
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getJVM_LMsForTO_State(DocumentObjectProxyInterface aDocumentObjectProxyInterface, String aCase)", "Throwable caught", throwable);
            throw new HandlerException(throwable);
        }
    }

    private Collection getJVM_LMsFromUCF(DocumentObjectProxyInterface documentObjectProxyInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getJVM_LMsFromUCF(DocumentObjectProxyInterface aDocumentObjectProxyInterface)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface);
        }
        LoadModulesProxyInterface loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface();
        LinkedList<LoaderName> linkedList = new LinkedList<LoaderName>();
        linkedList.add(LoaderName.JVM);
        Collection collection = loadModulesProxyInterface.getLoadModulesWithLoaderNames(linkedList);
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getConnectedRepertoires(DocumentObjectProxyInterface aDocumentObjectProxyInterface, ValidSequencesInformation aValidSequencesInformation)", "RETURNS theLoadModules: " + collection);
        }
        return collection;
    }
}

