/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.nsi;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.LoaderName;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumbersAndRevisions;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.commonpiutypelist.CommonPiuTypeListInterface;
import se.ericsson.cello.sudom.proxy.commonpiutypelist.CommonPiuTypeListProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModulesProxyInterface;
import se.ericsson.cello.sudom.proxy.mandatorypiutypelist.MandatoryPiuTypeListProxyInterface;
import se.ericsson.cello.sudom.proxy.nodetypespecificpiutypelist.NodeTypeSpecificPiuTypeListInterface;
import se.ericsson.cello.sudom.proxy.nodetypespecificpiutypelist.NodeTypeSpecificPiuTypeListsProxyInterface;
import se.ericsson.cello.sudom.proxy.repertoire.RepertoiresProxyInterface;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.nsi.NSI_AdapterException;
import se.ericsson.cello.upgradepackage.util.nsi.NSI_AdapterNoNodeTypeListFoundException;
import se.ericsson.cello.upgradepackage.util.nsi.NSI_Selector;
import se.ericsson.cello.upgradepackage.util.nsi.SelectedNodeTypeListInformation;

public class NSI_Adapter {
    public NSI_Adapter() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "NSI_Adapter( )");
        }
    }

    public Collection getRequiredLoadModules(DocumentObjectProxyInterface documentObjectProxyInterface) throws NSI_AdapterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRequiredLoadModules(DocumentObjectProxyInterface aDocumentObjectProxy)", "aDocumentObjectProxy: " + documentObjectProxyInterface);
        }
        try {
            ProductNumbersAndRevisions productNumbersAndRevisions = new ProductNumbersAndRevisions();
            Collection collection = this.getLoadModulesReferencedByNodeTypeSpecificPiuTypes(documentObjectProxyInterface);
            productNumbersAndRevisions.addElements(new ProductNumbersAndRevisions(new Vector(collection)));
            collection = this.getLoadModulesReferencedByCommonPiuTypes(documentObjectProxyInterface);
            productNumbersAndRevisions.addElements(new ProductNumbersAndRevisions(new Vector(collection)));
            collection = this.getLoadModulesReferencedByMandatoryPiuTypes(documentObjectProxyInterface);
            productNumbersAndRevisions.addElements(new ProductNumbersAndRevisions(new Vector(collection)));
            collection = this.getAllLoadModulesOfTypesJVM_OtherAndWebserver(documentObjectProxyInterface);
            productNumbersAndRevisions.addElements(new ProductNumbersAndRevisions(new Vector(collection)));
            return productNumbersAndRevisions.getElements();
        }
        catch (NSI_AdapterException nSI_AdapterException) {
            throw nSI_AdapterException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getRequiredLoadModules(DocumentObjectProxyInterface aDocumentObjectProxy)", "Throwable caught.\n\taDocumentObjectProxy: " + documentObjectProxyInterface, throwable);
            throw new NSI_AdapterException("Class name: " + this.getClass().getName() + "\n\tgetRequiredLoadModules(DocumentObjectProxyInterface aDocumentObjectProxy)" + "\n\tThrowable caught." + "\n\taDocumentObjectProxy: " + documentObjectProxyInterface + "\n\tOriginal Throwable: " + throwable);
        }
    }

    private Collection getLoadModulesReferencedByNodeTypeSpecificPiuTypes(DocumentObjectProxyInterface documentObjectProxyInterface) throws NSI_AdapterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModulesReferencedByPiuTypesInNodeTypeSpecificPiuTypeList(DocumentObjectProxyInterface aDocumentObjectProxy)", "aDocumentObjectProxy: " + documentObjectProxyInterface);
        }
        Collection collection = this.getNodeTypeSpecificPiuTypes(documentObjectProxyInterface);
        RepertoiresProxyInterface repertoiresProxyInterface = documentObjectProxyInterface.getRepertoiresProxyInterface();
        Collection collection2 = repertoiresProxyInterface.getLoadModulesConnectedToPiuTypes(collection);
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "getLoadModulesReferencedByPiuTypesInNodeTypeSpecificPiuTypeList(DocumentObjectProxyInterface aDocumentObjectProxy, String aNodeTypeSpecificPiuTypeListName)", "RETURNS - theLoadModules: " + collection2);
        }
        return collection2;
    }

    private Collection getNodeTypeSpecificPiuTypes(DocumentObjectProxyInterface documentObjectProxyInterface) throws NSI_AdapterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNodeTypeSpecificPiuTypes(DocumentObjectProxyInterface aDocumentObjectProxy)", "aDocumentObjectProxy: " + documentObjectProxyInterface);
        }
        NSI_Selector nSI_Selector = new NSI_Selector();
        SelectedNodeTypeListInformation selectedNodeTypeListInformation = nSI_Selector.getNodeTypeSpecificListName(documentObjectProxyInterface);
        Collection collection = null;
        if (!selectedNodeTypeListInformation.isMatchingNodeTypeListFound()) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getNodeTypeSpecificPiuTypes(DocumentObjectProxyInterface aDocumentObjectProxy)", "No matching NodeTypeSpecificPiuTypeList was found, aborting the installation attempt\n\ttheSelectedNodeTypeListInformation: " + selectedNodeTypeListInformation);
            }
            throw new NSI_AdapterNoNodeTypeListFoundException("No matching NodeTypeSpecificPiuTypeList was found", selectedNodeTypeListInformation);
        }
        NodeTypeSpecificPiuTypeListsProxyInterface nodeTypeSpecificPiuTypeListsProxyInterface = documentObjectProxyInterface.getNodeTypeSpecificPiuTypeListsProxyInterface();
        NodeTypeSpecificPiuTypeListInterface nodeTypeSpecificPiuTypeListInterface = nodeTypeSpecificPiuTypeListsProxyInterface.getNodeTypeSpecificPiuTypeList(selectedNodeTypeListInformation.getName());
        collection = nodeTypeSpecificPiuTypeListInterface.getProductNumberAndRevisionInterfacesForPiuTypes();
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "getNodeTypeSpecificPiuTypes(DocumentObjectProxyInterface aDocumentObjectProxy)", "RETURNS - theNodeTypeSpecificPiuTypes: " + collection);
        }
        return collection;
    }

    private Collection getLoadModulesReferencedByCommonPiuTypes(DocumentObjectProxyInterface documentObjectProxyInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModulesReferencedByCommonPiuTypes(DocumentObjectProxyInterface aDocumentObjectProxy)", "aDocumentObjectProxy: " + documentObjectProxyInterface);
        }
        Collection collection = new HashSet();
        CommonPiuTypeListProxyInterface commonPiuTypeListProxyInterface = documentObjectProxyInterface.getCommonPiuTypeListProxyInterface();
        CommonPiuTypeListInterface commonPiuTypeListInterface = commonPiuTypeListProxyInterface.getCommonPiuTypeList();
        if (commonPiuTypeListInterface != null) {
            RepertoiresProxyInterface repertoiresProxyInterface = documentObjectProxyInterface.getRepertoiresProxyInterface();
            collection = repertoiresProxyInterface.getLoadModulesConnectedToPiuTypes(commonPiuTypeListInterface.getProductNumberAndRevisionInterfacesForPiuTypes());
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "getLoadModulesReferencedByCommonPiuTypes(DocumentObjectProxyInterface aDocumentObjectProxy)", "RETURNS - theLoadModules: " + collection);
        }
        return collection;
    }

    private Collection getLoadModulesReferencedByMandatoryPiuTypes(DocumentObjectProxyInterface documentObjectProxyInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModulesReferencedByMandatoryPiuTypes(DocumentObjectProxyInterface aDocumentObjectProxy)", "aDocumentObjectProxy: " + documentObjectProxyInterface);
        }
        MandatoryPiuTypeListProxyInterface mandatoryPiuTypeListProxyInterface = documentObjectProxyInterface.getMandatoryPiuTypeListProxyInterface();
        RepertoiresProxyInterface repertoiresProxyInterface = documentObjectProxyInterface.getRepertoiresProxyInterface();
        Collection collection = repertoiresProxyInterface.getLoadModulesConnectedToPiuTypes(mandatoryPiuTypeListProxyInterface.getProductNumberAndRevisionsForPiuTypes());
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "getLoadModulesReferencedByMandatoryPiuTypes(DocumentObjectProxyInterface aDocumentObjectProxy)", "RETURNS - theLoadModules: " + collection);
        }
        return collection;
    }

    private Collection getAllLoadModulesOfTypesJVM_OtherAndWebserver(DocumentObjectProxyInterface documentObjectProxyInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAllLoadModulesOfTypesJVM_OtherAndWebserver(DocumentObjectProxyInterface aDocumentObjectProxy)", "aDocumentObjectProxy: " + documentObjectProxyInterface);
        }
        LoadModulesProxyInterface loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface();
        LinkedList<LoaderName> linkedList = new LinkedList<LoaderName>();
        linkedList.add(LoaderName.JVM);
        linkedList.add(LoaderName.Webserver);
        linkedList.add(LoaderName.Other);
        Collection collection = loadModulesProxyInterface.getLoadModulesWithLoaderNames(linkedList);
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "getAllLoadModulesOfTypesJVM_OtherAndWebserver(DocumentObjectProxyInterface aDocumentObjectProxy)", "RETURNS - theLoadModules: " + collection);
        }
        return collection;
    }
}

