/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.transaction;

import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.NoPermissionException;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Status;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.transaction.TransactionException;

public class Transaction {
    public static void checkSecurity(MoData moData) throws TransactionException {
        Coordinator coordinator = null;
        try {
            Control control = Transaction.create(20);
            coordinator = Transaction.getCoordinator(control);
            try {
                moData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            }
            catch (NoPermissionException noPermissionException) {
                Transaction.rollback(control);
                throw new TransactionException("Not allowed to continue due to security reasons, see further origin exception.", (MoAccessException)((Object)noPermissionException));
            }
            catch (TransactionRequiredException transactionRequiredException) {
                Trace.warning(Transaction.class, "checkSecurity()", "A transaction is required to be able to handle the transaction for write access.Exception data: " + (Object)((Object)transactionRequiredException) + "Transaction: " + SuLib.toString(coordinator));
            }
            Transaction.rollback(control);
        }
        catch (TransactionException transactionException) {
            if (Trace.valid(Transaction.class, 22)) {
                Trace.debug(Transaction.class, 22, "checkSecurity()", "The internal transaction used for security check prevents the execution to continue.\n\tTransactionException data: " + transactionException.toString());
            }
            throw transactionException;
        }
    }

    public static Control create() throws TransactionException {
        try {
            return TransactionServiceImpl.instance().getTransactionFactory().create(3600);
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            Trace.error(Transaction.class, "create( )", "TransactionRolledBackedException caught when trying to create a transaction.\n\tdefault timout value used in create request: 3600 seconds", transactionRolledBackException);
            throw new TransactionException("TransactionRolledBackedException caught when trying to create a transaction.\n\tDefault timout value used in create request: 3600 seconds.", (Exception)((Object)transactionRolledBackException));
        }
    }

    public static Control create(int n) throws TransactionException {
        try {
            return TransactionServiceImpl.instance().getTransactionFactory().create(n);
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            Trace.error(Transaction.class, "create(int aTimeoutValueInSeconds)", "TransactionRolledBackedException caught when trying to create a transaction.\n\taTimeoutValueInSeconds: " + n, transactionRolledBackException);
            throw new TransactionException("TransactionRolledBackedException caught when trying to create a transaction.\n\taTimeoutValueInSeconds: " + n, (Exception)((Object)transactionRolledBackException));
        }
    }

    public static void commit(Control control) throws TransactionException {
        if (control != null) {
            try {
                control.getTerminator().commit();
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                Trace.error(Transaction.class, "commit(Control aControl)", "TransactionRolledBackedException caught when trying to commit a transaction.", transactionRolledBackException);
                throw new TransactionException("TransactionRolledBackedException caught when trying to commit a transaction.", (Exception)((Object)transactionRolledBackException));
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                Trace.error(Transaction.class, "commit(Control aControl)", "InactiveTransactionException caught when trying to commit a transaction.", inactiveTransactionException);
                throw new TransactionException("InactiveTransactionException caught when trying to commit a transaction.", (Exception)((Object)inactiveTransactionException));
            }
        }
    }

    public static Coordinator getCoordinator(Control control) {
        return control.getCoordinator();
    }

    public static void rollback(Control control) {
        if (control != null) {
            try {
                Status status = control.getCoordinator().getStatus();
                if (status == Status.ACTIVE || status == Status.MARKED_ROLLBACK) {
                    control.getTerminator().rollback();
                }
            }
            catch (Exception exception) {
                Trace.error(Transaction.class, "rollback(Control aControl)", "Exception caught when trying to rollback a transaction." + Transaction.toString(control), exception);
            }
            catch (Error error) {
                Trace.error(Transaction.class, "rollback(Control aControl)", "Error caught when trying to rollback a transaction." + Transaction.toString(control), error);
            }
        }
    }

    public static String toString(Control control) {
        String string = "";
        if (control != null) {
            try {
                Coordinator coordinator = control.getCoordinator();
                int n = coordinator.getTransactionID();
                string = string + "\n\tTransaction ID: " + n;
                String string2 = "UNKNOWN";
                if (coordinator.getStatus() == Status.ACTIVE) {
                    string2 = "ACTIVE";
                } else if (coordinator.getStatus() == Status.MARKED_ROLLBACK) {
                    string2 = "MARKED_ROLLBACK";
                } else if (coordinator.getStatus() == Status.NO_TRANSACTION) {
                    string2 = "NO_TRANSACTION";
                }
                string = string + "\n\tTransaction status: " + string2;
            }
            catch (Exception exception) {
                if (Trace.valid(Transaction.class, 20)) {
                    Trace.debug(Transaction.class, 20, "toString(Control aControl)", "Exception caught: " + exception.toString());
                }
                string = string + exception.toString();
            }
        }
        return string;
    }

    public static String toString(Coordinator coordinator) {
        String string = "";
        if (coordinator != null) {
            try {
                int n = coordinator.getTransactionID();
                string = string + "\n\tTransaction ID: " + n;
                String string2 = "UNKNOWN";
                if (coordinator.getStatus() == Status.ACTIVE) {
                    string2 = "ACTIVE";
                } else if (coordinator.getStatus() == Status.MARKED_ROLLBACK) {
                    string2 = "MARKED_ROLLBACK";
                } else if (coordinator.getStatus() == Status.NO_TRANSACTION) {
                    string2 = "NO_TRANSACTION";
                }
                string = string + "\n\tTransaction status: " + string2;
            }
            catch (Exception exception) {
                if (Trace.valid(Transaction.class, 20)) {
                    Trace.debug(Transaction.class, 20, "toString(Coordinator aCoordinator)", "Exception caught: " + exception.toString());
                }
                string = string + exception.toString();
            }
        }
        return string;
    }
}

