/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.verify;

import java.util.Collection;
import java.util.Vector;
import se.ericsson.cello.configurationversion.verify.ucf.UCF_ChecksumInformation;
import se.ericsson.cello.managedelement.suaccess.SU_ConditionalException;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.constants.SystemUpgradeConstantsInterface;
import se.ericsson.cello.su.froproxy.cv.interfaces.ChecksumListResultInformation;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.ChecksumFileResultInformation;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.ChecksumFileResultInterface;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.OsaSwInstallProxyAccess;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.util.datacontainer.ProductDataContainer;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.ChecksumErrorLoadModuleContainer;
import se.ericsson.cello.upgradepackage.util.datacontainer.UCF_ControlResultContainer;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;
import se.ericsson.cello.upgradepackage.verify.ChecksumFileWriter;
import se.ericsson.cello.upgradepackage.verify.ChecksumFileWriterException;
import se.ericsson.cello.upgradepackage.verify.ChecksumHandlerException;
import se.ericsson.cello.upgradepackage.verify.event.BlockingVerifyRequestEvent;
import se.ericsson.cello.upgradepackage.verify.event.VerifyRequestEvent;

public class ChecksumHandler {
    public Vector checksumLoadModules(DocumentObjectProxyInterface documentObjectProxyInterface, Vector vector, Collection collection, VerifyRequestEvent verifyRequestEvent) throws ChecksumFileWriterException, ChecksumHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checksumLoadModules(DocumentObjectProxyInterface aDocumentObjectProxyInterface, java.util.Vector aLoadModulesToBeChecksum, Collection aLoadModulesBeExculded, VerifyRequestEvent aVerifyRequestEvent)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLoadModulesToBeChecksum: " + vector.size() + "\n\taLoadModulesBeExculded: " + collection.size() + "\n\taLoadModulesBeExculded: " + collection + "\n\taVerifyRequestEvent: " + verifyRequestEvent);
        }
        if (!collection.isEmpty()) {
            for (int i = 0; i < vector.size(); ++i) {
                if (!collection.contains(vector.get(i))) continue;
                vector.remove(vector.get(i));
                --i;
            }
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checksumLoadModules(DocumentObjectProxyInterface aDocumentObjectProxyInterface, java.util.Vector aLoadModulesToBeChecksum, Collection aLoadModulesBeExculded, VerifyRequestEvent aVerifyRequestEvent)", "FOR UP " + verifyRequestEvent.upgradePackageDocumentNumber + "_" + verifyRequestEvent.upgradePackageDocumentRevision + ": " + vector.size() + " LoadModule(s) need to be checksum and " + collection.size() + " LoadModule(s) are omitted.");
            Trace.debug(this.getClass(), 20, "checksumLoadModules(DocumentObjectProxyInterface aDocumentObjectProxyInterface, java.util.Vector aLoadModulesToBeChecksum, Collection aLoadModulesBeExculded, VerifyRequestEvent aVerifyRequestEvent)", "LoadModules need to be checksum: " + vector.size() + "\n\tLoadModules need to be checksum: " + vector);
        }
        return this.checksumLoadModules(documentObjectProxyInterface, vector, verifyRequestEvent);
    }

    public Vector checksumLoadModules(DocumentObjectProxyInterface documentObjectProxyInterface, Vector vector, VerifyRequestEvent verifyRequestEvent) throws ChecksumFileWriterException, ChecksumHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checksumLoadModules(DocumentObjectProxyInterface aDocumentObjectProxyInterface, java.util.Vector aLoadModulesToBeChecksum, VerifyRequestEvent aVerifyRequestEvent)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taLoadModulesToBeChecksum: " + vector + "\n\taVerifyRequestEvent: " + verifyRequestEvent);
        }
        ChecksumFileWriter checksumFileWriter = new ChecksumFileWriter();
        ProductDataContainer productDataContainer = new ProductDataContainer(verifyRequestEvent.upgradePackageDocumentNumber, verifyRequestEvent.upgradePackageDocumentRevision, verifyRequestEvent.upgradePackageProductName, verifyRequestEvent.upgradePackageProductionDate, verifyRequestEvent.upgradePackageType, "");
        SystemUpgradeConstantsInterface systemUpgradeConstantsInterface = (SystemUpgradeConstantsInterface)ServiceLocatorFacade.getRepository().getService(SystemUpgradeConstantsInterface.class);
        String string = systemUpgradeConstantsInterface.getNodeTmpRootPath() + "checksum.xml";
        boolean bl = false;
        if (verifyRequestEvent instanceof BlockingVerifyRequestEvent) {
            bl = ((BlockingVerifyRequestEvent)verifyRequestEvent).isHealtCheckRequested;
        }
        String string2 = checksumFileWriter.writeToChecksumFile(documentObjectProxyInterface, vector, productDataContainer, string, bl);
        this.sendSignalChecksumRequest(string2);
        return this.waitForResponseFromChecksumRequest();
    }

    public UCF_ControlResultContainer checksumUCF(UpgradePackageMoExtended upgradePackageMoExtended) throws ChecksumHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checksumUCF(UpgradePackageMoExtended anUpgradePackageMo)", "anUpgradePackageMo: " + upgradePackageMoExtended);
        }
        try {
            UCF_ControlResultContainer uCF_ControlResultContainer = new UCF_ControlResultContainer(upgradePackageMoExtended.getDocumentNumber(null), upgradePackageMoExtended.getDocumentRevision(null), this.checksumUCF(upgradePackageMoExtended.getUpgradeControlFilePath(null)), this.checksumUCF(upgradePackageMoExtended.getOriginalUpgradeControlFilePath(null)), upgradePackageMoExtended.getUcfChecksum(null), upgradePackageMoExtended.getOrigUcfChecksum(null), upgradePackageMoExtended.getUpgradeControlFilePath(null), upgradePackageMoExtended.getOriginalUpgradeControlFilePath(null));
            return uCF_ControlResultContainer;
        }
        catch (ChecksumHandlerException checksumHandlerException) {
            throw checksumHandlerException;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "checksumUCF(UpgradePackageMoExtended anUpgradePackageMo)", "Failed to check the checksum of the UCF files, MoAccessException caught.", moAccessException);
            throw new ChecksumHandlerException("Failed to check the checksum of the UCF files, MoAccessException caught.");
        }
    }

    public UCF_ChecksumInformation checkChecksumForFile(UpgradePackageMoExtended upgradePackageMoExtended, String string, boolean bl) throws ChecksumHandlerException {
        try {
            ChecksumFileResultInterface checksumFileResultInterface = this.checksumUCF(string);
            if (!checksumFileResultInterface.getChecksumOK()) {
                Trace.info(this.getClass(), "checkChecksumForFile(UpgradePackageMoExtended anUP_Mo, String aFilepath, boolean anIsOrig)", "OSA SwInstall FRO failed to calculate the checksum for an UCF\n\tanUP_Mo: " + upgradePackageMoExtended + "\n\taFilepath: " + string + "\n\tanIsOrig: " + bl);
                throw new ChecksumHandlerException("OSA SwInstall FRO failed to calculate the checksum for an UCF\n\tanUP_Mo: " + upgradePackageMoExtended + "\n\taFilepath: " + string + "\n\tanIsOrig: " + bl);
            }
            String string2 = upgradePackageMoExtended.getUcfChecksum(null);
            if (bl) {
                string2 = upgradePackageMoExtended.getOrigUcfChecksum(null);
            }
            return new UCF_ChecksumInformation(upgradePackageMoExtended.getDocumentNumber(null), upgradePackageMoExtended.getDocumentRevision(null), string, string2, checksumFileResultInterface.getChecksum());
        }
        catch (ChecksumHandlerException checksumHandlerException) {
            throw checksumHandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "checkChecksumForFile(UpgradePackageMoExtended anUP_Mo, String aFilepath)", "anUP_Mo: " + upgradePackageMoExtended + "\n\taFilepath: " + string, throwable);
            throw new ChecksumHandlerException(throwable.toString());
        }
    }

    public void setChecksum(UpgradePackageMoExtended upgradePackageMoExtended, String string) throws ChecksumHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setChecksum(UpgradePackageMoExtended anUP_Mo, String aFilepath)", "anUP_Mo: " + upgradePackageMoExtended + "\n\taFilepath: " + string);
        }
        try {
            Control control = Transaction.create();
            Coordinator coordinator = Transaction.getCoordinator(control);
            ChecksumFileResultInterface checksumFileResultInterface = this.checksumUCF(string);
            upgradePackageMoExtended.setCurrentUcfChecksum(checksumFileResultInterface.getChecksum(), coordinator);
            Transaction.commit(control);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setChecksum(UpgradePackageMoExtended anUP_Mo, String aFilepath)", "Throwable caughtanUP_Mo: " + upgradePackageMoExtended + "\n\taFilepath: " + string, throwable);
            throw new ChecksumHandlerException(throwable.toString());
        }
    }

    public ChecksumFileResultInterface checksumUCF(String string) throws ChecksumHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checksumUCF(String aFilepath)", "aFilepath: " + string);
        }
        return this.sendSignalChecksumFileRequest(string);
    }

    public void setCurrentUcfChecksumInUp(UpgradePackageMoExtended upgradePackageMoExtended, String string) throws ChecksumHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setCurrentUcfChecksumInUp(UpgradePackageMoExtended anUpgradePackageMO, String aCurrentUcfFilePath)", "anUpgradePackageMO: " + upgradePackageMoExtended + "\n\taCurrentUcfFilePath: " + string);
        }
        Control control = null;
        Coordinator coordinator = null;
        try {
            ChecksumHandler checksumHandler = new ChecksumHandler();
            ChecksumFileResultInterface checksumFileResultInterface = checksumHandler.checksumUCF(string);
            if (!checksumFileResultInterface.getChecksumOK()) {
                Trace.error(this.getClass(), "setCurrentUcfChecksumInUp(UpgradePackageMoExtended anUpgradePackageMO, String aCurrentUcfFilePath)", "Fro failed to calculate checksum for ucf. Error information: " + checksumFileResultInterface.getErrorInfo());
                throw new ChecksumHandlerException("Fro failed to calculate checksum for ucf. Error information: " + checksumFileResultInterface.getErrorInfo());
            }
            control = Transaction.create();
            coordinator = Transaction.getCoordinator(control);
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "setCurrentUcfChecksumInUp(UpgradePackageMoExtended anUpgradePackageMO, String aCurrentUcfFilePath)", "Setting ucf checksum value in UP " + upgradePackageMoExtended.getLocalDistinguishedName() + " to " + checksumFileResultInterface.getChecksum());
            }
            upgradePackageMoExtended.setCurrentUcfChecksum(checksumFileResultInterface.getChecksum(), coordinator);
            Transaction.commit(control);
        }
        catch (ChecksumHandlerException checksumHandlerException) {
            throw checksumHandlerException;
        }
        catch (Throwable throwable) {
            if (control != null) {
                Transaction.rollback(control);
            }
            Trace.error(this.getClass(), "setCurrentUcfChecksumInUp(UpgradePackageMoExtended anUpgradePackageMO, String aCurrentUcfFilePath)", "anUpgradePackageMO: " + upgradePackageMoExtended + "\n\taCurrentUcfFilePath: " + string + "\n\tThrowable caught when requesting for checksum calculation", throwable);
            throw new ChecksumHandlerException("Throwable caught when requesting for checksum calculation of ucf: " + throwable.toString());
        }
    }

    private void sendSignalChecksumRequest(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendSignalChecksumRequest(String aChecksumControlFilePath)", "aChecksumControlFilePath: " + string);
        }
        try {
            OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
            osaSwInstallProxyAccess.sendAsynchOsaSwChecksumListReq(string);
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            Trace.warning(this.getClass(), "sendSignalChecksumRequest(String aChecksumControlFilePath)", "aChecksumControlFilePath: " + string + "\n\tFroNotAccessibleException: " + (Object)((Object)froNotAccessibleException));
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "sendSignalChecksumRequest(String aChecksumControlFilePath)", "\n\tSignal OsaSwChecksumListReq sent to the install proxy at Osa layer.");
        }
    }

    private ChecksumFileResultInterface sendSignalChecksumFileRequest(String string) throws ChecksumHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendSignalChecksumFileRequest(String aFilepath)", "aFilepath: " + string);
        }
        ChecksumFileResultInterface checksumFileResultInterface = null;
        try {
            OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
            if (SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_6", (Object)osaSwInstallProxyAccess)) {
                checksumFileResultInterface = osaSwInstallProxyAccess.sendOsaSwChecksumFileReq(string);
            } else {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "sendSignalChecksumFileRequest(String aFilepath)", "SU access version 6 not supported by OsaSwInstall");
                }
                checksumFileResultInterface = new ChecksumFileResultInformation(true, "", string, "");
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "sendSignalChecksumFileRequest(String aFilepath)", "Returning - theChecksumFileResultInterface: " + checksumFileResultInterface);
            }
            return checksumFileResultInterface;
        }
        catch (SU_ConditionalException sU_ConditionalException) {
            Trace.error(this.getClass(), "sendSignalChecksumFileRequest(String aFilepath)", "Failed to look up the version of Osa Sw Install function (aborting)");
            throw new ChecksumHandlerException("Failed to send checksum UCF request, SU_ConditionalException caught.");
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            Trace.warning(this.getClass(), "sendSignalChecksumFileRequest(String aFilepath)", "aFilepath: " + string + "\n\tFroNotAccessibleException: " + (Object)((Object)froNotAccessibleException));
            throw new ChecksumHandlerException("Failed to send checksum UCF request, FroNotAccessibleException caught.");
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "sendSignalChecksumFileRequest(String aFilepath)", "Failed to look up the version of Osa Sw Install function, throwable caught.", throwable);
            throw new ChecksumHandlerException("Failed to look up the version of Osa Sw Install function, throwable caught: " + throwable.toString());
        }
    }

    private Vector waitForResponseFromChecksumRequest() throws ChecksumHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "waitForResponseFromChecksumRequest()");
        }
        Vector<ChecksumErrorLoadModuleContainer> vector = new Vector<ChecksumErrorLoadModuleContainer>(1);
        try {
            ChecksumListResultInformation checksumListResultInformation = null;
            OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
            while (true) {
                checksumListResultInformation = osaSwInstallProxyAccess.receiveOsaSwChecksumListRsp();
                if (checksumListResultInformation.typeOfResponse == 0) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "waitForResponseFromChecksumRequest()", "Type of response: CELLO_SW_CHECKSUM_RESULT_ONE_FILE");
                    }
                    if (checksumListResultInformation.checksumOK) continue;
                    ChecksumErrorLoadModuleContainer checksumErrorLoadModuleContainer = new ChecksumErrorLoadModuleContainer(checksumListResultInformation.loadModuleID, checksumListResultInformation.loadModulePath, checksumListResultInformation.piuLinkHandlerName, checksumListResultInformation.errorInformation);
                    vector.addElement(checksumErrorLoadModuleContainer);
                    continue;
                }
                if (checksumListResultInformation.typeOfResponse == 1) {
                    if (!Trace.valid(this.getClass(), 22)) break;
                    Trace.debug(this.getClass(), 22, "waitForResponseFromChecksumRequest()", "Type of response: CELLO_SW_CHECKSUM_EXECUTION_FINISHED");
                    break;
                }
                Trace.warning(this.getClass(), "waitForResponseFromChecksumRequest()", "Unexpected type in response signal 'OsaSwChecksumListRsp'.\n\tType: " + checksumListResultInformation.typeOfResponse);
            }
            return vector;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "waitForResponseFromChecksumRequest()", "Exception caught: " + exception.toString(), exception);
            throw new ChecksumHandlerException("\n\tWhen waiting for response from the checksum request from the resource layer \n\tan unexpected exception was caught.\n\tOrigin Exception: " + exception.toString());
        }
        catch (Error error) {
            Trace.error(this.getClass(), "waitForResponseFromChecksumRequest()", "Error caught: " + error.toString(), error);
            throw new ChecksumHandlerException("\n\tWhen waiting for response from the checksum request from the resource layer \n\tan unexpected error was caught.\n\tOrigin Error: " + error.toString());
        }
    }
}

